/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.base.filter.AbstractChannelsFilter;
import org.lsst.ccs.gconsole.plugins.monitor.AbstractMonitorView;
import org.lsst.ccs.gconsole.plugins.monitor.LazyTreeView;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorFormat;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorView;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;
import org.lsst.ccs.gconsole.services.persist.Persistable;
import org.lsst.ccs.gconsole.services.persist.PersistenceService;

public abstract class GroupView
extends AbstractMonitorView {
    protected Descriptor descriptor = new Descriptor();
    private final TreeMap<String, Object> views = new TreeMap((s1, s2) -> {
        if (s1 == null) {
            if (s2 == null) {
                return 0;
            }
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        return s1.compareTo((String)s2);
    });
    private final Map<String, TreeSet<String>> subgroups = new HashMap<String, TreeSet<String>>();
    protected int depth;
    protected String currentGroup;
    protected LinkedList<String> selectionHistory;

    @Override
    public final void addChannels(List<AgentInfo> agents, List<Map.Entry<String, AgentChannel>> channels) {
        LinkedHashMap<String, List> channelsByGroup = new LinkedHashMap<String, List>();
        channels.forEach(e -> {
            String[] ss = this.separateGroup((String)e.getKey());
            if (ss != null) {
                AgentChannel ch = (AgentChannel)e.getValue();
                ArrayList<AbstractMap.SimpleEntry<String, AgentChannel>> groupChannels = (ArrayList<AbstractMap.SimpleEntry<String, AgentChannel>>)channelsByGroup.get(ss[0]);
                if (groupChannels == null) {
                    groupChannels = new ArrayList<AbstractMap.SimpleEntry<String, AgentChannel>>(128);
                    channelsByGroup.put(ss[0], groupChannels);
                }
                groupChannels.add(new AbstractMap.SimpleEntry<String, AgentChannel>(ss[1], ch));
            }
        });
        ArrayList<String> newGroups = new ArrayList<String>();
        channelsByGroup.forEach((group, cc) -> {
            Object o = this.views.get(group);
            if (o == null) {
                this.views.put((String)group, cc);
                this.addToSubgroups((String)group);
                newGroups.add((String)group);
            } else if (o instanceof AbstractMonitorView) {
                ((AbstractMonitorView)o).addChannels(agents, (List<Map.Entry<String, AgentChannel>>)cc);
            } else {
                ((List)o).addAll(cc);
            }
        });
        if (!newGroups.isEmpty()) {
            this.groupsAdded(newGroups);
        }
        if (this.currentGroup == null) {
            this.selectGroup(null);
        }
    }

    @Override
    public final void removeChannels(List<AgentInfo> agents, List<Map.Entry<String, AgentChannel>> channels) {
        LinkedHashMap<String, List> channelsByGroup = new LinkedHashMap<String, List>();
        channels.forEach(e -> {
            String[] ss = this.separateGroup((String)e.getKey());
            if (ss != null) {
                AgentChannel ch = (AgentChannel)e.getValue();
                ArrayList<AbstractMap.SimpleEntry<String, AgentChannel>> groupChannels = (ArrayList<AbstractMap.SimpleEntry<String, AgentChannel>>)channelsByGroup.get(ss[0]);
                if (groupChannels == null) {
                    groupChannels = new ArrayList<AbstractMap.SimpleEntry<String, AgentChannel>>(128);
                    channelsByGroup.put(ss[0], groupChannels);
                }
                groupChannels.add(new AbstractMap.SimpleEntry<String, AgentChannel>(ss[1], ch));
            }
        });
        ArrayList<String> deadGroups = new ArrayList<String>();
        channelsByGroup.forEach((group, cc) -> {
            Object o = this.views.get(group);
            if (o instanceof AbstractMonitorView) {
                AbstractMonitorView view = (AbstractMonitorView)o;
                view.removeChannels(agents, (List<Map.Entry<String, AgentChannel>>)cc);
            } else if (o instanceof List) {
                Set displayPathsToRemove = channels.stream().map(e -> (String)e.getKey()).collect(Collectors.toSet());
                List groupChannels = (List)o;
                Iterator it = groupChannels.iterator();
                while (it.hasNext()) {
                    if (!displayPathsToRemove.contains(((Map.Entry)it.next()).getKey())) continue;
                    it.remove();
                }
                if (groupChannels.isEmpty()) {
                    deadGroups.add((String)group);
                    this.views.remove(group);
                    this.removeFromSubgroups((String)group);
                }
            }
        });
        if (!deadGroups.isEmpty()) {
            this.groupsRemoved(deadGroups);
        }
    }

    @Override
    public final void updateChannels(List<Map.Entry<String, Map.Entry<AgentChannel, List<String>>>> channels) {
        ArrayList<Map.Entry<String, Map.Entry<AgentChannel, List<String>>>> currentChannels;
        if (this.currentGroup != null && this.currentGroup.isEmpty()) {
            return;
        }
        if (channels == null) {
            currentChannels = null;
        } else {
            currentChannels = new ArrayList<Map.Entry<String, Map.Entry<AgentChannel, List<String>>>>(128);
            channels.forEach(e -> {
                String[] ss = this.separateGroup((String)e.getKey());
                if (ss != null && Objects.equals(this.currentGroup, ss[0])) {
                    currentChannels.add(new AbstractMap.SimpleEntry(ss[1], e.getValue()));
                }
            });
        }
        Object o = this.views.get(this.currentGroup);
        if (o instanceof AbstractMonitorView) {
            ((AbstractMonitorView)o).updateChannels(currentChannels);
        }
    }

    protected String[] separateGroup(String displayPath) {
        switch (this.descriptor.depth) {
            case 0: {
                int i = displayPath.indexOf("//");
                if (i == -1) {
                    return new String[]{null, displayPath};
                }
                return new String[]{displayPath.substring(0, i), displayPath.substring(i + 2)};
            }
            case 1: {
                String[] stringArray;
                String[] ss = displayPath.split("/+", 2);
                if (ss.length == 2) {
                    stringArray = ss;
                } else {
                    String[] stringArray2 = new String[2];
                    stringArray2[0] = null;
                    stringArray = stringArray2;
                    stringArray2[1] = displayPath;
                }
                return stringArray;
            }
        }
        String[] gg = displayPath.split("/+", this.descriptor.depth + 1);
        StringJoiner group = new StringJoiner("/");
        int n = gg.length - 1;
        for (int ii = 0; ii < n; ++ii) {
            group.add(gg[ii]);
        }
        return new String[]{group.toString(), gg[n]};
    }

    protected String mergeGroup(String group, String path) {
        String delimeter = this.descriptor.depth == 0 ? "//" : "/";
        return group == null ? path : group + delimeter + path;
    }

    protected String[] getPath(String group) {
        if (group == null || group.isEmpty()) {
            return new String[0];
        }
        return group.split("/", this.descriptor.depth);
    }

    protected AbstractMonitorView createView(String group) {
        AbstractMonitorView view = null;
        AbstractMonitorView.Descriptor viewDescriptor = null;
        HashMap<String, AbstractMonitorView.Descriptor> m = this.getDescriptor().getViews();
        if (m != null) {
            viewDescriptor = (AbstractMonitorView.Descriptor)m.get(group);
        }
        if (viewDescriptor == null) {
            viewDescriptor = this.getDescriptor().getDefaultView();
        }
        if (viewDescriptor != null) {
            view = (AbstractMonitorView)PersistenceService.getService().make(viewDescriptor);
        }
        if (view == null) {
            view = (LazyTreeView)PersistenceService.getService().make("MonitorView", "Built-In/Basic/Tree", new Object[0]);
            String[] ff = this.getDescriptor().getFields();
            if (ff != null) {
                view.getDescriptor().setFields(ff);
            }
            if ((ff = this.getDescriptor().getCompactFields()) != null) {
                view.getDescriptor().setCompactFields(ff);
            }
        }
        if (view.getFilter() == null) {
            view.setFilter(new Filter(group));
        }
        if (this.formatter != null) {
            view.setFormatter(this.formatter);
        }
        return view;
    }

    protected void selectGroup(String group) {
        Object g;
        Iterator it;
        String prefix;
        if (this.views.isEmpty()) {
            this.currentGroup = "";
            this.groupSelected();
            return;
        }
        if (group != null && ((String)group).equals("")) {
            Object object = group = this.selectionHistory == null || this.selectionHistory.isEmpty() ? null : this.selectionHistory.getFirst();
        }
        if (!this.views.containsKey(group) && this.selectionHistory != null && !this.selectionHistory.isEmpty()) {
            prefix = group == null ? "" : (String)group + "/";
            it = this.selectionHistory.listIterator();
            while (it.hasNext()) {
                g = (String)it.next();
                if (!((String)g).startsWith(prefix)) continue;
                it.remove();
                group = g;
                break;
            }
        }
        if (!this.views.containsKey(group)) {
            if (group == null) {
                group = this.views.firstKey();
            } else {
                prefix = (String)group + "/";
                boolean notFound = true;
                for (String g2 : this.views.navigableKeySet()) {
                    if (g2 == null || !g2.startsWith(prefix)) continue;
                    group = g2;
                    notFound = false;
                    break;
                }
                if (notFound) {
                    group = this.views.firstKey();
                }
            }
        }
        this.currentGroup = group;
        if (this.currentGroup != null) {
            if (this.selectionHistory == null) {
                this.selectionHistory = new LinkedList();
            } else {
                String[] ss = this.getPath(this.currentGroup);
                it = this.selectionHistory.iterator();
                while (it.hasNext()) {
                    g = (String)it.next();
                    String[] gg = this.getPath(this.currentGroup);
                    if (gg.length > ss.length) continue;
                    int n = Math.min(gg.length, ss.length - 1);
                    boolean remove = true;
                    for (int i = 0; i < n; ++i) {
                        if (ss[i].equals(gg[i])) continue;
                        remove = false;
                        break;
                    }
                    if (!remove) continue;
                    it.remove();
                }
            }
            this.selectionHistory.addFirst(this.currentGroup);
        }
        this.getView(this.currentGroup).updateChannels(null);
        this.groupSelected();
    }

    @Override
    public void setFormatter(MonitorFormat formatter) {
        super.setFormatter(formatter);
        this.views.values().forEach(o -> {
            if (o instanceof MonitorView) {
                ((MonitorView)o).setFormatter(formatter);
            }
        });
    }

    protected abstract void groupsAdded(List<String> var1);

    protected abstract void groupsRemoved(List<String> var1);

    protected abstract void groupSelected();

    protected final AbstractMonitorView getView(String group) {
        Object o = this.views.get(group);
        if (o instanceof AbstractMonitorView) {
            return (AbstractMonitorView)o;
        }
        AbstractMonitorView view = this.createView(group);
        this.views.put(group, view);
        if (o instanceof List) {
            List channels = (List)o;
            HashMap nameToInfo = new HashMap();
            channels.stream().forEach(e -> {
                AgentChannel ch = (AgentChannel)e.getValue();
                nameToInfo.putIfAbsent(ch.getAgentName(), ch.getAgent());
            });
            view.addChannels(new ArrayList<AgentInfo>(nameToInfo.values()), channels);
        }
        return view;
    }

    protected final boolean hasGroup(String group) {
        return this.views.containsKey(group);
    }

    protected final String[] getSubgroups(String parent) {
        TreeSet<String> gg = this.subgroups.get(parent);
        if (gg == null) {
            return this.hasGroup(parent) ? new String[]{} : null;
        }
        return gg.toArray(new String[0]);
    }

    private void addToSubgroups(String group) {
        String[] ss = this.getPath(group);
        int n = ss.length;
        String parent = null;
        for (int i = 0; i < n; ++i) {
            TreeSet<String> sg = this.subgroups.get(parent);
            if (sg == null) {
                sg = new TreeSet();
                if (this.hasGroup(parent)) {
                    sg.add("");
                }
                this.subgroups.put(parent, sg);
            }
            sg.add(ss[i]);
            parent = parent == null ? ss[i] : parent + "/" + ss[i];
        }
        TreeSet<String> set = this.subgroups.get(group);
        if (set != null) {
            set.add("");
        }
        if (n > this.depth) {
            this.depth = n;
        }
    }

    private void removeFromSubgroups(String group) {
        String[] ss = this.getPath(group);
        int n = ss.length;
        String parent = null;
        for (int i = 0; i < n; ++i) {
            TreeSet<String> sg = this.subgroups.get(parent);
            sg.remove(ss[i]);
            if (sg.size() == 1 && sg.contains("")) {
                this.subgroups.remove(parent);
            }
            parent = parent == null ? ss[i] : parent + "/" + ss[i];
        }
        TreeSet<String> set = this.subgroups.get(group);
        if (set != null) {
            set.remove("");
        }
        int newDepth = 0;
        for (String g : this.views.keySet()) {
            String[] gg = this.getPath(g);
            if (gg.length <= newDepth) continue;
            newDepth = gg.length;
        }
        this.depth = newDepth;
    }

    @Override
    public Descriptor save() {
        Descriptor desc = this.descriptor.clone();
        if (this.views.isEmpty()) {
            desc.setViews(null);
        } else {
            HashMap<String, AbstractMonitorView.Descriptor> dd = new HashMap<String, AbstractMonitorView.Descriptor>();
            desc.setViews(dd);
            for (Map.Entry<String, Object> e : this.views.entrySet()) {
                if (!(e.getValue() instanceof AbstractMonitorView)) continue;
                dd.put(e.getKey(), ((AbstractMonitorView)e.getValue()).save());
            }
        }
        if (this.selectionHistory != null && !this.selectionHistory.isEmpty()) {
            Descriptor.access$102(desc, this.selectionHistory.toArray(new String[0]));
        } else if (this.currentGroup != null) {
            Descriptor.access$102(desc, new String[]{this.currentGroup});
        } else {
            Descriptor.access$102(desc, null);
        }
        return desc;
    }

    @Override
    public void restore(Persistable.Descriptor descriptor) {
        if (descriptor instanceof Descriptor) {
            this.descriptor = (Descriptor)descriptor.clone();
            this.depth = this.descriptor.depth;
            HashMap<String, AbstractMonitorView.Descriptor> dd = this.descriptor.getViews();
            if (dd != null) {
                for (Map.Entry<String, AbstractMonitorView.Descriptor> e : dd.entrySet()) {
                    Object v = this.views.get(e.getKey());
                    if (!(v instanceof AbstractMonitorView)) continue;
                    ((AbstractMonitorView)v).restore(e.getValue());
                }
            }
            if (this.descriptor.selectionHistory != null && this.descriptor.selectionHistory.length > 0) {
                this.selectionHistory = new LinkedList<String>(Arrays.asList(this.descriptor.selectionHistory));
                this.selectGroup(this.descriptor.selectionHistory[0]);
            }
        }
    }

    @Override
    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    @Create(category="AgentChannelsFilter", name="Explicit group tester", path="Test/Explicit group", description="")
    public static AbstractChannelsFilter test1() {
        return new AbstractChannelsFilter(){

            @Override
            public String getDisplayPath(AgentChannel channel) {
                String type = (String)channel.get(AgentChannel.Key.DATA_TYPE);
                String path = channel.getPath();
                if (type == null) {
                    return path;
                }
                switch (type) {
                    case "CONFIGURATION": {
                        return path.replaceFirst("/", "//");
                    }
                    case "STATE": {
                        return "state/" + channel.getAgentName() + "//" + channel.getLocalPath();
                    }
                }
                return path;
            }
        };
    }

    public static class Descriptor
    extends AbstractMonitorView.Descriptor {
        private HashMap<String, AbstractMonitorView.Descriptor> views;
        private String[] selectionHistory;
        private int depth;
        private AbstractMonitorView.Descriptor defaultView;

        public AbstractMonitorView.Descriptor getDefaultView() {
            return this.defaultView;
        }

        public void setDefaultView(AbstractMonitorView.Descriptor defaultView) {
            this.defaultView = defaultView;
        }

        public int getDepth() {
            return this.depth;
        }

        public void setDepth(int depth) {
            this.depth = depth;
        }

        public String[] getSelectionHistory() {
            return this.selectionHistory;
        }

        public void setSelectionHistory(String[] selectionHistory) {
            this.selectionHistory = selectionHistory;
        }

        public HashMap<String, AbstractMonitorView.Descriptor> getViews() {
            return this.views;
        }

        public void setViews(HashMap<String, AbstractMonitorView.Descriptor> views) {
            this.views = views;
        }

        @Override
        public Descriptor clone() {
            Descriptor desc = (Descriptor)super.clone();
            if (desc.views != null) {
                desc.views = new HashMap<String, AbstractMonitorView.Descriptor>(desc.views);
                desc.views.entrySet().forEach(e -> e.setValue(((AbstractMonitorView.Descriptor)e.getValue()).clone()));
            }
            if (desc.defaultView != null) {
                desc.defaultView = desc.defaultView.clone();
            }
            return desc;
        }

        static /* synthetic */ String[] access$102(Descriptor x0, String[] x1) {
            x0.selectionHistory = x1;
            return x1;
        }
    }

    protected class Filter
    extends AbstractChannelsFilter {
        private final String group;

        public Filter(String group) {
            this.group = group;
        }

        @Override
        public String getName() {
            String name = GroupView.this.filter.getName();
            if (name != null && this.group != null && !this.group.isEmpty()) {
                name = name + ":" + this.group;
            }
            return name;
        }

        @Override
        public List<String> getAgents() {
            return GroupView.this.filter.getAgents();
        }

        @Override
        public List<String> getOriginChannels() {
            return GroupView.this.filter.getOriginChannels();
        }

        @Override
        public List<String> getDisplayChannels() {
            return this.filterGroup(GroupView.this.filter.getDisplayChannels());
        }

        @Override
        public String getOriginPath(String displayPath) {
            return GroupView.this.filter.getOriginPath(GroupView.this.mergeGroup(this.group, displayPath));
        }

        @Override
        public List<String> getDisplayPaths(AgentChannel channel) {
            return this.filterGroup(GroupView.this.filter.getDisplayPaths(channel));
        }

        @Override
        public List<String> getDisplayPaths(String originPath) {
            return this.filterGroup(GroupView.this.filter.getDisplayPaths(originPath));
        }

        @Override
        public List<String> getFields(boolean compact) {
            return GroupView.this.filter.getFields(compact);
        }

        private List<String> filterGroup(List<String> in) {
            if (in == null) {
                return null;
            }
            return in.stream().map(c -> GroupView.this.separateGroup((String)c)).filter(ss -> ss != null).map(ss -> ss[1]).collect(Collectors.toList());
        }
    }
}

