/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.CompilationException;
import gnu.jel.DVMap;
import gnu.jel.LocalField;
import gnu.jel.LocalMethod;
import gnu.jel.OP;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class Library {
    private HashMap<String, HashMap<String, Member>> names;
    private HashMap<Member, Integer> dynIDs;
    private HashMap<Member, Boolean> stateless;
    private HashMap<Class, HashMap<String, HashMap<String, Member>>> dotClasses;
    private boolean noDotSecurity = false;
    public DVMap resolver;
    public HashMap<String, Class> cnmap;

    @Deprecated
    public Library(Class[] classArray, Class[] classArray2) {
        this(classArray, classArray2, null);
    }

    @Deprecated
    public Library(Class[] classArray, Class[] classArray2, Class[] classArray3) {
        this(classArray, classArray2, classArray3, null);
    }

    @Deprecated
    public Library(Class[] classArray, Class[] classArray2, Class[] classArray3, DVMap dVMap) {
        this(classArray, classArray2, classArray3, dVMap, null);
    }

    public Library(Class[] classArray, Class[] classArray2, Class[] classArray3, DVMap dVMap, HashMap<String, Class> hashMap) {
        this.cnmap = hashMap;
        this.resolver = dVMap;
        if (classArray3 == null) {
            this.dotClasses = null;
        } else {
            this.noDotSecurity = classArray3.length == 0;
            this.dotClasses = new HashMap();
            Class[] classArray4 = new Class[1];
            for (int i = 0; i < classArray3.length; ++i) {
                this.rehash(classArray3[i]);
            }
        }
        this.names = new HashMap();
        this.dynIDs = new HashMap();
        this.stateless = new HashMap();
        if (classArray != null) {
            Library.rehash(classArray, this.names, null, this.stateless);
        }
        if (classArray2 != null) {
            Library.rehash(classArray2, this.names, this.dynIDs, null);
        }
    }

    private void rehash(Class clazz) {
        HashMap<String, HashMap<String, Member>> hashMap = new HashMap<String, HashMap<String, Member>>();
        Class[] classArray = new Class[]{clazz};
        Library.rehash(classArray, hashMap, new HashMap<Member, Integer>(), null);
        this.dotClasses.put(clazz, hashMap);
    }

    private static void rehash(Class[] classArray, HashMap<String, HashMap<String, Member>> hashMap, HashMap<Member, Integer> hashMap2, HashMap<Member, Boolean> hashMap3) {
        for (int i = 0; i < classArray.length; ++i) {
            Integer n = new Integer(i);
            Method[] methodArray = classArray[i].getMethods();
            Field[] fieldArray = classArray[i].getFields();
            int n2 = methodArray.length;
            int n3 = n2 + fieldArray.length;
            for (int j = 0; j < n3; ++j) {
                Method method;
                AccessibleObject accessibleObject = method = j < n2 ? methodArray[j] : fieldArray[j - n2];
                if ((method.getModifiers() & 8) > 0) {
                    if (hashMap3 == null || !Library.rehash(hashMap, method)) continue;
                    hashMap3.put(method, Boolean.TRUE);
                    continue;
                }
                if (hashMap2 == null || !Library.rehash(hashMap, method)) continue;
                hashMap2.put(method, n);
            }
        }
    }

    private static boolean rehash(HashMap<String, HashMap<String, Member>> hashMap, Member member) {
        HashMap<String, Member> hashMap2;
        String string = member.getName();
        String string2 = Library.getSignature(member);
        if (Library.isField(member)) {
            string2 = "()" + string2;
        }
        if ((hashMap2 = hashMap.get(string)) == null) {
            HashMap<String, Member> hashMap3 = new HashMap<String, Member>();
            hashMap3.put(string2, member);
            hashMap.put(string, hashMap3);
            return true;
        }
        Member member2 = hashMap2.get(string2);
        if (member2 == null) {
            hashMap2.put(string2, member);
            return true;
        }
        return false;
    }

    public void markStateDependent(String string, Class[] classArray) throws CompilationException {
        Member member = this.getMember(null, string, classArray);
        Boolean bl = this.stateless.remove(member);
    }

    public boolean isStateless(Member member) {
        return this.stateless.containsKey(member);
    }

    public Member getMember(Class clazz, String string, Class[] classArray) throws CompilationException {
        Iterator<Member> iterator;
        Class[] classArray2;
        Member member2;
        HashMap<String, Member> hashMap;
        HashMap<String, HashMap<String, Member>> hashMap2 = this.names;
        if (clazz != null) {
            if (this.dotClasses == null) {
                throw new CompilationException(11, null);
            }
            if (!this.noDotSecurity && !this.dotClasses.containsKey(clazz)) {
                Object[] objectArray = new Object[]{clazz};
                throw new CompilationException(12, objectArray);
            }
            hashMap2 = this.dotClasses.get(clazz);
            if (hashMap2 == null) {
                this.rehash(clazz);
                hashMap2 = this.dotClasses.get(clazz);
            }
        }
        if ((hashMap = hashMap2.get(string)) == null) {
            Object[] objectArray = new Object[]{string, clazz};
            throw new CompilationException(clazz == null ? 5 : 6, objectArray);
        }
        ArrayList<Member> arrayList = new ArrayList<Member>();
        for (Member member2 : hashMap.values()) {
            classArray2 = Library.getParameterTypes(member2);
            boolean bl = false;
            if (classArray != null) {
                if (classArray2.length == classArray.length) {
                    bl = true;
                    for (int i = 0; i < classArray2.length && bl; ++i) {
                        bl = OP.isWidening(classArray[i], classArray2[i]);
                    }
                }
            } else {
                boolean bl2 = bl = classArray2.length == 0;
            }
            if (!bl) continue;
            arrayList.add(member2);
        }
        if (arrayList.size() == 0) {
            iterator = new Object[]{string, Library.describe(string, classArray), clazz};
            throw new CompilationException(clazz == null ? 7 : 8, (Object[])iterator);
        }
        if (arrayList.size() == 1) {
            return (Member)arrayList.get(0);
        }
        iterator = arrayList.iterator();
        member2 = iterator.next();
        classArray2 = Library.getParameterTypes(member2);
        while (iterator.hasNext()) {
            Member member3 = iterator.next();
            Class[] classArray3 = Library.getParameterTypes(member3);
            boolean bl = true;
            boolean bl3 = true;
            for (int i = 0; i < classArray3.length; ++i) {
                bl = bl && OP.isWidening(classArray3[i], classArray2[i]);
                bl3 = bl3 && OP.isWidening(classArray2[i], classArray3[i]);
            }
            if (bl && !bl3) {
                member2 = member3;
                classArray2 = classArray3;
            }
            if (bl ^ bl3) continue;
            Object[] objectArray = new Object[]{Library.describe(string, classArray2), Library.describe(string, classArray3), Library.describe(string, classArray), clazz};
            throw new CompilationException(clazz == null ? 9 : 10, objectArray);
        }
        return member2;
    }

    protected static String describe(String string, Class[] classArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append('(');
        if (classArray != null) {
            for (int i = 0; i < classArray.length; ++i) {
                if (i != 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(classArray[i].toString());
            }
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public int getDynamicMethodClassID(Member member) {
        Integer n = this.dynIDs.get(member);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public static Class getType(Member member) {
        if (member instanceof Method) {
            return ((Method)member).getReturnType();
        }
        if (member instanceof Field) {
            return ((Field)member).getType();
        }
        if (member instanceof LocalField) {
            return ((LocalField)member).getType();
        }
        return OP.specialTypes[9];
    }

    public static Class[] getParameterTypes(Member member) {
        if (member instanceof Method) {
            return ((Method)member).getParameterTypes();
        }
        if (member instanceof LocalMethod) {
            return ((LocalMethod)member).getParameterTypes();
        }
        if (member instanceof Constructor) {
            return ((Constructor)member).getParameterTypes();
        }
        return new Class[0];
    }

    public static String getSignature(Member member) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!Library.isField(member)) {
            Class[] classArray = Library.getParameterTypes(member);
            stringBuilder.append('(');
            for (int i = 0; i < classArray.length; ++i) {
                Library.appendSignature(stringBuilder, classArray[i]);
            }
            stringBuilder.append(')');
        }
        Library.appendSignature(stringBuilder, Library.getType(member));
        return stringBuilder.toString();
    }

    public static boolean isField(Member member) {
        return member instanceof Field || member instanceof LocalField && !(member instanceof LocalMethod);
    }

    public static String getSignature(Class clazz) {
        return Library.appendSignature(new StringBuilder(), clazz).toString();
    }

    private static StringBuilder appendSignature(StringBuilder stringBuilder, Class clazz) {
        if (clazz.isPrimitive()) {
            int n = OP.typeID(clazz);
            stringBuilder.append(n > 9 ? (char)'L' : "ZBCSIJFDLV".charAt(n));
        } else if (clazz.isArray()) {
            stringBuilder.append('[');
            Library.appendSignature(stringBuilder, clazz.getComponentType());
        } else {
            stringBuilder.append('L');
            Library.appendHistoricalForm(stringBuilder, clazz.getName());
            stringBuilder.append(';');
        }
        return stringBuilder;
    }

    public static String toHistoricalForm(String string) {
        return Library.appendHistoricalForm(new StringBuilder(), string).toString();
    }

    private static StringBuilder appendHistoricalForm(StringBuilder stringBuilder, String string) {
        int n = string.length();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '.') {
                c = '/';
            }
            stringBuilder.append(c);
        }
        return stringBuilder;
    }
}

