/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadPoolExecutor;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.lsst.ccs.gconsole.plugins.trending.LsstTrendingPlugin;
import org.lsst.ccs.gconsole.plugins.trending.Trend;
import org.lsst.ccs.gconsole.plugins.trending.TrendData;
import org.lsst.ccs.gconsole.plugins.trending.TrendingPreferences;
import org.lsst.ccs.gconsole.plugins.trending.timeselection.TimeWindow;
import org.lsst.ccs.gconsole.plugins.trending.timeselection.TimeWindowSelector;
import org.lsst.ccs.gconsole.services.rest.LsstRestService;
import org.lsst.ccs.localdb.statusdb.server.ChannelMetaData;
import org.lsst.ccs.localdb.statusdb.server.DataChannel;
import org.lsst.ccs.localdb.statusdb.server.TrendingData;
import org.lsst.ccs.localdb.statusdb.server.TrendingResult;
import org.lsst.ccs.utilities.logging.Logger;

public class RestSource {
    private final LsstTrendingPlugin plugin;
    private final TrendingPreferences pref;
    private final LsstRestService restService;
    private final ThreadPoolExecutor dataFetcher;
    private final Logger logger;
    private final Map<String, DataChannel> channels = new LinkedHashMap<String, DataChannel>();
    private volatile int begin;
    private final CopyOnWriteArrayList<ChangeListener> listeners = new CopyOnWriteArrayList();
    private final TimeWindowSelector.Listener timeListener;
    private final ChangeListener restListener;

    RestSource(LsstTrendingPlugin plugin) {
        this.plugin = plugin;
        this.pref = plugin.getPreferences();
        this.restService = (LsstRestService)plugin.getConsole().getConsoleLookup().lookup(LsstRestService.class);
        this.dataFetcher = plugin.getExecutor();
        this.logger = plugin.getConsole().getLogger();
        this.timeListener = event -> this.onTimeWindowChange(event.getTimeWindow());
        this.restListener = event -> this.onRestServerChange();
    }

    void start() {
        this.plugin.getTimeWindowSelector().addListener(this.timeListener);
        this.restService.addListener(this.restListener);
        this.onTimeWindowChange(this.plugin.getSelectedTimeWindow());
    }

    void stop() {
        TimeWindowSelector ts = this.plugin.getTimeWindowSelector();
        if (ts != null) {
            ts.removeListener(this.timeListener);
        }
        this.restService.removeListener(this.restListener);
    }

    public void refresh() {
        this.dataFetcher.execute(this::refreshChannelList);
    }

    private void onRestServerChange() {
        this.refresh();
    }

    private void onTimeWindowChange(TimeWindow timeWindow) {
        int time = timeWindow == null ? 86400 : (int)Math.max(86400L, (System.currentTimeMillis() - timeWindow.getLowerEdge()) / 1000L + 3600L);
        if (time != this.begin) {
            this.begin = time;
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshChannelList() {
        List<Object> cc;
        try {
            DataChannel.DataChannelList channelList = this.restService.getChannelList(this.begin);
            cc = channelList == null || channelList.list == null || channelList.list.isEmpty() ? Collections.emptyList() : channelList.list;
        }
        catch (RuntimeException e) {
            this.logger.warn((Object)"Unable to retrieve the list of channels from the REST server.");
            cc = Collections.emptyList();
        }
        Map<String, DataChannel> map = this.channels;
        synchronized (map) {
            if (this.channels.size() != cc.size()) {
                this.channels.clear();
                cc.forEach(c -> this.channels.put(String.join((CharSequence)"/", c.getPath()), (DataChannel)c));
                this.fireEvent();
            }
        }
    }

    public void addListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    protected void fireEvent() {
        SwingUtilities.invokeLater(() -> {
            ChangeEvent event = new ChangeEvent(this);
            this.listeners.forEach(listener -> {
                block2: {
                    try {
                        listener.stateChanged(event);
                    }
                    catch (RuntimeException x) {
                        if (this.logger == null) break block2;
                        this.logger.error((Object)(listener + " threw an exception while processing RestSource event"), (Throwable)x);
                    }
                }
            });
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getChannels() {
        Map<String, DataChannel> map = this.channels;
        synchronized (map) {
            return new ArrayList<String>(this.channels.keySet());
        }
    }

    public ArrayList<TrendData> get(List<Trend> trends, long begin, long end, Boolean raw, Integer bins) {
        boolean cache;
        String flavor;
        boolean useRawData;
        int nBins = bins == null ? this.pref.getNBins() : bins.intValue();
        boolean bl = useRawData = raw == null ? this.pref.isUseRawData() : raw.booleanValue();
        if (nBins > 0) {
            flavor = useRawData ? null : "stat";
            cache = false;
        } else {
            flavor = useRawData ? "raw" : "stat";
            cache = useRawData;
        }
        ArrayList<TrendData> out = new ArrayList<TrendData>(trends.size());
        if (cache) {
            long cachedBegin = 0L;
            long cachedEnd = Long.MAX_VALUE;
            for (Trend trend : trends) {
                TrendData data = trend.getData();
                if (data == null || !data.isRaw()) {
                    cache = false;
                    break;
                }
                long[] dataRange = data.getTimeRange();
                cachedBegin = Math.max(cachedBegin, dataRange[0]);
                cachedEnd = Math.min(cachedEnd, data.getHighT());
            }
            if (cache && cachedBegin <= begin && cachedEnd > begin) {
                if (cachedEnd >= end) {
                    for (Trend trend : trends) {
                        out.add(RestSource.cut(trend.getData(), begin, end));
                    }
                } else {
                    TrendingResult[] tr = this.fetch(cachedEnd, end, flavor, nBins, trends);
                    for (int i = 0; i < trends.size(); ++i) {
                        out.add(RestSource.merge(trends.get(i).getData(), tr == null ? null : tr[i], begin, end, true));
                    }
                }
            }
        }
        if (out.isEmpty()) {
            TrendingResult[] tr = this.fetch(begin, end, flavor, nBins, trends);
            for (int i = 0; i < trends.size(); ++i) {
                out.add(RestSource.merge(null, tr == null ? null : tr[i], begin, end, nBins <= 0 && useRawData));
            }
        }
        return out;
    }

    static TrendData cut(TrendData data, long begin, long end) {
        long[] times;
        int stop;
        if (data == null || end <= begin) {
            return null;
        }
        long[] dataTimeRange = data.getTimeRange();
        if (dataTimeRange[0] > begin || dataTimeRange[1] < end) {
            return null;
        }
        Map<String, double[]> values = new HashMap<String, double[]>();
        Map<String, ArrayList<TrendData.MetaValue>> meta = new HashMap();
        long[] oldTime = data.getTimes();
        int start = Arrays.binarySearch(oldTime, begin);
        if (start < 0) {
            start = -start - 1;
        }
        stop = (stop = Arrays.binarySearch(oldTime, end)) < 0 ? -stop - 1 : ++stop;
        if (stop > start) {
            times = Arrays.copyOfRange(oldTime, start, stop);
            for (String string : data.getOnPointKeys()) {
                values.put(string, Arrays.copyOfRange(data.getValues(string), start, stop));
            }
        } else {
            times = new long[]{};
            for (String string : data.getOnPointKeys()) {
                values.put(string, new double[0]);
            }
        }
        Map<String, ArrayList<TrendData.MetaValue>> cachedMeta = data.getOffPointMetadata();
        for (Map.Entry<String, ArrayList<TrendData.MetaValue>> entry : cachedMeta.entrySet()) {
            String key = entry.getKey();
            ArrayList<TrendData.MetaValue> newList = new ArrayList<TrendData.MetaValue>();
            for (TrendData.MetaValue mp : entry.getValue()) {
                TrendData.MetaValue mv = TrendData.MetaValue.trim(mp, begin, end);
                if (mv == null) continue;
                newList.add(mv);
            }
            if (newList.isEmpty()) continue;
            meta.put(key, newList);
        }
        if (values.isEmpty()) {
            values = Collections.emptyMap();
        } else if (values.size() == 1) {
            Map.Entry entry = values.entrySet().iterator().next();
            values = Collections.singletonMap(entry.getKey(), entry.getValue());
        }
        if (meta.isEmpty()) {
            meta = Collections.emptyMap();
        } else {
            meta.values().forEach(list -> list.trimToSize());
        }
        return new TrendData(times, values, meta, new long[]{begin, end}, true);
    }

    private TrendingResult[] fetch(long begin, long end, String flavor, int nBins, List<Trend> trends) {
        String[] paths = new String[trends.size()];
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = trends.get(i).getDescriptor().getPath();
        }
        return this.restService.getData(begin, end, flavor, nBins, paths);
    }

    static TrendData merge(TrendData cachedData, TrendingResult newData, long begin, long end, boolean rawUnbinned) {
        List metaList;
        String key;
        long[] times;
        Map<String, double[]> values = new HashMap();
        Map<String, ArrayList<TrendData.MetaValue>> meta = new HashMap();
        int oldN = 0;
        int index = 0;
        long[] oldTime = null;
        if (cachedData != null) {
            oldTime = cachedData.getTimes();
            index = Arrays.binarySearch(oldTime, begin);
            if (index < 0) {
                index = -index - 1;
            }
            oldN = oldTime.length - index;
        }
        int newN = 0;
        TrendingData[] dataArray = null;
        if (newData != null && (dataArray = newData.getTrendingDataArray()) != null) {
            newN = dataArray.length;
        }
        int n = oldN + newN;
        if (oldN == 0) {
            times = new long[n];
        } else {
            times = Arrays.copyOfRange(oldTime, index, index + n);
            for (String key2 : cachedData.getOnPointKeys()) {
                values.put(key2, Arrays.copyOfRange(cachedData.getValues(key2), index, index + n));
            }
        }
        index = oldN;
        if (newN > 0) {
            for (TrendingData td : dataArray) {
                for (TrendingData.DataValue dv : td.getDatavalue()) {
                    String key3 = dv.getName();
                    double[] vv = values.get(key3);
                    if (vv == null) {
                        vv = new double[n];
                        values.put(key3, vv);
                    }
                    vv[index] = dv.getValue();
                }
                times[index++] = td.getAxisvalue().getValue();
            }
        }
        if (cachedData != null) {
            Map<String, ArrayList<TrendData.MetaValue>> cachedMeta = cachedData.getOffPointMetadata();
            for (Map.Entry<String, ArrayList<TrendData.MetaValue>> e : cachedMeta.entrySet()) {
                key = e.getKey();
                ArrayList<TrendData.MetaValue> newList = new ArrayList<TrendData.MetaValue>();
                for (TrendData.MetaValue mp : e.getValue()) {
                    TrendData.MetaValue mv = TrendData.MetaValue.trim(mp, begin, end);
                    if (mv == null) continue;
                    newList.add(mv);
                }
                if (newList.isEmpty()) continue;
                meta.put(key, newList);
            }
        }
        if (newData != null && (metaList = newData.getChannelMetadata()) != null) {
            for (ChannelMetaData md : metaList) {
                key = md.getName();
                ArrayList<TrendData.MetaValue> mvList = (ArrayList<TrendData.MetaValue>)meta.get(key);
                if (mvList == null) {
                    TrendData.MetaValue mv = TrendData.MetaValue.trim(md, begin, end);
                    if (mv == null) continue;
                    mvList = new ArrayList<TrendData.MetaValue>();
                    mvList.add(mv);
                    meta.put(key, mvList);
                    continue;
                }
                TrendData.MetaValue last = (TrendData.MetaValue)mvList.get(mvList.size() - 1);
                TrendData.MetaValue mv = TrendData.MetaValue.trim(md, last.getStop(), end);
                if (mv == null) continue;
                TrendData.MetaValue merge = TrendData.MetaValue.merge(last, mv);
                if (merge == null) {
                    mvList.add(mv);
                    continue;
                }
                mvList.set(mvList.size() - 1, merge);
            }
        }
        if (values.isEmpty()) {
            values = Collections.emptyMap();
        } else if (values.size() == 1) {
            Map.Entry e = values.entrySet().iterator().next();
            values = Collections.singletonMap(e.getKey(), e.getValue());
        }
        if (meta.isEmpty()) {
            meta = Collections.emptyMap();
        } else {
            meta.values().forEach(list -> list.trimToSize());
        }
        TrendData trd = new TrendData(times, values, meta, new long[]{begin, end}, rawUnbinned);
        return trd;
    }
}

