/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.internal;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import javax.persistence.AttributeConverter;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.boot.spi.AttributeConverterDescriptor;
import org.hibernate.boot.spi.MetadataBuildingContext;

public class AttributeConverterDescriptorNonAutoApplicableImpl
implements AttributeConverterDescriptor {
    private final AttributeConverter converter;
    private Class domainType;
    private Class jdbcType;

    public AttributeConverterDescriptorNonAutoApplicableImpl(AttributeConverter converter) {
        this.converter = converter;
        Class<?> attributeConverterClass = converter.getClass();
        ParameterizedType attributeConverterSignature = this.extractAttributeConverterParameterizedType(attributeConverterClass);
        if (attributeConverterSignature == null) {
            throw new AssertionFailure("Could not extract ParameterizedType representation of AttributeConverter definition from AttributeConverter implementation class [" + attributeConverterClass.getName() + "]");
        }
        if (attributeConverterSignature.getActualTypeArguments().length < 2) {
            throw new AnnotationException("AttributeConverter [" + attributeConverterClass.getName() + "] did not retain parameterized type information");
        }
        if (attributeConverterSignature.getActualTypeArguments().length > 2) {
            throw new AnnotationException("AttributeConverter [" + attributeConverterClass.getName() + "] specified more than 2 parameterized types");
        }
        this.domainType = AttributeConverterDescriptorNonAutoApplicableImpl.extractClass(attributeConverterSignature.getActualTypeArguments()[0]);
        if (this.domainType == null) {
            throw new AnnotationException("Could not determine domain type from given AttributeConverter [" + attributeConverterClass.getName() + "]");
        }
        this.jdbcType = AttributeConverterDescriptorNonAutoApplicableImpl.extractClass(attributeConverterSignature.getActualTypeArguments()[1]);
        if (this.jdbcType == null) {
            throw new AnnotationException("Could not determine JDBC type from given AttributeConverter [" + attributeConverterClass.getName() + "]");
        }
    }

    private ParameterizedType extractAttributeConverterParameterizedType(Type base) {
        if (base != null) {
            Class clazz = AttributeConverterDescriptorNonAutoApplicableImpl.extractClass(base);
            ArrayList<Type> types = new ArrayList<Type>();
            types.add(clazz.getGenericSuperclass());
            types.addAll(Arrays.asList(clazz.getGenericInterfaces()));
            for (Type type : types) {
                ParameterizedType parameterizedType;
                if (ParameterizedType.class.isInstance(type = AttributeConverterDescriptorNonAutoApplicableImpl.resolveType(type, base)) && AttributeConverter.class.equals((Object)(parameterizedType = (ParameterizedType)type).getRawType())) {
                    return parameterizedType;
                }
                parameterizedType = this.extractAttributeConverterParameterizedType(type);
                if (parameterizedType == null) continue;
                return parameterizedType;
            }
        }
        return null;
    }

    private static Class extractClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return AttributeConverterDescriptorNonAutoApplicableImpl.extractClass(((ParameterizedType)type).getRawType());
        }
        return null;
    }

    private static Type resolveType(Type target, Type context) {
        if (target instanceof ParameterizedType) {
            return AttributeConverterDescriptorNonAutoApplicableImpl.resolveParameterizedType((ParameterizedType)target, context);
        }
        if (target instanceof TypeVariable) {
            return AttributeConverterDescriptorNonAutoApplicableImpl.resolveTypeVariable((TypeVariable)target, (ParameterizedType)context);
        }
        return target;
    }

    private static ParameterizedType resolveParameterizedType(final ParameterizedType parameterizedType, Type context) {
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        final Type[] resolvedTypeArguments = new Type[actualTypeArguments.length];
        for (int idx = 0; idx < actualTypeArguments.length; ++idx) {
            resolvedTypeArguments[idx] = AttributeConverterDescriptorNonAutoApplicableImpl.resolveType(actualTypeArguments[idx], context);
        }
        return new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return resolvedTypeArguments;
            }

            @Override
            public Type getRawType() {
                return parameterizedType.getRawType();
            }

            @Override
            public Type getOwnerType() {
                return parameterizedType.getOwnerType();
            }
        };
    }

    private static Type resolveTypeVariable(TypeVariable typeVariable, ParameterizedType context) {
        Class clazz = AttributeConverterDescriptorNonAutoApplicableImpl.extractClass(context.getRawType());
        TypeVariable<Class<T>>[] typeParameters = clazz.getTypeParameters();
        for (int idx = 0; idx < typeParameters.length; ++idx) {
            if (!typeVariable.getName().equals(typeParameters[idx].getName())) continue;
            return AttributeConverterDescriptorNonAutoApplicableImpl.resolveType(context.getActualTypeArguments()[idx], context);
        }
        return typeVariable;
    }

    private static Class extractType(TypeVariable typeVariable) {
        Type[] boundTypes = typeVariable.getBounds();
        if (boundTypes == null || boundTypes.length != 1) {
            return null;
        }
        return (Class)boundTypes[0];
    }

    @Override
    public AttributeConverter getAttributeConverter() {
        return this.converter;
    }

    @Override
    public Class<?> getDomainType() {
        return this.domainType;
    }

    @Override
    public Class<?> getJdbcType() {
        return this.jdbcType;
    }

    @Override
    public boolean shouldAutoApplyToAttribute(XProperty xProperty, MetadataBuildingContext context) {
        return false;
    }

    @Override
    public boolean shouldAutoApplyToCollectionElement(XProperty xProperty, MetadataBuildingContext context) {
        return false;
    }

    @Override
    public boolean shouldAutoApplyToMapKey(XProperty xProperty, MetadataBuildingContext context) {
        return false;
    }
}

