package org.lsst.ccs.subsystem.ocsbridge.events;

import org.lsst.ccs.bus.annotations.SkipEncoding;

@SkipEncoding
public class CCSFilterSwapEvent extends CCSEvent {

   private final double timestampStatusChanged;
   private final String loaderId;
   private final String action;
   private final String filterName;
   private final String filterType;

   public CCSFilterSwapEvent(double timestampStatusChanged, String loaderId, String action, String filterName, String filterType) {
      this.timestampStatusChanged = timestampStatusChanged;
      this.loaderId = loaderId;
      this.action = action;
      this.filterName = filterName;
      this.filterType = filterType;
   }

   public double getTimestampStatusChanged() {
      return this.timestampStatusChanged;
   }

   public String getLoaderId() {
      return this.loaderId;
   }

   public String getAction() {
      return this.action;
   }

   public String getFilterName() {
      return this.filterName;
   }

   public String getFilterType() {
      return this.filterType;
   }

   public String toString() {
      return "CCSFilterSwapEvent{timestampStatusChanged=" + this.timestampStatusChanged + ", loaderId=" + this.loaderId + ", action=" + this.action + ", filterName=" + this.filterName + ", filterType=" + this.filterType + "}";
   }
}
