package org.lsst.ccs.subsystem.ocsbridge.states;

/**
 * We are ready to take an image if
 * <ul>
 * <li>The shutter is prepared, or does not need to be prepared</li>
 * <li>The focal-plane has been cleared, or will always do a clear on every
 * image</li>
 * </ul>
 * As a corollary, if the shutter does not need to be prepared, and we will
 * always do a clear on every image, then the TakeImageReadinessState will
 * always be READY.
 */
public enum TakeImageReadinessState {
    NOT_READY, GETTING_READY, READY
}

