package org.lsst.ccs.subsystem.ocsbridge.events;

import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.imagenaming.ImageName;

/**
 * Event published for the main camera for containing the measured shutter open time
 *
 * @author tonyj
 */
@SkipEncoding
public class CCSMeasuredShutterTime extends CCSEvent {

    private final ImageName imageName;
    private double measuredShutterOpenTime = 0.0;
    public static final String EVENT_KEY = "CCSMeasuredShutterTime";

    /**
     * Constructor
     *
     * @param imageName associated image name
     * @param measuredShutterOpenTime The measured shutter time
     */
    public CCSMeasuredShutterTime(ImageName imageName, double measuredShutterOpenTime) {

        this.imageName = imageName;
        this.measuredShutterOpenTime = measuredShutterOpenTime;
    }

    public ImageName getImageName() {
        return imageName;
    }

    public double getMeasuredShutterOpenTime() {
        return measuredShutterOpenTime;
    }

    @Override
    public String toString() {
        return "CCSMeasuredShutterOpenTime{" + "imageName=" + this.imageName.toString() + ", measuredShutterOpenTime=" + measuredShutterOpenTime + '}';
    }

}
