package org.lsst.ccs.subsystem.ocsbridge.events;

import org.lsst.ccs.bus.annotations.SkipEncoding;

/**
 * Event generated by the MCM after receiving a start command. Summarizes the
 * configuration applied.
 */
@SkipEncoding
public class CCSConfigurationAppliedEvent extends CCSEvent {

    private final String settings;
    private final double timestamp;
    private final int version;
    private final String url;
    private final String schema;

    public CCSConfigurationAppliedEvent(String settings, double timestamp, int version, String url, String schema) {

        this.settings = settings;
        this.timestamp = timestamp;
        this.version = version;
        this.url = url;
        this.schema = schema;
    }

    public String getSettings() {
        return settings;
    }

    public double getTimeStamp() {
        return timestamp;
    }

    public int getVersion() {
        return version;
    }

    public String getUrl() {
        return url;
    }

    public String getSchema() {
        return schema;
    }

    @Override
    public String toString() {
        return "CCSConfigurationAppliedEvent{" + "settings=" + settings + ", timestamp=" + timestamp + ", version=" + version + ", url=" + url + ", schema=" + schema + '}';
    }
}
