package org.lsst.ccs.subsystem.ocsbridge.config;

/**
 * An enumeration primarily used to configure ocs-bridge and MCM to operate in one of 
 * 3 modes, for MAIN_CAMERA (also including TS8), AUXTEL or COMCAM.
 * 
 * @author tonyj
 */
public enum Camera {
    MAIN_CAMERA("MTCamera"), AUXTEL("ATCamera"), COMCAM("CCCamera");

    private final String cscName;

    Camera(String cscName) {
        this.cscName = cscName;
    }

    /**
     * The corresponding CSC name, as used for communication with OCS.
     * @return 
     */
    public String getCscName() {
        return cscName;
    }
    
    public String cameraName() {
        return name().toLowerCase().replace("_", "");
    }
}
