package org.lsst.ccs.subsystem.ocsbridge.events;

import org.lsst.ccs.subsystem.ocsbridge.events.EventListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

/**
 * Maintain a list of event listeners.
 * @param <E> The event the event listeners in this list listen for
 * @author tonyj
 */
public class EventListenerList<E> {
    
    private final List<EventListener<E>> listeners = new CopyOnWriteArrayList<>();

    public void addEventListener(EventListener<E> l) {
        listeners.add(l);
    }

    public void removeEventListener(EventListener<E> l) {
        listeners.remove(l);
    }

    public void fireEvent(E event) {
        listeners.forEach((l) -> {
            l.eventFired(event);
        });
    }
    
    public void clear() {
        listeners.clear();
    }
}