package org.lsst.ccs.subsystem.ocsbridge.events;

import org.lsst.ccs.bus.annotations.SkipEncoding;

@SkipEncoding
public class CCSSetFilterEvent extends CCSEvent {

    private final String filterName;
    private final boolean start;
    private final double position;
    private final int slot;
    private final String filterType;

    public CCSSetFilterEvent(String filterName, String filterType) {
        this.filterName = filterName;
        this.filterType = filterType;
        this.slot = -1;
        this.position = -1;
        this.start = true;
    }

    public CCSSetFilterEvent(String filterName, String filterType, int slot, double position) {
        this.filterName = filterName;
        this.filterType = filterType;
        this.slot = slot;
        this.position = position;
        this.start = false;
    }

    public String getFilterName() {
        return filterName;
    }

    public boolean isStart() {
        return start;
    }

    public double getPosition() {
        return position;
    }

    public int getSlot() {
        return slot;
    }

    public String getFilterType() {
        return filterType;
    }

    @Override
    public String toString() {
        return "CCSSetFilterEvent{" + "filterName=" + filterName + ", start=" + start + ", position=" + position + ", slot=" + slot + ", filterType=" + filterType + '}';
    }

}
