package org.lsst.ccs.subsystem.ocsbridge.events;

import java.util.Map;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

    @SkipEncoding
    public class CCSImageNameEvent extends CCSEvent {

        private final int imagesInSequence;
        private final ImageName imageName;
        private final int sequenceNumber;
        private final CCSTimeStamp integrationStartTime;
        private final double exposureTime;
        private final Map<String, String> keyValueData;
        private final String mode;
        private final double timeout;

        public CCSImageNameEvent(Map<String, String> keyValueData, int imagesInSequence, ImageName imageName, int sequenceNumber, CCSTimeStamp integrationStartTime, double exposureTime, String mode, double timeout) {
            this.keyValueData = keyValueData;
            this.imagesInSequence = imagesInSequence;
            this.imageName = imageName;
            this.sequenceNumber = sequenceNumber;
            this.integrationStartTime = integrationStartTime;
            this.exposureTime = exposureTime;
            this.mode = mode;
            this.timeout = timeout;
        }

        public String getImageType() {
            return keyValueData.get("imageType");
        }

        public String getGroupId() {
            return keyValueData.get("groupId");
        }

        public int getImagesInSequence() {
            return imagesInSequence;
        }

        public ImageName getImageName() {
            return imageName;
        }

        public int getSequenceNumber() {
            return sequenceNumber;
        }

        public CCSTimeStamp getIntegrationStartTime() {
            return integrationStartTime;
        }

        public double getExposureTime() {
            return exposureTime;
        }

        public Map<String, String> getKeyValueData() {
            return keyValueData;
        }

        public String getMode() {
            return mode;
        }

        public double getTimeout() {
            return timeout;
        }

        @Override
        public String toString() {
            return "CCSImageNameEvent{" + "imagesInSequence=" + imagesInSequence + ", imageName=" + imageName + ", sequenceNumber=" + sequenceNumber + ", integrationStartTime=" + integrationStartTime + ", exposureTime=" + exposureTime + ", keyValueData=" + keyValueData + ", mode=" + mode + ", timeout=" + timeout + '}';
        }

    }

