package org.lsst.ccs.subsystem.ocsbridge.events;

import org.lsst.ccs.bus.annotations.SkipEncoding;

/**
 * Event generated by the MCM on startup, and whenever the available
 * configurations change. (Also whenever the ocs-bridge starts?)
 */
@SkipEncoding
public class CCSConfigurationsAvailableEvent extends CCSEvent {

    @Override
    public String toString() {
        return "CCSConfigurationsAvailableEvent{" + "configurationsAvailable=" + configurationsAvailable + ", version=" + version + ", url=" + url + ", schema=" + schema + '}';
    }
    private final String configurationsAvailable;
    private final String version;
    private final String url;
    private final String schema;

    public CCSConfigurationsAvailableEvent(String configurationsAvailable, String version, String url, String schema) {
        this.configurationsAvailable = configurationsAvailable;
        this.version = version;
        this.url = url;
        this.schema = schema;
    }

    public String getConfigurationsAvailable() {
        return configurationsAvailable;
    }

    public String getVersion() {
        return version;
    }

    public String getUrl() {
        return url;
    }

    public String getSchema() {
        return schema;
    }
}
