/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs;

import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.ConfigurationListener;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.config.CategoryDescription;
import org.lsst.ccs.config.ConfigurationDAO;
import org.lsst.ccs.config.ConfigurationDescription;
import org.lsst.ccs.config.ConfigurationParameterHandler;
import org.lsst.ccs.config.ConfigurationServiceException;
import org.lsst.ccs.config.ConfigurationView;
import org.lsst.ccs.config.LocalConfigurationDAO;
import org.lsst.ccs.config.SingleCategoryTag;
import org.lsst.ccs.config.SingleCategoryTagData;
import org.lsst.ccs.config.remote.LocalToRemoteMigrationDAO;
import org.lsst.ccs.config.remote.RestFileServerRemoteDAO;
import org.lsst.ccs.utilities.structs.ParameterPath;

public class ConfigurationDAOWrapper
implements ConfigurationListener,
Closeable {
    private static final Logger LOG = Logger.getLogger(ConfigurationDAOWrapper.class.getName());
    private final ConfigurationService configurationService;
    private final ConfigurationDAO configurationDao;
    private final Map<SingleCategoryTag, SingleCategoryTagData> newLoadedViewsBySourceAndByCategory = new ConcurrentHashMap<SingleCategoryTag, SingleCategoryTagData>();
    private final Map<SingleCategoryTag, SingleCategoryTagData> pendingLoadedViewsBySource = new ConcurrentHashMap<SingleCategoryTag, SingleCategoryTagData>();
    private volatile ConfigurationDescription pendingConfigDescription = null;

    ConfigurationDAOWrapper(String subsystemName, ConfigurationService configurationService) {
        String dao;
        this.configurationService = configurationService;
        if (configurationService != null) {
            configurationService.addConfigurationListener(this);
        }
        this.configurationDao = (dao = System.getProperty("org.lsst.ccs.config.remote", "false")).equalsIgnoreCase("true") ? new RestFileServerRemoteDAO(subsystemName) : (dao.equalsIgnoreCase("migrate") ? new LocalToRemoteMigrationDAO(subsystemName) : new LocalConfigurationDAO());
    }

    ConfigurationDAOWrapper(String subsystemName) {
        this(subsystemName, null);
    }

    Properties getConfigurationProperties(String tag, String category, String source) throws ConfigurationServiceException {
        SingleCategoryTag singleCategoryTag = new SingleCategoryTag(source, tag, category);
        Properties res = new Properties();
        try {
            SingleCategoryTagData data = this.configurationDao.loadCategoryTag(singleCategoryTag);
            res.putAll((Map<?, ?>)data.getConfigurationData());
        }
        catch (ConfigurationServiceException e) {
            LOG.log(Level.FINE, "Unable to load build configuration " + singleCategoryTag, e);
        }
        return res;
    }

    public ConfigurationView initialLoadConfiguration(ConfigurationDescription configDescription) {
        ConfigurationView viewResult = this.loadConfiguration(configDescription);
        this.updatePendingInformation();
        return viewResult;
    }

    public ConfigurationView loadConfiguration(ConfigurationDescription configDescription) throws ConfigurationServiceException {
        ConfigurationView res = new ConfigurationView(configDescription);
        try {
            for (String category : configDescription.getCategoriesSet()) {
                CategoryDescription categoryTag = configDescription.getCategoryTag(category);
                for (SingleCategoryTag singleCategoryTag : categoryTag.getSingleCategoryTags()) {
                    if (singleCategoryTag.getSource() == null || singleCategoryTag.getSource().isEmpty()) {
                        throw new IllegalArgumentException("Cannot load data with an empty source: " + singleCategoryTag);
                    }
                    SingleCategoryTagData tagData = this.configurationDao.loadCategoryTag(singleCategoryTag);
                    configDescription.putSingleTagForCategory(category, singleCategoryTag, tagData.getSingleCategoryTag().getVersion());
                    ConfigurationView sourceView = new ConfigurationView(tagData);
                    this.pendingLoadedViewsBySource.put(singleCategoryTag, tagData);
                    res.putAll(sourceView);
                }
            }
            this.pendingConfigDescription = configDescription;
        }
        catch (Exception e) {
            this.pendingLoadedViewsBySource.clear();
            this.pendingConfigDescription = null;
            throw e;
        }
        res.setConfigurationDescription(configDescription);
        return res;
    }

    public ConfigurationDescription saveChangesForCategoriesAs(ConfigurationDescription configDesc, ConfigurationInfo configInfo, boolean fullConfiguration) throws ConfigurationServiceException {
        ConfigurationView overallView = new ConfigurationView();
        if (!fullConfiguration) {
            for (String category : configDesc.getCategoriesSet()) {
                CategoryDescription catTag = configDesc.getCategoryTag(category);
                List sourcedTags = catTag.getSingleCategoryTags();
                for (SingleCategoryTag singleCategoryTag : sourcedTags) {
                    ConfigurationView lastLoadedViewForKey;
                    boolean isLastTag = sourcedTags.indexOf(singleCategoryTag) == sourcedTags.size() - 1;
                    if (isLastTag || (lastLoadedViewForKey = new ConfigurationView(this.newLoadedViewsBySourceAndByCategory.get(singleCategoryTag))) == null) continue;
                    for (Map.Entry e : lastLoadedViewForKey.getAsParameterPathMap().entrySet()) {
                        ParameterPath path = (ParameterPath)e.getKey();
                        if (overallView.containsPath(path) && overallView.getPathValue(path).equals(e.getValue())) {
                            lastLoadedViewForKey.removeValueForPath(path);
                            continue;
                        }
                        overallView.putParameterValue(path.toString(), (String)e.getValue());
                    }
                }
            }
        }
        ConfigurationView currentView = this.configurationService.getCurrentConfigurationView();
        for (Map.Entry lastLoadedValues : currentView.getAsParameterPathMap().entrySet()) {
            ParameterPath pp = (ParameterPath)lastLoadedValues.getKey();
            String currentViewValue = (String)lastLoadedValues.getValue();
            String parameterCategory = configInfo.getCurrentParameterInfo(pp.toString()).getCategoryName();
            CategoryDescription catTag = configDesc.getCategoryTag(parameterCategory);
            if (catTag == null) continue;
            List sourcedTags = catTag.getSingleCategoryTags();
            SingleCategoryTag singleCategoryTag = (SingleCategoryTag)sourcedTags.get(sourcedTags.size() - 1);
            SingleCategoryTagData lastLoadedViewForKey = this.newLoadedViewsBySourceAndByCategory.getOrDefault(singleCategoryTag, new SingleCategoryTagData(singleCategoryTag));
            if (fullConfiguration || !overallView.containsPath(pp) || overallView.containsPath(pp) && !overallView.getPathValue(pp).equals(currentViewValue)) {
                lastLoadedViewForKey.getConfigurationData().put(pp.toString(), currentViewValue);
            } else if (overallView.containsPath(pp) && overallView.getPathValue(pp).equals(currentViewValue)) {
                lastLoadedViewForKey.getConfigurationData().remove(pp.toString());
            }
            this.newLoadedViewsBySourceAndByCategory.put(singleCategoryTag, lastLoadedViewForKey);
        }
        for (String category : configDesc.getCategoriesSet()) {
            SingleCategoryTag singleCategoryTag;
            CategoryDescription categoryTag = configDesc.getCategoryTag(category);
            List sourcedTags = categoryTag.getSingleCategoryTags();
            singleCategoryTag = (SingleCategoryTag)sourcedTags.get(sourcedTags.size() - 1);
            SingleCategoryTagData data = this.newLoadedViewsBySourceAndByCategory.getOrDefault(singleCategoryTag, new SingleCategoryTagData(singleCategoryTag));
            SingleCategoryTagData saveData = new SingleCategoryTagData(data);
            for (ConfigurationParameterHandler cph : this.configurationService.getCategoryParameters(category)) {
                if (!cph.isReadOnly()) continue;
                saveData.getConfigurationData().remove(cph.getParameterPath().toString());
            }
            if (singleCategoryTag.getSource() == null || singleCategoryTag.getSource().isEmpty()) {
                throw new IllegalArgumentException("Cannot load data with an empty source: " + singleCategoryTag);
            }
            SingleCategoryTag res = this.configurationDao.saveCategoryTagData(saveData);
            configDesc.putSingleTagForCategory(category, res, res.getVersion());
        }
        return configDesc;
    }

    public boolean hasCategoryTagData(SingleCategoryTag singleCategoryTag) {
        return this.configurationDao.hasCategoryTagData(singleCategoryTag);
    }

    private void resentPendingInformation() {
        this.pendingLoadedViewsBySource.clear();
        this.pendingConfigDescription = null;
    }

    private void updatePendingInformation() {
        for (String category : this.pendingConfigDescription.getCategoriesSet()) {
            for (SingleCategoryTag singleCategoryTag : this.newLoadedViewsBySourceAndByCategory.keySet()) {
                if (!singleCategoryTag.getCategory().equals(category)) continue;
                this.newLoadedViewsBySourceAndByCategory.remove(singleCategoryTag);
            }
        }
        this.newLoadedViewsBySourceAndByCategory.putAll(this.pendingLoadedViewsBySource);
        this.resentPendingInformation();
    }

    @Override
    public void failedConfigurationOperation(ConfigurationInfo configurationInfo, ConfigurationListener.ConfigurationOperation configurationOperation, Exception ex) {
        if (configurationOperation == ConfigurationListener.ConfigurationOperation.LOAD && ex != null) {
            this.resentPendingInformation();
        }
    }

    @Override
    public void configurationChanged(ConfigurationInfo ci, ConfigurationInfo oldci, ConfigurationListener.ConfigurationOperation configurationOperation) {
        if (configurationOperation == ConfigurationListener.ConfigurationOperation.LOAD) {
            if (this.pendingLoadedViewsBySource.isEmpty()) {
                this.resentPendingInformation();
                return;
            }
            this.updatePendingInformation();
        }
    }

    @Override
    public void close() {
        if (this.configurationDao != null) {
            this.configurationDao.close();
        }
    }
}

