/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.config.BulkSettingException;
import org.lsst.ccs.config.BulkValidationException;
import org.lsst.ccs.config.CategoryHandler;
import org.lsst.ccs.config.CategoryTag;
import org.lsst.ccs.config.ConfigurationDescription;
import org.lsst.ccs.config.ConfigurationHandler;
import org.lsst.ccs.config.ConfigurationHandlerBuilder;
import org.lsst.ccs.config.ConfigurationParameterHandler;
import org.lsst.ccs.config.ConfigurationView;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.structs.ParameterPath;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class ConfigurationHandlerSet {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.config");
    private final List<DataProviderInfo> list = new ArrayList<DataProviderInfo>();
    private final Map<String, ConfigurationHandler> componentParameterHandlers = new LinkedHashMap<String, ConfigurationHandler>();
    private final Map<String, CategoryHandler> parametersByCategories = new HashMap<String, CategoryHandler>();
    private ConfigurationView initialView;
    private final Set<String> categories = new HashSet<String>();
    private final Map<String, String> componentToPath = new HashMap<String, String>();
    private final boolean useFullPaths;
    private final boolean checkConfigView;
    private final boolean failOnViewProblems;
    private boolean failForBuildParameters = true;
    private static Comparator<DataProviderInfo> comparator = new Comparator<DataProviderInfo>(){

        @Override
        public int compare(DataProviderInfo o1, DataProviderInfo o2) {
            return o1.getFullPath().compareTo(o2.getFullPath());
        }
    };

    public ConfigurationHandlerSet(boolean usefullPaths, boolean checkConfigView, boolean failOnViewProblems) {
        this.useFullPaths = usefullPaths;
        this.checkConfigView = checkConfigView;
        this.failOnViewProblems = failOnViewProblems;
    }

    public ConfigurationHandlerSet() {
        this(true, true, false);
    }

    public ConfigurationHandler addConfigurationHandlerForObject(String componentName, String componentPath, Object component) {
        return this.addConfigurationHandlerForObject(componentName, componentPath, component, false);
    }

    public ConfigurationHandler addConfigurationHandlerForObject(String componentName, String componentPath, Object component, boolean isNewImplementation) {
        ConfigurationHandler handler = ConfigurationHandlerBuilder.buildParameterSetterFromObject(componentName, component);
        this.componentToPath.put(componentName, componentPath);
        if (handler == null) {
            return null;
        }
        this.componentParameterHandlers.put(componentName, handler);
        for (ConfigurationParameterHandler cph : handler.getConfigurationParameterHandlers()) {
            String category;
            CategoryHandler set;
            if (isNewImplementation && cph.isBuild()) {
                if (cph.getCategory() != null && !cph.getCategory().isEmpty()) {
                    log.log(Level.WARNING, "Changing assigned category {0} for isBuild parameter {1} to \"build\"", new Object[]{cph.getCategory(), cph.getParameterPath()});
                }
                cph.setCategory("build");
            }
            if ((set = this.parametersByCategories.get(category = cph.getCategory())) == null) {
                this.categories.add(category);
                set = new CategoryHandler(category);
                this.parametersByCategories.put(category, set);
            }
            set.addParameterHandler(cph);
        }
        return handler;
    }

    public ConfigurationInfo initialize(String descriptionName) {
        return this.initialize(descriptionName, new ConfigurationView(ConfigurationDescription.safeConfiguration(this.categories)));
    }

    public ConfigurationInfo initialize(String descriptionName, ConfigurationView safeView) {
        return this.initialize(descriptionName, safeView, false, false);
    }

    public ConfigurationInfo initialize(String descriptionName, ConfigurationView safeView, boolean isBuild, boolean isSafe) {
        this.failForBuildParameters = false;
        this.initialView = new ConfigurationView(ConfigurationDescription.safeConfiguration(this.categories));
        this.initialView.putAll(this.getLiveConfigurationView());
        if (isSafe && !isBuild) {
            Iterator<Map.Entry<ParameterPath, String>> missingMaxLength = new ArrayList();
            ArrayList<ParameterPath> missingVolatile = new ArrayList<ParameterPath>();
            for (ConfigurationHandler handler : this.componentParameterHandlers.values()) {
                for (ConfigurationParameterHandler configHandler : handler.getConfigurationParameterHandlers()) {
                    boolean mustBeVolatile;
                    boolean bl = mustBeVolatile = !configHandler.isBuild() && !configHandler.isFinal();
                    if (mustBeVolatile && !ConfigurationHandlerSet.isVolatile(configHandler)) {
                        missingVolatile.add(configHandler.getParameterPath());
                    }
                    if (!configHandler.hasLength() || configHandler.getMaxLength() != 0) continue;
                    missingMaxLength.add((Map.Entry<ParameterPath, String>)configHandler.getParameterPath());
                }
            }
            if (missingMaxLength.size() > 0) {
                log.log(Level.WARNING, "Collections or Arrays annotated as Configuration Parameters must provide the \"maxLength\" argument.\nPlease update your code to specify the maximum allowed length for the following parameters: \n{0}", missingMaxLength);
            }
            if (missingVolatile.size() > 0) {
                log.log(Level.WARNING, "Fields annotated as Configuration Parameters must be declared as \"volatile\".\nPlease update your code for the following parameters:\n{0}", missingVolatile);
            }
        }
        if (!isBuild) {
            for (ParameterPath p : safeView.getAsParameterPathMap().keySet()) {
                ConfigurationHandler configurationHandler = this.componentParameterHandlers.get(p.getComponentName());
                if (configurationHandler == null) {
                    throw new RuntimeException("Unknown component " + p.getComponentName() + " for parameter " + p);
                }
                if (!configurationHandler.isBuildParameter(p.getParameterName())) continue;
                safeView.removeValueForPath(p);
            }
        }
        try {
            safeView = this.loadCategories(safeView, isBuild, isSafe);
            this.initialView.putAll(safeView);
            if (!isBuild) {
                for (Map.Entry<ParameterPath, String> pp : this.initialView.getAsParameterPathMap().entrySet()) {
                    if (!pp.getValue().equals("_null_")) continue;
                    log.warn((Object)("parameter " + pp.getKey() + " has not been assigned a safe "));
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("could not load initial configuration.", ex);
        }
        ConfigurationInfo.Builder ciBuilder = new ConfigurationInfo.Builder().setDescription(descriptionName).updateConfigurationDescription(safeView.getConfigurationDescription().getDescriptionName());
        for (CategoryHandler categoryHandler : this.parametersByCategories.values()) {
            String category = categoryHandler.getCategory();
            CategoryTag categoryTag = safeView.getConfigurationDescription().getCategoryTag(category);
            String tag0 = categoryTag != null ? categoryTag.getTags().iterator().next() : null;
            Integer version0 = categoryTag != null ? categoryTag.getTagVersion(tag0) : null;
            ciBuilder.updateCategoryInformation(category, tag0, version0, false);
            for (ConfigurationParameterHandler cph : categoryHandler.getParameters()) {
                ParameterPath pp = new ParameterPath(cph.getComponentName(), cph.getParameterName());
                ciBuilder.addParameter(pp, cph.getType(), cph.getCategory(), cph.getDescription(), cph.isFinal(), cph.isReadOnly(), cph.isBuild());
                DataProviderInfo dataProviderInfo = new DataProviderInfo(this.componentToPath.get(pp.getComponentName()), DataProviderInfo.Type.CONFIGURATION, pp.getParameterName());
                if (!this.useFullPaths) {
                    dataProviderInfo.addAttribute(DataProviderInfo.Attribute.PUBLISHED_PATH, pp.getComponentName() + "/" + pp.getParameterName());
                }
                if (!cph.getUnits().isEmpty()) {
                    dataProviderInfo.addAttribute(DataProviderInfo.Attribute.UNITS, cph.getUnits());
                }
                dataProviderInfo.addAttribute(DataProviderInfo.Attribute.TYPE, cph.getType().getTypeName());
                if (!cph.getDescription().isEmpty()) {
                    dataProviderInfo.addAttribute(DataProviderInfo.Attribute.DESCRIPTION, cph.getDescription());
                }
                dataProviderInfo.addAttribute(DataProviderInfo.Attribute.CONFIG_TYPE, cph.getParameterType().name());
                dataProviderInfo.addAttribute(DataProviderInfo.Attribute.CONFIG_CATEGORY, cph.getCategory());
                String range = cph.getRange();
                if (range != null && !range.isEmpty()) {
                    dataProviderInfo.addAttribute(DataProviderInfo.Attribute.CONFIG_RANGE, range);
                }
                if (cph.hasLength() && cph.getMaxLength() != 0) {
                    dataProviderInfo.addAttribute(DataProviderInfo.Attribute.CONFIG_MAX_LENGTH, String.valueOf(cph.getMaxLength()));
                }
                this.list.add(dataProviderInfo);
                ciBuilder.updateParameter(pp, this.initialView.getPathValue(pp), this.initialView.getPathValue(pp), false);
            }
        }
        Collections.sort(this.list, comparator);
        this.failForBuildParameters = true;
        return ciBuilder.setConfigurationState(ConfigurationState.UNCONFIGURED).setCCSTimeStamp(CCSTimeStamp.currentTime()).build();
    }

    private static boolean isVolatile(ConfigurationParameterHandler parameterHandler) {
        return Modifier.isVolatile(parameterHandler.getField().getModifiers()) || Modifier.isFinal(parameterHandler.getField().getModifiers());
    }

    public List<DataProviderInfo> getDataPoviderInfoList() {
        return this.list;
    }

    public ConfigurationHandler getConfigurationHandlerForGroovy(String componentName) {
        try {
            return this.getParameterSet(componentName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public ConfigurationHandler getParameterSet(String componentName) {
        ConfigurationHandler res = this.componentParameterHandlers.get(componentName);
        if (res == null) {
            throw new IllegalArgumentException("no such component : " + componentName);
        }
        return res;
    }

    public CategoryHandler getCategoryHandler(String category) {
        CategoryHandler res = this.parametersByCategories.get(category);
        if (res == null) {
            log.info((Object)("no such category : " + category));
            throw new RuntimeException("Category " + category + " does not exist");
        }
        return res;
    }

    public boolean isBuildParameter(String componentName, String parameterName) {
        ConfigurationHandler ch = this.componentParameterHandlers.get(componentName);
        return ch == null ? false : ch.isBuildParameter(parameterName);
    }

    public boolean isOptionalParameter(String componentName, String parameterName) {
        ConfigurationHandler ch = this.componentParameterHandlers.get(componentName);
        return ch == null ? false : ch.isOptionalParameter(parameterName);
    }

    public boolean isFinalParameter(String componentName, String parameterName) {
        ConfigurationHandler ch = this.componentParameterHandlers.get(componentName);
        return ch == null ? false : ch.isFinalParameter(parameterName);
    }

    public boolean isParameterConfigurable(String componentName, String parameterName) {
        ConfigurationHandler ch = this.componentParameterHandlers.get(componentName);
        return ch == null ? false : ch.isParameterConfigurable(parameterName);
    }

    public boolean isParameterReadOnly(String componentName, String parameterName) {
        ConfigurationHandler ch = this.componentParameterHandlers.get(componentName);
        return ch == null ? false : ch.isParameterReadOnly(parameterName);
    }

    public Set<String> getCategorySet() {
        return Collections.unmodifiableSet(this.parametersByCategories.keySet());
    }

    public ConfigurationView loadCategories(ConfigurationView cv) {
        return this.loadCategories(cv, false, false);
    }

    private ConfigurationView loadCategories(ConfigurationView cv, boolean isBuild, boolean isSafe) {
        ConfigurationDescription configDesc = cv.getConfigurationDescription();
        StringBuilder unexpectedParms = new StringBuilder("");
        for (Map.Entry<ParameterPath, String> entry : cv.getAsParameterPathMap().entrySet()) {
            ParameterPath parm = entry.getKey();
            String componentName = parm.getComponentName();
            String parameterName = parm.getParameterName();
            if (isBuild) {
                if (!this.isBuildParameter(componentName, parameterName)) {
                    continue;
                }
            } else if (this.isBuildParameter(componentName, parameterName)) {
                log.log(Level.WARNING, "Attempting to set build ConfigurationParameter {0} past the HasLifecycle::build phase.", new Object[]{parm});
                continue;
            }
            if (this.isParameterReadOnly(componentName, parameterName)) continue;
            if (this.isParameterConfigurable(componentName, parameterName) && !this.isParameterReadOnly(componentName, parameterName)) {
                Object newValue = this.submitChange(componentName, parameterName, entry.getValue());
                if (!(newValue instanceof String) || ((String)newValue).equals(entry.getValue())) continue;
                cv.putParameterValue(componentName, parameterName, (String)newValue);
                continue;
            }
            if (!cv.containsPath(parm)) continue;
            unexpectedParms.append(parm).append(" ");
        }
        if (configDesc != null) {
            HashMap<String, String> missingParmsDigest = new HashMap<String, String>();
            for (String category : configDesc.getCategoriesSet()) {
                StringBuilder missingParms = new StringBuilder("");
                CategoryHandler ch = this.getCategoryHandler(category);
                for (ConfigurationParameterHandler cph : ch.getParameters()) {
                    String componentName = cph.getComponentName();
                    String parameterName = cph.getParameterName();
                    ParameterPath parm = new ParameterPath(componentName, parameterName);
                    if (!isBuild ? this.isBuildParameter(componentName, parameterName) : !this.isBuildParameter(componentName, parameterName)) continue;
                    if (cph.isReadOnly() || cph.isFinal() || cph.isOptional() || cv.containsPath(parm)) continue;
                    missingParms.append(new ParameterPath(componentName, parameterName).toString()).append(" ");
                }
                if (missingParms.toString().isEmpty()) continue;
                missingParmsDigest.put("\"" + configDesc.getCategoryTag(category) + "\"", missingParms.toString());
            }
            if (!(!this.checkConfigView || unexpectedParms.toString().isEmpty() && missingParmsDigest.isEmpty())) {
                StringBuilder stringBuilder = new StringBuilder("the following problems occured when reading the configuration : ").append(configDesc.toString()).append("\n");
                if (!unexpectedParms.toString().isEmpty()) {
                    stringBuilder.append("\t unexpected parameters : ").append(unexpectedParms.toString()).append("\n");
                }
                if (!missingParmsDigest.isEmpty()) {
                    for (Map.Entry e : missingParmsDigest.entrySet()) {
                        stringBuilder.append("\t missing values for configuration ").append((String)e.getKey()).append(" : ").append((String)e.getValue()).append("\n");
                    }
                }
                log.warn((Object)(stringBuilder.toString() + "Saving the problematic configurations once they are loaded will fix them."));
                if (BootstrapResourceUtils.getBootstrapSystemProperties().getOrDefault((Object)"org.lsst.ccs.config.require_complete_configurations", "false").equals("true") || this.failOnViewProblems) {
                    throw new RuntimeException(stringBuilder.append("Load aborted.").toString());
                }
            }
        }
        return this.commitBulkChange(configDesc, isSafe, isBuild);
    }

    public void dropAllSubmittedChanges() {
        this.componentParameterHandlers.values().stream().forEach(ConfigurationHandler::dropSubmittedChanges);
    }

    public void dropSubmittedChangesForComponent(String name) {
        this.getParameterSet(name).dropSubmittedChanges();
    }

    public Map<String, String> getSubmittedChangesForComponent(String name) {
        return this.getParameterSet(name).getSubmittedChanges().entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (String)entry.getValue()));
    }

    public Map<String, Map<String, String>> getAllSubmittedChanges() {
        TreeMap<String, Map<String, String>> res = new TreeMap<String, Map<String, String>>();
        for (Map.Entry<String, ConfigurationHandler> entry : this.componentParameterHandlers.entrySet()) {
            Map<String, String> submittedChanges = this.getSubmittedChangesForComponent(entry.getKey());
            if (submittedChanges.isEmpty()) continue;
            res.put(entry.getKey(), new TreeMap<String, String>(submittedChanges));
        }
        return res;
    }

    public Object submitChange(String componentName, String parameterName, Object value, boolean readOnlyOk) {
        if (!this.isParameterConfigurable(componentName, parameterName)) {
            throw new IllegalArgumentException(componentName + "/" + parameterName + " is not a valid configuration parameter.");
        }
        if (this.isParameterReadOnly(componentName, parameterName) && !readOnlyOk) {
            throw new IllegalArgumentException(componentName + "/" + parameterName + " is a read-only configuration parameter.");
        }
        if (this.isBuildParameter(componentName, parameterName) && this.failForBuildParameters) {
            throw new IllegalArgumentException(componentName + "/" + parameterName + " is a build configuration parameter.");
        }
        return this.getParameterSet(componentName).submitChange(parameterName, value);
    }

    public Object submitChange(String componentName, String parameterName, Object value) {
        return this.submitChange(componentName, parameterName, value, false);
    }

    public boolean hasSubmittedChanges() {
        for (Map.Entry<String, ConfigurationHandler> e1 : this.componentParameterHandlers.entrySet()) {
            if (!e1.getValue().hasSubmittedChanges()) continue;
            return true;
        }
        return false;
    }

    public ConfigurationView commitBulkChange(ConfigurationDescription categoriesToCommit) {
        return this.commitBulkChange(categoriesToCommit, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigurationView commitBulkChange(ConfigurationDescription categoriesToCommit, boolean isSafe, boolean isBuild) {
        ConfigurationView diff;
        ConfigurationView submittedChanges;
        ConfigurationView before;
        block15: {
            before = this.getLiveConfigurationView();
            submittedChanges = new ConfigurationView();
            for (Map.Entry<String, ConfigurationHandler> entry : this.componentParameterHandlers.entrySet()) {
                entry.getValue().trimSubmittedChanges();
                for (Map.Entry<String, String> e : entry.getValue().getSubmittedChanges().entrySet()) {
                    submittedChanges.putParameterValue(entry.getKey(), e.getKey(), e.getValue());
                }
            }
            log.fine((Object)("processing the following submitted changes :" + submittedChanges.getAsParameterPathMap()));
            BulkValidationException excThrown = null;
            if (!isBuild) {
                try {
                    for (ConfigurationHandler ch : this.componentParameterHandlers.values()) {
                        ch.invokeValidateBulkChange(isSafe);
                    }
                }
                catch (Exception exception) {
                    excThrown = new BulkValidationException(exception);
                    return excThrown;
                }
                finally {
                    ConfigurationView configurationView = this.getLiveConfigurationView();
                    diff = before.diff(configurationView);
                    if (!diff.isEmpty()) {
                        this.dropAllSubmittedChanges();
                        Set<ParameterPath> suspect = diff.getAsParameterPathMap().keySet();
                        throw new BulkSettingException("some parameters have been modified during the validation step : " + suspect, excThrown);
                    }
                    if (excThrown == null) break block15;
                    throw excThrown;
                }
            }
        }
        for (Map.Entry<String, ConfigurationHandler> entry : this.componentParameterHandlers.entrySet()) {
            ConfigurationHandler ch = entry.getValue();
            try {
                ch.invokeSetParameters(before.getValuesForComponent(entry.getKey()), isBuild);
            }
            catch (Exception ex) {
                this.dropAllSubmittedChanges();
                throw new BulkSettingException(ex.getMessage(), ex);
            }
        }
        ConfigurationView configurationView = this.getLiveConfigurationView();
        diff = before.diff(configurationView);
        for (Map.Entry<ParameterPath, String> pathVal : diff.getAsParameterPathMap().entrySet()) {
            ParameterPath path = pathVal.getKey();
            if (this.isParameterReadOnly(path.getComponentName(), path.getParameterName())) continue;
            if (!submittedChanges.containsPath(path)) {
                this.dropAllSubmittedChanges();
                throw new BulkSettingException("the parameter " + path + " was not supposed to change from " + before.getPathValue(path) + " to " + pathVal.getValue());
            }
            if (submittedChanges.getPathValue(path).equals(pathVal.getValue())) continue;
            this.dropAllSubmittedChanges();
            throw new BulkSettingException("wrong value for parameter : " + path.toString() + ", expected : " + submittedChanges.getPathValue(path) + ", actual : " + pathVal.getValue());
        }
        this.dropAllSubmittedChanges();
        configurationView.setConfigurationDescription(categoriesToCommit);
        return configurationView;
    }

    public ConfigurationView setSingleParameter(String componentName, String parameterName, Object value) {
        return this.setSingleParameter(componentName, parameterName, value, false);
    }

    public ConfigurationView setSingleParameter(String componentName, String parameterName, Object value, boolean isReadOnlyOk) {
        if (!this.isParameterConfigurable(componentName, parameterName)) {
            log.info((Object)("no such parameter " + new ParameterPath(componentName, parameterName)));
            return new ConfigurationView();
        }
        if (this.hasSubmittedChanges()) {
            throw new RuntimeException("Cannot change single parameter with outstanding submitted changes.");
        }
        ConfigurationView view = null;
        try {
            this.submitChange(componentName, parameterName, value, isReadOnlyOk);
            view = this.commitBulkChange(null);
        }
        catch (Exception e) {
            this.dropAllSubmittedChanges();
            throw e;
        }
        return view;
    }

    public Map<String, String> getCurrentValuesForComponent(String componentName, Set<String> categorySet) {
        return this.getParameterSet(componentName).getCurrentValues(categorySet).entrySet().stream().collect(Collectors.toMap(entry -> ((ParameterPath)entry.getKey()).getParameterName(), entry -> (String)entry.getValue()));
    }

    public ConfigurationView getLiveConfigurationView() {
        ConfigurationView res = new ConfigurationView();
        for (String compName : this.componentParameterHandlers.keySet()) {
            res.putValuesForComponent(compName, this.getCurrentValuesForComponent(compName, this.categories));
        }
        return res;
    }
}

