/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.PrintStream;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.UndefinedData;
import nom.tam.fits.header.Standard;
import nom.tam.util.ArrayFuncs;

public class UndefinedHDU
extends BasicHDU<UndefinedData> {
    public static UndefinedData encapsulate(Object o) throws FitsException {
        return new UndefinedData(o);
    }

    public static boolean isData(Object o) {
        return ArrayFuncs.computeLSize(o) > 0L;
    }

    public static boolean isHeader(Header hdr) {
        return hdr.getStringValue(Standard.XTENSION) != null && hdr.getIntValue(Standard.NAXIS, -1) >= 0;
    }

    public static Data manufactureData(Header hdr) throws FitsException {
        return new UndefinedData(hdr);
    }

    public static Header manufactureHeader(Data d) throws FitsException {
        Header h = new Header();
        d.fillHeader(h);
        return h;
    }

    public UndefinedHDU(Header h, UndefinedData d) throws FitsException {
        super(h, d);
    }

    @Override
    public void info(PrintStream stream) {
        stream.println("  Unhandled/Undefined/Unknown Type");
        stream.println("  XTENSION=" + this.myHeader.getStringValue(Standard.XTENSION).trim());
        stream.println("  Apparent size:" + ((UndefinedData)this.myData).getTrueSize());
    }
}

