/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.startup;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.description.groovy.CCSBuilder;
import org.lsst.ccs.startup.HasCommandLineOptions;

public class SubsystemBoot {
    static String[] descriptionNames;
    static String[] initialConfigurationFileNames;
    static String[] subsystemAliases;
    static boolean printHelp;
    static boolean saveInitialConfiguration;
    static boolean migrateConfigurationFiles;
    static Options commandLineOptions;

    public static void main(String[] args) throws Exception {
        String[] argsToBeProcessed = SubsystemBoot.parseArgsCLI(args);
        if (printHelp) {
            SubsystemBoot.usageCLI(commandLineOptions);
        }
        if (descriptionNames != null) {
            int numberOfAgents = descriptionNames.length;
            if (numberOfAgents == 0) {
                throw new IllegalArgumentException("Something went wrong. There must be at least one description: " + numberOfAgents);
            }
            if (initialConfigurationFileNames != null && initialConfigurationFileNames.length != numberOfAgents) {
                throw new IllegalArgumentException("Wrong number of arguments passed to option initialConfiguration: " + initialConfigurationFileNames.length + ". It must be either empty or the same as the number of descriptions: " + numberOfAgents);
            }
            if (subsystemAliases != null && subsystemAliases.length != numberOfAgents) {
                throw new IllegalArgumentException("Wrong number of arguments passed to option alias: " + subsystemAliases.length + ". It must be either empty or the same as the number of descriptions: " + numberOfAgents);
            }
            for (int i = 0; i < numberOfAgents; ++i) {
                CCSBuilder builder = new CCSBuilder();
                String descriptionName = descriptionNames[i];
                String initialConfigurationFileName = initialConfigurationFileNames != null ? initialConfigurationFileNames[i] : null;
                try {
                    String agentAlias = subsystemAliases != null ? (subsystemAliases[i].isEmpty() ? null : subsystemAliases[i]) : null;
                    String startupConfig = null;
                    if (initialConfigurationFileName != null) {
                        startupConfig = initialConfigurationFileName;
                    }
                    HashMap<String, String> buildArgs = new HashMap<String, String>();
                    if (startupConfig != null) {
                        buildArgs.put("startupConfig", startupConfig);
                    }
                    if (descriptionName != null) {
                        buildArgs.put("descriptionName", descriptionName);
                    }
                    buildArgs.put("saveInitialConfiguration", saveInitialConfiguration ? "true" : "false");
                    buildArgs.put("migrateConfigurationFiles", migrateConfigurationFiles ? "true" : "false");
                    ComponentLookup lookup = BootUtils.buildComponentLookupFromDescription(buildArgs, agentAlias);
                    ComponentNode topNode = lookup.getTopComponentNode();
                    Object topObj = topNode.getComponent();
                    if (printHelp) {
                        if (!(topObj instanceof HasCommandLineOptions)) continue;
                        ((HasCommandLineOptions)topObj).printHelp();
                        continue;
                    }
                    if (topObj instanceof HasCommandLineOptions) {
                        try {
                            ((HasCommandLineOptions)topObj).processCommandLineOptions(argsToBeProcessed);
                        }
                        catch (ParseException e) {
                            ((HasCommandLineOptions)topObj).printHelp();
                            throw new RuntimeException("Failed to start " + descriptionName, e);
                        }
                    }
                    Subsystem a = BootUtils.getSubsystemFromLookup(lookup, agentAlias);
                    a.startAgent();
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to start subsystem with description: " + descriptionName, e);
                }
            }
        } else {
            throw new IllegalArgumentException("no description has been specified");
        }
    }

    static String[] parseArgsCLI(String[] args) {
        commandLineOptions = new Options();
        commandLineOptions.addOption("h", "help", false, "Print the help message");
        commandLineOptions.addOption("v", "verbose", false, "Turns on verbose statements");
        commandLineOptions.addOption("d", "description", true, "Name of Subsystem description file.");
        commandLineOptions.getOption("description").setArgName("DESCRIPTION_FILE");
        commandLineOptions.addOption("ic", "initialConfiguration", true, "Name of the initial Configuration properties file.");
        commandLineOptions.getOption("initialConfiguration").setArgName("INITIAL_CONFIGURATION_FILE");
        commandLineOptions.getOption("initialConfiguration").setOptionalArg(true);
        commandLineOptions.addOption("sc", "saveInitialConfiguration", false, "Save the initial Configuration properties file.");
        commandLineOptions.addOption("mcrs", "migrateConfigurationsToRemoteServer", false, "Migrate Configuration Files to the remote server");
        commandLineOptions.addOption("a", "alias", true, "Name of subsystem on the buses.");
        commandLineOptions.getOption("alias").setArgName("SUBSYSTEM_NAME");
        commandLineOptions.getOption("description").setArgs(-2);
        commandLineOptions.getOption("initialConfiguration").setArgs(-2);
        commandLineOptions.getOption("alias").setArgs(-2);
        BasicParser parser = new BasicParser();
        List[] splitArgs = BootstrapResourceUtils.separateArgumentsForOptions((String[])args, (Options)commandLineOptions);
        try {
            String[] newArgs = splitArgs[0].toArray(new String[splitArgs[0].size()]);
            CommandLine line = parser.parse(commandLineOptions, newArgs, true);
            printHelp = line.hasOption("help");
            descriptionNames = line.getOptionValues("description");
            subsystemAliases = line.getOptionValues("alias");
            initialConfigurationFileNames = line.getOptionValues("initialConfiguration");
            saveInitialConfiguration = line.hasOption("saveInitialConfiguration");
            migrateConfigurationFiles = line.hasOption("migrateConfigurationsToRemoteServer");
            if (line.hasOption("initialConfiguration") && initialConfigurationFileNames == null) {
                initialConfigurationFileNames = new String[]{""};
            }
        }
        catch (ParseException e) {
            SubsystemBoot.usageCLI(commandLineOptions);
            System.exit(0);
        }
        String[] leftOverArgs = splitArgs[1].toArray(new String[splitArgs[1].size()]);
        return leftOverArgs;
    }

    static void usageCLI(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(100, "SubsystemBoot", "", options, "", true);
    }

    static {
        subsystemAliases = null;
        printHelp = false;
        saveInitialConfiguration = false;
        migrateConfigurationFiles = false;
    }
}

