/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.lsst.ccs.Agent;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.utilities.scheduler.Scheduler;

class SchedulerNode
implements HasLifecycle {
    private static final Logger LOG = Logger.getLogger(SchedulerNode.class.getName());
    private final Scheduler scheduler;
    private final String name;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    @ConfigurationParameter(isFinal=true)
    private volatile int nThreads;
    @ConfigurationParameter(isReadOnly=true)
    private volatile int nTasks;
    private List<String> scheduledTasks = new ArrayList<String>();

    SchedulerNode(String name, int nThreads) {
        this.nThreads = nThreads;
        this.name = name;
        this.scheduler = new Scheduler(name, nThreads, new ThreadGroup("PeriodiTasks-" + name));
    }

    @Override
    public void init() {
        this.scheduler.setLogger(this.agent.getLogger());
    }

    void addTask(String name) {
        this.scheduledTasks.add(name);
        this.nTasks = this.scheduledTasks.size();
    }

    @Command(category=Command.CommandCategory.SYSTEM, type=Command.CommandType.QUERY)
    List<String> getScheduledTasks() {
        return this.scheduledTasks;
    }

    @Override
    public void postShutdown() {
        this.scheduler.shutdown();
        this.scheduler.shutdownNow();
        try {
            boolean allStopped = this.scheduler.awaitTermination(10L, TimeUnit.SECONDS);
            if (!allStopped) {
                LOG.warning(String.format("Tasks in scheduler %s are taking a long time to terminate.", this.name));
            }
        }
        catch (InterruptedException exc) {
            LOG.severe(String.format("Interrupted while waiting for scheduler %s to terminate!", this.name));
            Thread.currentThread().interrupt();
        }
    }

    Scheduler getScheduler() {
        return this.scheduler;
    }

    String getSchedulerName() {
        return this.name;
    }
}

