/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts.fpga.compiler;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Call;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Callable;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Channel;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Function;
import org.lsst.ccs.subsystem.rafts.fpga.xml.FunctionPointer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Main;
import org.lsst.ccs.subsystem.rafts.fpga.xml.RepeatFunctionPointer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.RepeatSubroutinePointer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Subroutine;
import org.lsst.ccs.subsystem.rafts.fpga.xml.SubroutinePointer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Timeslice;

public class FPGA2Model
implements Serializable {
    public static final int CMD_LINES = 0;
    public static final int CMD_TIME = 1;
    public static final int CMD_PROGFUNC = 2;
    public static final int CMD_PROGJUMP = 3;
    public static final int CMD_PROGSUBE = 4;
    public static final int CMD_PROGEND = 5;
    public static final int CMD_PROGFUNC_FP = 6;
    public static final int CMD_PROGFUNC_RP = 7;
    public static final int CMD_PROGFUNC_FRP = 8;
    public static final int CMD_PROGJUMP_AP = 9;
    public static final int CMD_PROGJUMP_RP = 10;
    public static final int CMD_PROGJUMP_ARP = 11;
    private static final long serialVersionUID = 3694475501274351773L;
    final Map<Integer, RegisterOpcode> timing = new TreeMap<Integer, RegisterOpcode>();
    final List<FPGARoutine> routines = new ArrayList<FPGARoutine>();
    final Map<Subroutine, FPGARoutine> routinesMap = new LinkedHashMap<Subroutine, FPGARoutine>();
    final Map<Function, Integer> functionsMap = new LinkedHashMap<Function, Integer>();
    final Map<SubroutinePointer, Integer> routinesPtrMap = new LinkedHashMap<SubroutinePointer, Integer>();
    final Map<FunctionPointer, Integer> functionsPtrMap = new LinkedHashMap<FunctionPointer, Integer>();
    final Map<RepeatSubroutinePointer, Integer> routinesRepPtrMap = new LinkedHashMap<RepeatSubroutinePointer, Integer>();
    final Map<RepeatFunctionPointer, Integer> functionsRepPtrMap = new LinkedHashMap<RepeatFunctionPointer, Integer>();
    int lastAddr;
    private final Map<String, String> metadata = new LinkedHashMap<String, String>();
    private final Map<String, Integer> channels = new LinkedHashMap<String, Integer>();

    public List<PointerInfo> getPointers() {
        ArrayList<PointerInfo> l = new ArrayList<PointerInfo>();
        this.functionsPtrMap.forEach((k, v) -> l.add(new PointerInfo(PointerInfo.PointerKind.FUNCTION, k.getId(), (int)v, this.functionsMap.get(k.getFunction()))));
        this.routinesPtrMap.forEach((k, v) -> l.add(new PointerInfo(PointerInfo.PointerKind.SUBROUTINE, k.getId(), (int)v, this.routinesMap.get(k.getSubroutine()).getBaseAddress())));
        this.functionsRepPtrMap.forEach((k, v) -> l.add(new PointerInfo(PointerInfo.PointerKind.REPEAT_FUNCTION, k.getId(), (int)v, k.getN())));
        this.routinesRepPtrMap.forEach((k, v) -> l.add(new PointerInfo(PointerInfo.PointerKind.REPEAT_SUBROUTINE, k.getId(), (int)v, k.getN())));
        return l;
    }

    public Map<String, PointerInfo> getPointerMap() {
        LinkedHashMap<String, PointerInfo> result = new LinkedHashMap<String, PointerInfo>();
        this.functionsPtrMap.forEach((k, v) -> result.put(k.getId(), new PointerInfo(PointerInfo.PointerKind.FUNCTION, k.getId(), (int)v, this.functionsMap.get(k.getFunction()))));
        this.routinesPtrMap.forEach((k, v) -> result.put(k.getId(), new PointerInfo(PointerInfo.PointerKind.SUBROUTINE, k.getId(), (int)v, this.routinesMap.get(k.getSubroutine()).getBaseAddress())));
        this.functionsRepPtrMap.forEach((k, v) -> result.put(k.getId(), new PointerInfo(PointerInfo.PointerKind.REPEAT_FUNCTION, k.getId(), (int)v, k.getN())));
        this.routinesRepPtrMap.forEach((k, v) -> result.put(k.getId(), new PointerInfo(PointerInfo.PointerKind.REPEAT_SUBROUTINE, k.getId(), (int)v, k.getN())));
        return result;
    }

    public Map<String, Integer> getMainAddresses() {
        LinkedHashMap<String, Integer> m = new LinkedHashMap<String, Integer>();
        this.routines.stream().filter(r -> r.orgRoutine instanceof Main).forEach(r -> m.put(r.orgRoutine.getId(), r.getBaseAddress()));
        return m;
    }

    public Map<String, Integer> getSubroutineAddresses() {
        LinkedHashMap<String, Integer> m = new LinkedHashMap<String, Integer>();
        this.routines.stream().filter(r -> !(r.orgRoutine instanceof Main)).forEach(r -> m.put(r.orgRoutine.getId(), r.getBaseAddress()));
        return m;
    }

    public Map<String, Integer> getFunctionAddresses() {
        LinkedHashMap<String, Integer> m = new LinkedHashMap<String, Integer>();
        this.functionsMap.keySet().stream().forEach(f -> m.put(f.getId(), this.functionsMap.get(f)));
        return m;
    }

    public Map<String, String> getMetadata() {
        return Collections.unmodifiableMap(this.metadata);
    }

    public Map<String, Integer> getChannels() {
        return Collections.unmodifiableMap(this.channels);
    }

    void addMetadata(String key, String value) {
        this.metadata.put(key, value);
    }

    void addChannel(String id, int value) {
        this.channels.put(id, value);
    }

    public Set<String> getMetadataKeys() {
        return this.metadata.keySet();
    }

    public String getMetadata(String key) {
        return this.metadata.get(key);
    }

    public void dump() {
        this.timing.keySet().stream().forEach(addr -> this.timing.get(addr).dump());
        this.routines.stream().forEach(r -> r.dump());
        System.out.printf("00400000 %08x // last address\n", this.lastAddr);
        System.out.println("---");
        System.out.println("--- POINTERS");
        System.out.println("---");
        this.getPointers().stream().forEach(i -> System.out.printf("%-20s  %03x  %s\n", new Object[]{i.getKind(), i.getOffset(), i.getName()}));
        System.out.println("---");
        System.out.println("--- MAINS");
        System.out.println("---");
        this.getMainAddresses().entrySet().stream().forEach(i -> System.out.printf("%-20s  %08x \n", i.getKey(), i.getValue()));
    }

    public List<AddressAndValue> getMemoryMap() {
        ArrayList<AddressAndValue> result = new ArrayList<AddressAndValue>();
        result.addAll(this.timing.values());
        for (FPGARoutine r : this.routines) {
            result.addAll(r.opcodes);
        }
        result.addAll(this.getPointers());
        return result;
    }

    public List<int[]> getCommands() {
        ArrayList<int[]> commands = new ArrayList<int[]>();
        this.timing.values().stream().forEach(r -> commands.add(r.getCommand()));
        this.routines.stream().forEach(r -> r.opcodes.stream().forEach(c -> commands.add(c.getCommand())));
        return commands;
    }

    public void validate() {
        List<PointerInfo> l = this.getPointers();
        HashSet<String> names = new HashSet<String>();
        for (PointerInfo p : l) {
            if (names.contains(p.getName())) {
                throw new RuntimeException("duplicate pointer name " + p.getName());
            }
            names.add(p.getName());
        }
        for (Function f : this.functionsMap.keySet()) {
            if (f.getId().equals("Default") || f.getTimeslices().size() > 1) continue;
            throw new RuntimeException("Function too short " + f.getId() + " " + f.getTimeslices().size());
        }
    }

    public static class PointerInfo
    extends AddressAndValue
    implements Serializable {
        private static final long serialVersionUID = -8312653354624413268L;
        private final PointerKind kind;
        private final String name;
        private final int offset;
        private final int value;

        PointerInfo(PointerKind kind, String name, int offset, int value) {
            this.kind = kind;
            this.name = name;
            this.offset = offset;
            this.value = value;
        }

        public PointerKind getKind() {
            return this.kind;
        }

        public String getName() {
            return this.name;
        }

        public int getOffset() {
            return this.offset;
        }

        @Override
        public int getAddress() {
            return this.offset + this.kind.getBaseAddress();
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public String toString() {
            return String.format("PointerInfo{kind=%s, name=%s, address=%s, value=%s}", new Object[]{this.kind, this.name, this.offset, this.value});
        }

        public static enum PointerKind {
            FUNCTION(0x350000),
            SUBROUTINE(0x370000),
            REPEAT_FUNCTION(0x360000),
            REPEAT_SUBROUTINE(0x380000);

            private final int baseAddress;

            private PointerKind(int baseAddress) {
                this.baseAddress = baseAddress;
            }

            private int getBaseAddress() {
                return this.baseAddress;
            }
        }
    }

    static class FPGARoutine
    implements Serializable {
        private static final long serialVersionUID = -268985060126274257L;
        Callable orgRoutine;
        int baseAddress;
        final List<StackOpCode> opcodes = new ArrayList<StackOpCode>();

        FPGARoutine() {
        }

        public int getBaseAddress() {
            return this.baseAddress;
        }

        public void add(StackOpCode op) {
            op.index = this.opcodes.size();
            this.opcodes.add(op);
        }

        public void dump() {
            System.out.printf("// @ %3x : %s\n", this.baseAddress, this.orgRoutine.getId());
            this.opcodes.stream().forEach(op -> op.dump());
        }
    }

    static class StackReturnOpcode
    extends StackOpCode
    implements Serializable {
        private static final long serialVersionUID = 8623730968069893135L;

        StackReturnOpcode(FPGARoutine parent) {
            super(null, parent);
        }

        @Override
        public int getValue() {
            if (this.parent.orgRoutine instanceof Main) {
                return -268435456;
            }
            return -536870912;
        }

        @Override
        public int[] getCommand() {
            int[] cmnd = new int[]{this.parent.orgRoutine instanceof Main ? 5 : 4, this.parent.getBaseAddress() + this.index};
            return cmnd;
        }

        @Override
        public String getComment() {
            if (this.parent.orgRoutine instanceof Main) {
                return "return_main";
            }
            return "return_subr";
        }
    }

    class StackSubroutinePtrRepPtrOpCode
    extends StackOpCode
    implements Serializable {
        private static final long serialVersionUID = 1725715638050287585L;

        StackSubroutinePtrRepPtrOpCode(Call call, FPGARoutine parent) {
            super(call, parent);
        }

        @Override
        public int getValue() {
            int i = FPGA2Model.this.routinesPtrMap.get(this.call.getSubroutinePointer());
            int j = FPGA2Model.this.routinesRepPtrMap.get(this.call.getRepeatSubPtr());
            return Integer.MIN_VALUE | i << 16 | j;
        }

        @Override
        public int[] getCommand() {
            int[] cmnd = new int[]{11, this.parent.getBaseAddress() + this.index, FPGA2Model.this.routinesPtrMap.get(this.call.getSubroutinePointer()), FPGA2Model.this.routinesRepPtrMap.get(this.call.getRepeatSubPtr()), FPGA2Model.this.routinesMap.get(this.call.getSubroutinePointer().getSubroutine()).getBaseAddress(), this.call.getRepeatSubPtr().getN()};
            return cmnd;
        }

        @Override
        public String getComment() {
            int i = FPGA2Model.this.routinesPtrMap.get(this.call.getSubroutinePointer());
            int j = FPGA2Model.this.routinesRepPtrMap.get(this.call.getRepeatSubPtr());
            return String.format("subroutine     %-20s #%02d     repPtr %-20s #%02d", this.call.getSubroutinePointer().getId(), i, this.call.getRepeatSubPtr().getId(), j);
        }
    }

    class StackSubroutineRepPtrOpCode
    extends StackOpCode
    implements Serializable {
        private static final long serialVersionUID = 3006672373753140538L;
        FPGARoutine callee;

        public StackSubroutineRepPtrOpCode(Call call, FPGARoutine parent, FPGARoutine callee) {
            super(call, parent);
            this.callee = callee;
        }

        @Override
        public int getValue() {
            int j = FPGA2Model.this.routinesRepPtrMap.get(this.call.getRepeatSubPtr());
            return 0x70000000 | this.callee.getBaseAddress() << 16 | j;
        }

        @Override
        public int[] getCommand() {
            int[] cmnd = new int[]{10, this.parent.getBaseAddress() + this.index, this.callee.getBaseAddress(), FPGA2Model.this.routinesRepPtrMap.get(this.call.getRepeatSubPtr()), this.call.getRepeatSubPtr().getN()};
            return cmnd;
        }

        @Override
        public String getComment() {
            int j = FPGA2Model.this.routinesRepPtrMap.get(this.call.getRepeatSubPtr());
            return String.format("subroutine     %-20s #%05x repPtr %-20s #%02d", this.callee.orgRoutine.getId(), this.callee.getBaseAddress(), this.call.getRepeatSubPtr().getId(), j);
        }
    }

    class StackSubroutinePtrOpCode
    extends StackOpCode
    implements Serializable {
        private static final long serialVersionUID = -824618818863692467L;

        public StackSubroutinePtrOpCode(Call call, FPGARoutine parent) {
            super(call, parent);
        }

        @Override
        public int getValue() {
            int i = FPGA2Model.this.routinesPtrMap.get(this.call.getSubroutinePointer());
            return 0x60000000 | i << 16 | this.call.getRepeatValue();
        }

        @Override
        public int[] getCommand() {
            int[] cmnd = new int[]{9, this.parent.getBaseAddress() + this.index, FPGA2Model.this.routinesPtrMap.get(this.call.getSubroutinePointer()), this.call.getRepeatValue(), FPGA2Model.this.routinesMap.get(this.call.getSubroutinePointer().getSubroutine()).getBaseAddress()};
            return cmnd;
        }

        @Override
        public String getComment() {
            int i = FPGA2Model.this.routinesPtrMap.get(this.call.getSubroutinePointer());
            return String.format("subroutinePtr  %-20s #%02d     repeat %5d", this.call.getSubroutinePointer().getId(), i, this.call.getRepeatValue());
        }
    }

    static class StackSubroutineOpCode
    extends StackOpCode
    implements Serializable {
        private static final long serialVersionUID = -5570330889314120999L;
        FPGARoutine callee;

        StackSubroutineOpCode(Call call, FPGARoutine parent, FPGARoutine callee) {
            super(call, parent);
            this.callee = callee;
        }

        @Override
        public int getValue() {
            return 0x50000000 | this.callee.getBaseAddress() << 16 | this.call.getRepeatValue();
        }

        @Override
        public int[] getCommand() {
            int[] cmnd = new int[]{3, this.parent.getBaseAddress() + this.index, this.callee.getBaseAddress(), this.call.getRepeatValue()};
            return cmnd;
        }

        @Override
        public String getComment() {
            if (this.call.getSubroutine() != null) {
                return String.format("subroutine     %-20s #%05x repeat %5d", this.call.getSubroutine().getId(), this.callee.getBaseAddress(), this.call.getRepeatValue());
            }
            return String.format("embedded       %-20s #%05x repeat %5d", this.callee.orgRoutine.getId(), this.callee.getBaseAddress(), this.call.getRepeatValue());
        }
    }

    class StackFunctionPtrRepPtrOpCode
    extends StackOpCode
    implements Serializable {
        private static final long serialVersionUID = 1348240880246260161L;

        StackFunctionPtrRepPtrOpCode(Call call, FPGARoutine parent) {
            super(call, parent);
        }

        @Override
        public int getValue() {
            int i = FPGA2Model.this.functionsPtrMap.get(this.call.getFunctionPointer());
            int j = FPGA2Model.this.functionsRepPtrMap.get(this.call.getRepeatFcnPtr());
            return 0x40000000 | i << 24 | j;
        }

        @Override
        public int[] getCommand() {
            int[] cmnd = new int[]{8, this.parent.getBaseAddress() + this.index, FPGA2Model.this.functionsPtrMap.get(this.call.getFunctionPointer()), FPGA2Model.this.functionsRepPtrMap.get(this.call.getRepeatFcnPtr()), FPGA2Model.this.functionsMap.get(this.call.getFunctionPointer().getFunction()), this.call.getRepeatFcnPtr().getN()};
            return cmnd;
        }

        @Override
        public String getComment() {
            int i = FPGA2Model.this.functionsPtrMap.get(this.call.getFunctionPointer());
            int j = FPGA2Model.this.functionsRepPtrMap.get(this.call.getRepeatFcnPtr());
            return String.format("functionPtr    %-20s #%02d     repPtr %-20s #%02d %s", this.call.getFunctionPointer().getId(), i, this.call.getRepeatFcnPtr().getId(), j, this.call.isInfinity() ? "infinity" : "");
        }
    }

    class StackFunctionRepPtrOpCode
    extends StackOpCode
    implements Serializable {
        private static final long serialVersionUID = 3711825773613846285L;

        StackFunctionRepPtrOpCode(Call call, FPGARoutine parent) {
            super(call, parent);
        }

        @Override
        public int getValue() {
            int i = FPGA2Model.this.functionsMap.get(this.call.getFunction());
            int j = FPGA2Model.this.functionsRepPtrMap.get(this.call.getRepeatFcnPtr());
            return 0x30000000 | i << 24 | j;
        }

        @Override
        public int[] getCommand() {
            int[] cmnd = new int[]{7, this.parent.getBaseAddress() + this.index, FPGA2Model.this.functionsMap.get(this.call.getFunction()), FPGA2Model.this.functionsRepPtrMap.get(this.call.getRepeatFcnPtr()), this.call.getRepeatFcnPtr().getN()};
            return cmnd;
        }

        @Override
        public String getComment() {
            int i = FPGA2Model.this.functionsMap.get(this.call.getFunction());
            int j = FPGA2Model.this.functionsRepPtrMap.get(this.call.getRepeatFcnPtr());
            return String.format("function       %-20s #%02d    repPtr %-20s #%02d %s", this.call.getFunction().getId(), i, this.call.getRepeatFcnPtr().getId(), j, this.call.isInfinity() ? "infinity" : "");
        }
    }

    class StackFunctionPtrOpCode
    extends StackOpCode
    implements Serializable {
        private static final long serialVersionUID = -5100915003537149337L;

        StackFunctionPtrOpCode(Call call, FPGARoutine parent) {
            super(call, parent);
        }

        @Override
        public int getValue() {
            int i = FPGA2Model.this.functionsPtrMap.get(this.call.getFunctionPointer());
            return 0x20000000 | i << 24 | (this.call.isInfinity() ? 0x800000 : 0) | this.call.getRepeatValue();
        }

        @Override
        public int[] getCommand() {
            int[] cmnd = new int[]{6, this.parent.getBaseAddress() + this.index, FPGA2Model.this.functionsPtrMap.get(this.call.getFunctionPointer()), this.call.getRepeatValue(), FPGA2Model.this.functionsMap.get(this.call.getFunctionPointer().getFunction())};
            return cmnd;
        }

        @Override
        public String getComment() {
            int i = FPGA2Model.this.functionsPtrMap.get(this.call.getFunctionPointer());
            return String.format("functionPtr    %-20s #%02d    repeat %5d %s", this.call.getFunctionPointer().getId(), i, this.call.getRepeatValue(), this.call.isInfinity() ? "infinity" : "");
        }
    }

    class StackFunctionOpCode
    extends StackOpCode
    implements Serializable {
        private static final long serialVersionUID = -1809130449104474507L;

        StackFunctionOpCode(Call call, FPGARoutine parent) {
            super(call, parent);
        }

        @Override
        public int getValue() {
            int i = FPGA2Model.this.functionsMap.get(this.call.getFunction());
            return 0x10000000 | i << 24 | (this.call.isInfinity() ? 0x800000 : 0) | this.call.getRepeatValue();
        }

        @Override
        public int[] getCommand() {
            int[] cmnd = new int[]{2, this.parent.getBaseAddress() + this.index, FPGA2Model.this.functionsMap.get(this.call.getFunction()), this.call.getRepeatValue()};
            return cmnd;
        }

        @Override
        public String getComment() {
            int i = FPGA2Model.this.functionsMap.get(this.call.getFunction());
            return String.format("function       %-20s #%02d    repeat %5d %s", this.call.getFunction().getId(), i, this.call.getRepeatValue(), this.call.isInfinity() ? "infinity" : "");
        }
    }

    static abstract class StackOpCode
    extends RegisterOpcode
    implements Serializable {
        private static final long serialVersionUID = -7599004220314921745L;
        final Call call;
        final FPGARoutine parent;
        int index;

        StackOpCode(Call call, FPGARoutine parent) {
            this.call = call;
            this.parent = parent;
        }

        @Override
        public int getAddress() {
            return 0x300000 | this.parent.getBaseAddress() + this.index;
        }
    }

    static class EndSliceTime
    extends RegisterOpcode
    implements Serializable {
        private static final long serialVersionUID = 2688075986647178842L;
        private final int functionIndex;
        private final Function function;
        private final int sliceIndex;

        EndSliceTime(int functionIndex, Function function, int sliceIndex) {
            this.functionIndex = functionIndex;
            this.function = function;
            this.sliceIndex = sliceIndex;
        }

        @Override
        public int getAddress() {
            return 0x200000 | this.functionIndex << 4 | this.sliceIndex;
        }

        @Override
        public int getValue() {
            return 0;
        }

        @Override
        public int[] getCommand() {
            int[] cmnd = new int[]{1, this.functionIndex, this.sliceIndex, 0};
            return cmnd;
        }

        @Override
        public String getComment() {
            return String.format("%-20s  end", this.function.getId());
        }
    }

    static class SliceTime
    extends RegisterOpcode
    implements Serializable {
        private static final long serialVersionUID = -386728319462273830L;
        private final int functionIndex;
        private final Function function;
        private final Timeslice s;

        SliceTime(int functionIndex, Function function, Timeslice s) {
            this.functionIndex = functionIndex;
            this.function = function;
            this.s = s;
        }

        @Override
        public int getAddress() {
            return 0x200000 | this.functionIndex << 4 | this.s.getIndex();
        }

        @Override
        public int getValue() {
            return this.s.getDurationNanos() / 10;
        }

        @Override
        public int[] getCommand() {
            int[] cmnd = new int[]{1, this.functionIndex, this.s.getIndex(), this.s.getDurationNanos() / 10};
            return cmnd;
        }

        @Override
        public String getComment() {
            return String.format("%-20s  @%-5d %-5d : %s", this.function.getId(), this.s.getStartNanos(), this.s.getDurationNanos(), this.s.getValue());
        }
    }

    static class SliceValues
    extends RegisterOpcode
    implements Serializable {
        private static final long serialVersionUID = -4763340493598561416L;
        private final int functionIndex;
        private final Function function;
        private final Timeslice s;
        private List<Integer> upConstant = new ArrayList<Integer>();

        SliceValues(int functionIndex, Function function, Timeslice s) {
            this.functionIndex = functionIndex;
            this.function = function;
            this.s = s;
            function.getConstants().stream().filter(c -> c.getValue().equals("1")).forEach(c -> this.upConstant.add(c.getChannel().getValue()));
        }

        @Override
        public int getAddress() {
            return 0x100000 | this.functionIndex << 4 | this.s.getIndex();
        }

        @Override
        public int getValue() {
            int w = 0;
            Iterator<Serializable> iterator = this.upConstant.iterator();
            while (iterator.hasNext()) {
                int jc = iterator.next();
                w |= 1 << jc;
            }
            for (Channel c : this.s.getUpChannels()) {
                w |= 1 << c.getValue();
            }
            return w;
        }

        @Override
        public int[] getCommand() {
            int[] cmnd = new int[this.upConstant.size() + this.s.getUpChannels().size() + 3];
            int j = 0;
            cmnd[j++] = 0;
            cmnd[j++] = this.functionIndex;
            cmnd[j++] = this.s.getIndex();
            Iterator<Serializable> iterator = this.upConstant.iterator();
            while (iterator.hasNext()) {
                int jc = iterator.next();
                cmnd[j++] = jc;
            }
            for (Channel c : this.s.getUpChannels()) {
                cmnd[j++] = c.getValue();
            }
            return cmnd;
        }

        @Override
        public String getComment() {
            return String.format("%-20s  @%-5d %-5d : %s", this.function.getId(), this.s.getStartNanos(), this.s.getDurationNanos(), this.s.getValue());
        }
    }

    private static abstract class RegisterOpcode
    extends AddressAndValue {
        private RegisterOpcode() {
        }

        public abstract int[] getCommand();

        public abstract String getComment();

        public void dump() {
            System.out.printf("%08x %08x // %s\n", this.getAddress(), this.getValue(), this.getComment());
        }
    }

    public static abstract class AddressAndValue
    implements Serializable {
        private static final long serialVersionUID = -1583904741063682560L;

        public abstract int getAddress();

        public abstract int getValue();
    }
}

