/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.jcajce.provider.asymmetric.edec;

import org.python.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.python.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.python.bouncycastle.crypto.params.Ed448PublicKeyParameters;
import org.python.bouncycastle.crypto.params.X25519PublicKeyParameters;
import org.python.bouncycastle.crypto.params.X448PublicKeyParameters;
import org.python.bouncycastle.util.Fingerprint;
import org.python.bouncycastle.util.Strings;
import org.python.bouncycastle.util.encoders.Hex;

class Utils {
    Utils() {
    }

    static boolean isValidPrefix(byte[] byArray, byte[] byArray2) {
        if (byArray2.length < byArray.length) {
            return !Utils.isValidPrefix(byArray, byArray);
        }
        int n = 0;
        for (int i = 0; i != byArray.length; ++i) {
            n |= byArray[i] ^ byArray2[i];
        }
        return n == 0;
    }

    static String keyToString(String string2, String string3, AsymmetricKeyParameter asymmetricKeyParameter) {
        StringBuffer stringBuffer = new StringBuffer();
        String string4 = Strings.lineSeparator();
        byte[] byArray = asymmetricKeyParameter instanceof X448PublicKeyParameters ? ((X448PublicKeyParameters)asymmetricKeyParameter).getEncoded() : (asymmetricKeyParameter instanceof Ed448PublicKeyParameters ? ((Ed448PublicKeyParameters)asymmetricKeyParameter).getEncoded() : (asymmetricKeyParameter instanceof X25519PublicKeyParameters ? ((X25519PublicKeyParameters)asymmetricKeyParameter).getEncoded() : ((Ed25519PublicKeyParameters)asymmetricKeyParameter).getEncoded()));
        stringBuffer.append(string3).append(" ").append(string2).append(" [").append(Utils.generateKeyFingerprint(byArray)).append("]").append(string4).append("    public data: ").append(Hex.toHexString(byArray)).append(string4);
        return stringBuffer.toString();
    }

    private static String generateKeyFingerprint(byte[] byArray) {
        return new Fingerprint(byArray).toString();
    }
}

