/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image.demo;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.FutureTask;
import nom.tam.fits.FitsException;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.E2VCCDType;
import org.lsst.ccs.utilities.ccd.Raft;
import org.lsst.ccs.utilities.ccd.Reb;
import org.lsst.ccs.utilities.ccd.Segment;
import org.lsst.ccs.utilities.image.FitsFileWriter;
import org.lsst.ccs.utilities.image.FitsHeaderUtilities;
import org.lsst.ccs.utilities.image.FitsHeadersSpecificationsBuilder;
import org.lsst.ccs.utilities.image.ImageSet;
import org.lsst.ccs.utilities.image.ReadOutParameters;
import org.lsst.ccs.utilities.image.patterns.GeneratedImage;
import org.lsst.ccs.utilities.image.patterns.PatternGeneratorFactory;

public class RaftsFitsWritingDemo {
    private static final String fitsFileName = "/tmp/R99_S%d%d";

    public static void main(String[] argv) throws IOException, FitsException, InterruptedException {
        FitsHeadersSpecificationsBuilder headerSpecsBuilder = new FitsHeadersSpecificationsBuilder();
        headerSpecsBuilder.addSpecFile("primary");
        headerSpecsBuilder.addSpecFile("extended");
        headerSpecsBuilder.addSpecFile("test_cond");
        E2VCCDType type = new E2VCCDType();
        Raft raft = Raft.createRaft(type);
        GeneratedImage generatedImage = PatternGeneratorFactory.generateImageForGeometry(raft, "ripples", null);
        PatternGeneratorFactory.exposeGeometryToGeneratedImage(raft, generatedImage);
        RaftsFitsWritingDemo.writeFitsFilesForRaft(raft, true, headerSpecsBuilder);
        RaftsFitsWritingDemo.writeFitsFilesForRaft(raft, false, headerSpecsBuilder);
    }

    private static void writeFitsFilesForRaft(Raft raft, boolean inParallel, FitsHeadersSpecificationsBuilder headerSpecsBuilder) throws IOException, FitsException, InterruptedException {
        String how = inParallel ? "in parallel" : "sequentially";
        System.out.print("Writing out fits files " + how);
        long start = System.currentTimeMillis();
        Thread[] ts = new Thread[raft.getParallelChildrenCount() * 3];
        for (int rebId = 0; rebId < raft.getParallelChildrenCount(); ++rebId) {
            Reb reb = (Reb)raft.getChild(rebId, 0);
            for (int ccdId = 0; ccdId < 3; ++ccdId) {
                File raftFile;
                CCD ccd = (CCD)reb.getChild(0, ccdId);
                String raftName = String.format(fitsFileName, rebId, ccdId);
                if (inParallel) {
                    raftName = raftName + "_parallel";
                }
                if ((raftFile = new File(raftName + ".fits")).exists()) {
                    raftFile.delete();
                }
                ImageSet imageSet = FitsHeaderUtilities.createImageSetForCCD(ccd);
                FitsFileWriter ffw = new FitsFileWriter(raftFile, imageSet, headerSpecsBuilder.getHeaderSpecifications());
                if (inParallel) {
                    Thread t;
                    ts[rebId * 3 + ccdId] = t = new Thread(new FitsFileWriterRunnable(ffw, ccd.getSegments(), imageSet.getReadOutParameters()));
                    t.start();
                    continue;
                }
                for (Segment segment : ccd.getSegments()) {
                    ffw.write(segment.getChannel() - 1, segment.getRawImageData(imageSet.getReadOutParameters()).getImageData());
                }
            }
        }
        if (inParallel) {
            for (Thread t : ts) {
                t.join();
            }
        }
        double totalTime = (double)(System.currentTimeMillis() - start) / 1000.0;
        System.out.println(" took " + totalTime + " seconds");
    }

    private static class FitsFileWriterRunnable
    implements Runnable {
        private final FitsFileWriter ffw;
        private final List<Segment> segments;
        private final ReadOutParameters readOutParameters;

        FitsFileWriterRunnable(FitsFileWriter ffw, List<Segment> segments, ReadOutParameters readOutParameters) {
            this.ffw = ffw;
            this.segments = segments;
            this.readOutParameters = readOutParameters;
        }

        @Override
        public void run() {
            try {
                FutureTask[] segmentThreads = new FutureTask[this.segments.size()];
                for (Segment segment : this.segments) {
                    segmentThreads[segment.getChannel() - 1] = this.ffw.asyncWrite(segment.getChannel() - 1, segment.getRawImageData(this.readOutParameters).getImageData());
                }
                for (Segment segment : this.segments) {
                    segmentThreads[segment.getChannel() - 1].get();
                }
            }
            catch (Exception ioe) {
                throw new RuntimeException(ioe);
            }
        }
    }
}

