/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.dsp;

import org.lsst.ccs.utilities.dsp.DigitalFilter;

public class FIRFilter
implements DigitalFilter {
    private static final long serialVersionUID = 2786444222861355300L;
    double rate;
    int order;
    double[] history;
    int ip;
    double[] aCoeff;

    protected FIRFilter(double[] coeff) {
        this.aCoeff = coeff;
        this.order = coeff.length - 1;
        this.history = new double[this.order + 1];
        this.ip = 0;
    }

    @Override
    public void reset() {
        for (int i = 0; i <= this.order; ++i) {
            this.history[i] = 0.0;
        }
        this.ip = 0;
    }

    public double getRate() {
        return this.rate;
    }

    @Override
    public int getDelay() {
        return this.order / 2;
    }

    @Override
    public double flush() {
        return this.apply(0.0);
    }

    @Override
    public double apply(double signal) {
        ++this.ip;
        if (this.ip >= this.order) {
            this.ip = 0;
        }
        this.history[this.ip] = signal;
        double resp = 0.0;
        for (int i = 0; i <= this.order; ++i) {
            int j = (this.ip - i) % (this.order + 1);
            if (j < 0) {
                j += this.order + 1;
            }
            resp += this.aCoeff[i] * this.history[j];
        }
        return resp;
    }

    @Override
    public double freqResp(double freq) {
        return 0.0;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public void print() {
        System.out.println("FIRFilter order " + this.order);
        for (int i = 0; i <= this.order; ++i) {
            System.out.println("  a[" + i + "] = " + this.aCoeff[i]);
        }
        System.out.println("---");
    }

    @Override
    public Object clone() {
        try {
            FIRFilter f = (FIRFilter)super.clone();
            f.history = new double[this.order + 1];
            return f;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

