/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.mmm.raftsim;

import java.io.Serializable;
import java.time.Duration;
import java.util.concurrent.ScheduledFuture;
import org.lsst.ccs.subsystem.mmm.data.InvalidStateException;
import org.lsst.ccs.subsystem.mmm.raftsim.RaftSim;

public enum RaftInternalState implements Serializable
{
    CLEARING{

        @Override
        public void enter(RaftSim r) {
            this.scheduleTransition(r, clearingDuration, QUIESCENT);
        }
    }
    ,
    QUIESCENT{
        private transient ScheduledFuture<RaftInternalState> clearTransition = null;

        @Override
        public RaftInternalState clear(RaftSim r) {
            return CLEARING;
        }

        @Override
        public RaftInternalState integrate(RaftSim r) {
            return INTEGRATING;
        }

        @Override
        public void enter(RaftSim r) {
            this.clearTransition = this.scheduleTransition(r, clearOkDuration, NEEDS_CLEAR);
        }

        @Override
        public void exit(RaftSim r) {
            if (this.clearTransition != null) {
                this.clearTransition.cancel(false);
            }
            this.clearTransition = null;
        }
    }
    ,
    INTEGRATING{

        @Override
        public RaftInternalState readout(RaftSim r) {
            return READING_OUT;
        }

        @Override
        public RaftInternalState clear(RaftSim r) {
            return CLEARING;
        }

        @Override
        public RaftInternalState discardRows(RaftSim r) {
            return this;
        }
    }
    ,
    READING_OUT{

        @Override
        public void enter(RaftSim r) {
            this.scheduleTransition(r, readoutTime, QUIESCENT);
        }
    }
    ,
    NEEDS_CLEAR{

        @Override
        public RaftInternalState clear(RaftSim r) {
            return CLEARING;
        }
    };

    private static final Duration clearingDuration;
    private static final Duration clearOkDuration;
    private static final Duration readoutTime;

    public RaftInternalState clear(RaftSim r) {
        r.getLogger().error((Object)("invalid clear command, from state " + this));
        throw new InvalidStateException("RAFTS:" + this.toString(), "clear");
    }

    public RaftInternalState integrate(RaftSim r) {
        r.getLogger().error((Object)("invalid integrate command, from state " + this));
        throw new InvalidStateException("RAFTS:" + this.toString(), "integrate");
    }

    public RaftInternalState readout(RaftSim r) {
        r.getLogger().error((Object)("invalid readout command, from state " + this));
        throw new InvalidStateException("RAFTS:" + this.toString(), "readout");
    }

    public RaftInternalState discardRows(RaftSim r) {
        r.getLogger().error((Object)("invalid discardRows command, from state " + this));
        throw new InvalidStateException("RAFTS:" + this.toString(), "readout");
    }

    public void enter(RaftSim r) {
    }

    public void exit(RaftSim r) {
    }

    public static synchronized RaftInternalState scheduled(RaftSim r, RaftInternalState from, RaftInternalState to) {
        r.getLogger().debug((Object)(" scheduled: " + to));
        r.setState(to);
        return to;
    }

    public ScheduledFuture<RaftInternalState> scheduleTransition(RaftSim r, Duration delay, RaftInternalState to) {
        return r.scheduleTransition(delay, to);
    }

    static {
        clearingDuration = Duration.ofMillis(70L);
        clearOkDuration = Duration.ofMillis(4000L);
        readoutTime = Duration.ofMillis(2000L);
    }
}

