/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb.sim;

import java.util.ArrayList;
import java.util.List;
import org.lsst.ccs.drivers.reb.GlobalClient;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.sim.AddressSpace;
import org.lsst.ccs.drivers.reb.sim.DAQSimulation;
import org.lsst.ccs.drivers.reb.sim.HandleAndIdManager;
import org.lsst.ccs.drivers.reb.sim.SimulationException;

public class GlobalClientSimulation
implements GlobalClient.Impl {
    private final HandleAndIdManager manager;
    private List<AddressSpace> addressSpaces;
    private final DAQSimulation daq;

    GlobalClientSimulation(HandleAndIdManager manager, DAQSimulation daq) {
        this.manager = manager;
        this.daq = daq;
    }

    @Override
    public void setRegisterList(int rebType, int[] registers) {
        this.daq.setRegisterList(rebType, registers);
    }

    @Override
    public void triggerImage(String name) {
        if (this.addressSpaces == null) {
            throw new SimulationException("triggerImage called but no ids registered");
        }
        this.daq.setImageName(name);
        for (AddressSpace as : this.addressSpaces) {
            int state = as.read(8);
            as.write(9, state |= 4);
        }
    }

    @Override
    public void deleteGlobalClient() {
        this.addressSpaces = null;
    }

    @Override
    public void newGlobalClient(int[] ids, String[] ifc) throws REBException {
        if (this.addressSpaces != null) {
            throw new SimulationException("Unsupported repeat call to newGlobalClient");
        }
        ArrayList<AddressSpace> seqs = new ArrayList<AddressSpace>();
        for (int id : ids) {
            AddressSpace as = this.manager.getAddressSpaceForId(id);
            seqs.add(as);
        }
        this.addressSpaces = seqs;
    }
}

