/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config.remote;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.config.ConfigurationDescription;
import org.lsst.ccs.config.ConfigurationServiceException;
import org.lsst.ccs.config.ConfigurationView;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.AgentPresenceManager;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.utilities.logging.Logger;

@Deprecated
public class CCSBusesConfigurationDAO {
    private final AgentPresenceManager apm;
    private final ConcurrentMessagingUtils cmu;
    private static final String DB_NAME = "localdb/configuration-server";
    Logger log = Logger.getLogger((String)"org.lsst.ccs.config");
    private final String agentName;
    private final String sourceName;

    public CCSBusesConfigurationDAO(AgentMessagingLayer aml, String sourceName) {
        this.cmu = new ConcurrentMessagingUtils(aml);
        this.apm = aml.getAgentPresenceManager();
        this.agentName = aml.getAgentInfo().getName();
        this.sourceName = sourceName;
        this.log.debug((Object)"instanciated CCSBusesConfigurationDAO");
    }

    private void waitForService() {
        try {
            this.apm.waitForAgent(DB_NAME, 10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public ConfigurationDescription saveChangesForCategoriesAs(ConfigurationDescription configDesc, ConfigurationInfo configInfo) throws ConfigurationServiceException {
        return this.registerConfiguration(configInfo);
    }

    public ConfigurationView loadConfiguration(ConfigurationDescription configDesc) throws ConfigurationServiceException {
        try {
            this.log.debug((Object)("loadConfiguration " + this.agentName + " " + configDesc));
            this.log.debug((Object)("remote loadconfig desc tags " + configDesc.getCategoriesSet()));
            this.waitForService();
            this.log.debug((Object)("sending command " + this.agentName + " " + configDesc));
            return (ConfigurationView)this.cmu.sendSynchronousCommand(new CommandRequest(DB_NAME, "loadConfigurationForSource", new Object[]{this.sourceName, configDesc}));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ConfigurationServiceException("remote configuration error", ex);
        }
    }

    public ConfigurationView loadGlobalConfiguration(String name, int version) {
        try {
            this.log.debug((Object)("loadGlobalConfiguration " + this.agentName + " " + name + " " + version));
            return (ConfigurationView)this.cmu.sendSynchronousCommand(new CommandRequest(DB_NAME, "loadGlobalConfigurationForSource", new Object[]{this.sourceName, name, version}));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ConfigurationServiceException("remote configuration error", ex);
        }
    }

    public Set<String> findAvailableConfigurationsForCategory(String category) {
        return null;
    }

    public boolean isAvailable() {
        return this.apm.agentExists("localdb");
    }

    public ConfigurationDescription registerConfiguration(ConfigurationInfo configInfo) throws ConfigurationServiceException {
        try {
            this.log.debug((Object)("registerConfiguration " + this.agentName + " " + configInfo));
            return (ConfigurationDescription)this.cmu.sendSynchronousCommand(new CommandRequest(DB_NAME, "registerConfigurationForSource", new Object[]{this.sourceName, configInfo}));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ConfigurationServiceException("remote configuration error", ex);
        }
    }
}

