/*
 * Decompiled with CFR 0.152.
 */
package com.ifountain.opsgenie.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ifountain.opsgenie.client.OpsGenieClientValidationException;
import com.ifountain.opsgenie.client.model.BaseResponse;
import com.ifountain.opsgenie.client.model.Request;
import com.ifountain.opsgenie.client.util.JsonUtils;
import java.util.Map;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonPropertyOrder(alphabetic=true)
public abstract class BaseRequest<T extends BaseResponse, K extends BaseRequest>
implements Request {
    private String apiKey;

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public K withApiKey(String apiKey) {
        this.apiKey = apiKey;
        return (K)this;
    }

    @JsonIgnore
    public void validate() throws OpsGenieClientValidationException {
        if (this.apiKey == null) {
            throw OpsGenieClientValidationException.missingMandatoryProperty("apiKey");
        }
    }

    @JsonIgnore
    @Deprecated
    public String getCustomerKey() {
        return this.apiKey;
    }

    @Deprecated
    public void setCustomerKey(String apiKey) {
        this.setApiKey(apiKey);
    }

    @Deprecated
    public Map serialize() throws OpsGenieClientValidationException {
        this.validate();
        try {
            return JsonUtils.toMap(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public abstract T createResponse();
}

