/*
 * Decompiled with CFR 0.152.
 */
package com.ifountain.opsgenie.client.http;

import com.ifountain.opsgenie.client.http.OpsGenieHttpClient;
import com.ifountain.opsgenie.client.http.OpsGenieHttpResponse;
import com.ifountain.opsgenie.client.http.OpsgenieRequestRetryHandler;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.RequestWrapper;
import org.apache.http.protocol.HttpContext;

public class DefaultOpsgenieRequestRetryHandler
implements OpsgenieRequestRetryHandler {
    private Log log = LogFactory.getLog(OpsGenieHttpClient.class);
    private int maxRetryCount;
    private long waitTime = 500L;

    public DefaultOpsgenieRequestRetryHandler() {
        this(5);
    }

    public DefaultOpsgenieRequestRetryHandler(int maxRetryCount) {
        this.maxRetryCount = maxRetryCount;
    }

    public long getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(long waitTime) {
        this.waitTime = waitTime;
    }

    public void setMaxRetryCount(int maxRetryCount) {
        this.maxRetryCount = maxRetryCount;
    }

    public int getMaxRetryCount() {
        return this.maxRetryCount;
    }

    @Override
    public boolean retryRequest(HttpRequest request, OpsGenieHttpResponse response, int executionCount) {
        return (response.getStatusCode() >= 500 || response.getStatusCode() == 408) && this.retry(request, response, null, executionCount);
    }

    public boolean retryRequest(IOException e, int executionCount, HttpContext httpContext) {
        HttpRequest request = (HttpRequest)httpContext.getAttribute("http.request");
        return !this.requestIsAborted(request) && this.retry(request, null, e, executionCount);
    }

    protected boolean requestIsAborted(HttpRequest request) {
        HttpRequest req = request;
        if (request instanceof RequestWrapper) {
            req = ((RequestWrapper)request).getOriginal();
        }
        return req instanceof HttpUriRequest && ((HttpUriRequest)req).isAborted();
    }

    private boolean retry(HttpRequest request, OpsGenieHttpResponse response, IOException exception, int executionCount) {
        if (executionCount > this.maxRetryCount) {
            return false;
        }
        String uri = null;
        if (request.getRequestLine() != null) {
            uri = request.getRequestLine().getUri();
        }
        request.getRequestLine().getUri();
        if (response != null) {
            this.log.info((Object)("Retrying request [" + uri + "] ResponseCode:[" + response.getStatusCode() + "]. RetryCount " + executionCount));
        } else {
            this.log.info((Object)("Retrying request [" + uri + "]. Reason:[" + exception.getMessage() + "]. RetryCount " + executionCount));
        }
        try {
            Thread.sleep(this.pauseExp(executionCount));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    private long pauseExp(int retryCount) {
        return (long)retryCount * this.waitTime;
    }
}

