/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.joda.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.datatype.joda.cfg.FormatConfig;
import com.fasterxml.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import com.fasterxml.jackson.datatype.joda.deser.JodaDateDeserializerBase;
import java.io.IOException;
import java.util.TimeZone;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;

public class LocalDateTimeDeserializer
extends JodaDateDeserializerBase<LocalDateTime> {
    private static final long serialVersionUID = 1L;

    public LocalDateTimeDeserializer() {
        this(FormatConfig.DEFAULT_LOCAL_DATETIME_PARSER);
    }

    public LocalDateTimeDeserializer(JacksonJodaDateFormat format) {
        super(LocalDateTime.class, format);
    }

    @Override
    public JodaDateDeserializerBase<?> withFormat(JacksonJodaDateFormat format) {
        return new LocalDateTimeDeserializer(format);
    }

    public LocalDateTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        switch (p.getCurrentTokenId()) {
            case 6: {
                String str = p.getText().trim();
                return str.length() == 0 ? null : this._format.createParser(ctxt).parseLocalDateTime(str);
            }
            case 7: {
                DateTimeZone tz = this._format.isTimezoneExplicit() ? this._format.getTimeZone() : DateTimeZone.forTimeZone((TimeZone)ctxt.getTimeZone());
                return new LocalDateTime(p.getLongValue(), tz);
            }
            case 3: {
                JsonToken t = p.nextToken();
                LocalDateTime dt = null;
                if (t.isNumeric()) {
                    int year = p.getIntValue();
                    t = p.nextToken();
                    if (t.isNumeric()) {
                        int month = p.getIntValue();
                        t = p.nextToken();
                        if (t.isNumeric()) {
                            int day = p.getIntValue();
                            t = p.nextToken();
                            if (t.isNumeric()) {
                                int hour = p.getIntValue();
                                t = p.nextToken();
                                if (t.isNumeric()) {
                                    int minute = p.getIntValue();
                                    t = p.nextToken();
                                    if (t.isNumeric()) {
                                        int second = p.getIntValue();
                                        t = p.nextToken();
                                        int millisecond = 0;
                                        if (t.isNumeric()) {
                                            millisecond = p.getIntValue();
                                            t = p.nextToken();
                                        }
                                        dt = new LocalDateTime(year, month, day, hour, minute, second, millisecond);
                                    }
                                }
                            }
                        }
                    }
                }
                if (t == JsonToken.END_ARRAY) {
                    return dt;
                }
                throw ctxt.wrongTokenException(p, JsonToken.END_ARRAY, "after LocalDateTime ints");
            }
        }
        throw ctxt.wrongTokenException(p, JsonToken.START_ARRAY, "expected String, Number or JSON Array");
    }
}

