import org.lsst.ccs.description.groovy.CCSBuilder;
import org.lsst.ccs.subsystem.mmm.MMM_IR2;
import org.lsst.ccs.subsystem.mmm.MinionIR2;
import org.lsst.ccs.subsystem.mmm.MinionIR2Group;
import org.lsst.ccs.subsystem.mmm.AlertDispatcher.AlertHandler;
import org.lsst.ccs.subsystem.mmm.AlertDispatcher.AlertAction;
import org.lsst.ccs.subsystem.mmm.AlertDispatcher.EmailAlertAction;
import org.lsst.ccs.subsystem.mmm.AlertDispatcher.CommandAlertAction;
import org.lsst.ccs.subsystem.mmm.AlertDispatcher;
import org.lsst.ccs.subsystem.mmm.AlertNotification;
import org.lsst.ccs.subsystem.rafts.alerts.RaftAlert;
import org.lsst.ccs.bus.states.AlertState;
import java.util.function.Predicate;
import org.lsst.ccs.subsystem.mmm.ir2.actions.RebTemperatureTooHighAction
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;

CCSBuilder builder = ["mmm_demo"]

//Dummy AlertAction to print something
class PrintWhatToDo extends AlertAction {
    def msg;
    PrintWhatToDo(String msg) {
        this.msg = msg;
    }
        
    def void accept(AlertNotification notif) {
        System.out.println(notif.getSeverity().toString()+" "+msg);
    }        

    def String getDescription() {
        return "Prints to standard output: "+msg;
    }        
}


builder.
    main(MMM_IR2, 
        minions:[(MinionIR2Group.INFRASTRUCTURE):["demo":MinionIR2.RAFT] ]) {

    infrastructure (AlertDispatcher, group: MinionIR2Group.INFRASTRUCTURE) {
        printSomething (AlertHandler, handlerName: "someAction" ) {
            printWhatToDo2 (PrintWhatToDo, msg: "SOME ALERT: Something needs to be done")
        }
    }
    
}