/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image;

import java.util.List;
import org.lsst.ccs.utilities.image.FitsHeaderMetadataProvider;
import org.lsst.ccs.utilities.image.ImageSet;
import org.lsst.ccs.utilities.image.MetaDataSet;

class CompositeFitsHeaderMetadataProvider
implements FitsHeaderMetadataProvider {
    private final List<FitsHeaderMetadataProvider> providers;

    public CompositeFitsHeaderMetadataProvider(List<FitsHeaderMetadataProvider> providers) {
        this.providers = providers;
    }

    @Override
    public MetaDataSet getPrimaryHeaderMetadata(ImageSet imageSet) {
        MetaDataSet resultingHeaderMetadata = new MetaDataSet();
        for (FitsHeaderMetadataProvider provider : this.providers) {
            resultingHeaderMetadata.addMetaDataSet(provider.getPrimaryHeaderMetadata(imageSet));
        }
        return resultingHeaderMetadata;
    }

    @Override
    public MetaDataSet getDataExtendedHeaderMetadata(ImageSet imageSet, int extendedIndex) {
        MetaDataSet resultingHeaderMetadata = new MetaDataSet();
        for (FitsHeaderMetadataProvider provider : this.providers) {
            resultingHeaderMetadata.addMetaDataSet(provider.getDataExtendedHeaderMetadata(imageSet, extendedIndex));
        }
        return resultingHeaderMetadata;
    }

    @Override
    public MetaDataSet getAdditionalExtendedHeaderMetadata(ImageSet imageSet, String extendedKeyword) {
        MetaDataSet resultingHeaderMetadata = new MetaDataSet();
        for (FitsHeaderMetadataProvider provider : this.providers) {
            resultingHeaderMetadata.addMetaDataSet(provider.getAdditionalExtendedHeaderMetadata(imageSet, extendedKeyword));
        }
        return resultingHeaderMetadata;
    }

    @Override
    public void completedHeaderMetadata(ImageSet imageSet) {
        for (FitsHeaderMetadataProvider provider : this.providers) {
            provider.completedHeaderMetadata(imageSet);
        }
    }
}

