/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.rest.file.server.client.implementation;

import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import org.lsst.ccs.web.rest.file.server.data.RestFileInfo;

class RestFileAttributes
implements BasicFileAttributes {
    private final RestFileInfo info;

    RestFileAttributes(RestFileInfo info) {
        if (info == null) {
            throw new NullPointerException();
        }
        this.info = info;
    }

    @Override
    public FileTime lastModifiedTime() {
        return FileTime.fromMillis(this.info.getLastModified());
    }

    @Override
    public FileTime lastAccessTime() {
        return FileTime.fromMillis(this.info.getLastAccessTime());
    }

    @Override
    public FileTime creationTime() {
        return FileTime.fromMillis(this.info.getCreationTime());
    }

    @Override
    public boolean isRegularFile() {
        return this.info.isRegularFile() && !this.info.isVersionedFile();
    }

    @Override
    public boolean isDirectory() {
        return this.info.isDirectory();
    }

    @Override
    public boolean isSymbolicLink() {
        return this.info.isSymbolicLink();
    }

    @Override
    public boolean isOther() {
        return this.info.isOther() || this.info.isVersionedFile();
    }

    @Override
    public long size() {
        return this.info.getSize();
    }

    @Override
    public Object fileKey() {
        return this.info.getFileKey();
    }
}

