package org.lsst.ccs.subsystem.mmm;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Agent;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.LogMessage;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.LogMessageListener;
import org.lsst.ccs.utilities.logging.DailyRollingFileHandler;

/**
 *
 * @author The LSST CCS Team
 */
public class LogBusModule implements HasLifecycle, LogMessageListener {

    private static final Logger LOG = Logger.getLogger(LogBusModule.class.getName());
    
    @LookupField (strategy=LookupField.Strategy.TREE)
    private Agent mmm;
    
    public LogBusModule() throws IOException {
    }
    
    
    @Override
    public void postInit() {
        LogBusModuleFileHandler logBusFileHandler = new LogBusModuleFileHandler();
        
        LOG.setUseParentHandlers(false);
        LOG.addHandler(logBusFileHandler);                
        
        mmm.getMessagingAccess().addLogMessageListener(this, BusMessageFilterFactory.messageOrigin(null));
    }

    @Override
    public void onLogMessage(LogMessage msg) {
        Level msgLevel = Level.parse(msg.getLevel());
        LOG.log(msgLevel, "Log message from "+msg.getOriginAgentInfo().getName()+": "+msg.getFormattedDetails());
    }
    
    private class LogBusModuleFileHandler extends DailyRollingFileHandler {
        
    }
    
    
    
    
    
}
