/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.gui;

import org.astrogrid.samp.Client;
import org.astrogrid.samp.Subscriptions;
import org.astrogrid.samp.client.HubConnection;
import org.astrogrid.samp.client.SampException;
import org.astrogrid.samp.gui.GuiHubConnector;
import org.astrogrid.samp.gui.SelectiveClientListModel;

public class SubscribedClientListModel
extends SelectiveClientListModel {
    private final GuiHubConnector connector_;
    private String[] mtypes_;

    public SubscribedClientListModel(GuiHubConnector connector, String[] mtypes) {
        super(connector.getClientListModel());
        this.connector_ = connector;
        this.mtypes_ = (String[])mtypes.clone();
        this.init();
    }

    public SubscribedClientListModel(GuiHubConnector connector, String mtype) {
        this(connector, new String[]{mtype});
    }

    public void setMTypes(String[] mtypes) {
        this.mtypes_ = (String[])mtypes.clone();
        this.refresh();
        this.fireContentsChanged(this, -1, -1);
    }

    public String[] getMTypes() {
        return this.mtypes_;
    }

    protected boolean isIncluded(Client client) {
        String selfId;
        try {
            HubConnection connection = this.connector_.getConnection();
            if (connection == null) {
                return false;
            }
            selfId = connection.getRegInfo().getSelfId();
        }
        catch (SampException e) {
            return false;
        }
        if (client.getId().equals(selfId)) {
            return false;
        }
        Subscriptions subs = client.getSubscriptions();
        if (subs != null) {
            for (int im = 0; im < this.mtypes_.length; ++im) {
                if (!subs.isSubscribed(this.mtypes_[im])) continue;
                return true;
            }
        }
        return false;
    }
}

