/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.mmm;

import java.io.Serializable;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;

public class AlertNotification
implements Serializable {
    private static final long serialVersionUID = 7961750855058095737L;
    private final Enum group;
    private final Enum type;
    private String origin;
    private String cause;
    private Alert alert;
    private AlertState severity;
    private long timestamp;
    private AgentInfo ai;

    public AlertNotification(String origin, Enum group, Enum type, String cause, Alert alert, AlertState severity, long timestamp) {
        this.origin = origin;
        this.cause = cause;
        this.alert = alert;
        this.severity = severity;
        this.group = group;
        this.type = type;
        this.timestamp = timestamp;
        this.ai = null;
    }

    public AlertNotification(AgentInfo ai, Enum group, Enum type, String cause, Alert alert, AlertState severity, long timestamp) {
        this(ai.getName(), group, type, cause, alert, severity, timestamp);
        this.ai = ai;
    }

    public String toString() {
        return "alert[" + this.severity + "] from " + this.origin + " id " + this.alert.getAlertId() + " (" + this.alert.getDescription() + "): " + this.cause;
    }

    public String getOrigin() {
        return this.origin;
    }

    public String getCause() {
        return this.cause;
    }

    public Alert getAlert() {
        return this.alert;
    }

    public AlertState getSeverity() {
        return this.severity;
    }

    public Enum getSubsystemGroup() {
        return this.group;
    }

    public Enum getSubsystemType() {
        return this.type;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public AgentInfo getAgentInfo() {
        return this.ai;
    }
}

