/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.definition.Bus;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.messaging.util.Dispatcher;
import org.lsst.ccs.utilities.scheduler.BasicThreadFactory;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public abstract class AbstractDispatcher
implements Dispatcher {
    private final Logger LOGGER = Logger.getLogger(this.getClass().getName());
    protected HashMap<String, String> config;
    protected final ScheduledExecutorService serviceExec;
    private final CopyOnWriteArrayList<Dispatcher.Listener> listeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<Dispatcher.TaskListener> taskListeners = new CopyOnWriteArrayList();
    protected final Map<String, Alert> alerts = Collections.synchronizedMap(new HashMap());

    protected AbstractDispatcher(String args) {
        this.config = new HashMap();
        if (args != null && !args.isEmpty()) {
            for (String arg : args.split("\\&")) {
                String key;
                String[] ss = arg.split("=");
                if (ss.length >= 3 || (key = ss[0].trim()).isEmpty()) continue;
                String value = ss.length == 2 ? ss[1].trim() : "";
                this.config.put(key, value);
            }
        }
        this.serviceExec = Executors.newScheduledThreadPool(1, (ThreadFactory)new BasicThreadFactory("Dispatcher Service", null, true));
    }

    @Override
    public void initialize() {
    }

    @Override
    public void shutdown() {
        try {
            this.serviceExec.shutdown();
            this.serviceExec.awaitTermination(10L, TimeUnit.MINUTES);
        }
        catch (InterruptedException | SecurityException exception) {
            // empty catch block
        }
    }

    @Override
    public final Dispatcher.Task in(BusMessage busMessage, long referenceTime, Runnable task, Bus bus, String ... agents) {
        DTask t = new DTask(task, busMessage, bus, false, referenceTime);
        this.in(t, bus, agents);
        return t;
    }

    @Override
    public final Dispatcher.Task out(BusMessage busMessage, long referenceTime, Runnable task, Bus bus, Dispatcher.Order order) {
        DTask t = new DTask(task, busMessage, bus, true, referenceTime);
        this.out(t, bus, order);
        return t;
    }

    protected abstract void in(DTask var1, Bus var2, String ... var3);

    protected abstract void out(DTask var1, Bus var2, Dispatcher.Order var3);

    @Override
    public void addListener(Dispatcher.Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(Dispatcher.Listener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void fireEvent(Dispatcher.Event event) {
        try {
            this.serviceExec.execute(() -> this.deliverEvent(event));
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    protected void deliverEvent(Dispatcher.Event event) {
        this.listeners.forEach(listener -> {
            try {
                listener.onEvent(event);
            }
            catch (RuntimeException x) {
                this.getLogger().log(Level.WARNING, "Error notifying " + listener + " of " + event.getClass().getSimpleName() + " event.", x);
            }
        });
    }

    @Override
    public void addTaskListener(Dispatcher.TaskListener listener) {
        this.taskListeners.add(listener);
    }

    @Override
    public void removeTaskListener(Dispatcher.TaskListener listener) {
        this.taskListeners.remove(listener);
    }

    @Override
    public void removeAllTaskListeners() {
        this.taskListeners.clear();
    }

    protected int notifyTaskListeners(DTask task, Dispatcher.Stage stage) {
        int duration = task.stageEnded(stage);
        this.taskListeners.forEach(listener -> {
            try {
                listener.stageEnded(task, stage);
            }
            catch (RuntimeException x) {
                this.LOGGER.log(Level.WARNING, "Error while calling dispatcher task listener.", x);
            }
        });
        return duration;
    }

    @Override
    public void raiseAlert(String id, AlertState severity, String cause) {
        try {
            this.serviceExec.execute(() -> {
                Alert alert = this.alerts.get(id);
                if (alert == null) {
                    return;
                }
                Dispatcher.AlertEvent event = new Dispatcher.AlertEvent(this, alert, severity, cause);
                this.deliverEvent(event);
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @Override
    public void raiseAlert(Alert alert, AlertState severity, String cause) {
        try {
            this.serviceExec.execute(() -> {
                Dispatcher.AlertEvent event = new Dispatcher.AlertEvent(this, alert, severity, cause);
                this.deliverEvent(event);
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @Override
    public List<Alert> getRegisteredAlerts() {
        return new ArrayList<Alert>(this.alerts.values());
    }

    @Override
    public void registerAlert(Alert alert) {
        this.alerts.put(alert.getAlertId(), alert);
    }

    @Override
    public Logger getLogger() {
        return this.LOGGER;
    }

    protected final int getIntArg(String key, int defaultValue) {
        try {
            String s = this.config.get(key);
            return s == null ? defaultValue : Integer.parseInt(s);
        }
        catch (NumberFormatException x) {
            throw new IllegalArgumentException("Illegal value for " + key, x);
        }
    }

    protected final boolean getBooleanArg(String key) {
        return this.config.containsKey(key);
    }

    protected final int[] getIntArrayArg(String key, int defaultValue, int length) {
        try {
            int[] out = new int[length];
            String s = this.config.get(key);
            if (s == null) {
                Arrays.fill(out, defaultValue);
            } else {
                String[] ss = s.split(",");
                if (ss.length != length) {
                    throw new IllegalArgumentException("Illegal value for " + key);
                }
                for (int i = 0; i < length; ++i) {
                    out[i] = Integer.parseInt(ss[i].trim());
                }
            }
            return out;
        }
        catch (NumberFormatException x) {
            throw new IllegalArgumentException("Illegal value for " + key, x);
        }
    }

    protected final int[] getIntArrayArg(String key, int[] defaultValue) {
        try {
            String s = this.config.get(key);
            if (s == null) {
                return defaultValue;
            }
            String[] ss = s.split(",");
            int length = ss.length;
            if (defaultValue.length != 0 && length != defaultValue.length) {
                throw new IllegalArgumentException("Illegal value for " + key);
            }
            int[] out = new int[length];
            for (int i = 0; i < length; ++i) {
                out[i] = Integer.parseInt(ss[i].trim());
            }
            return out;
        }
        catch (NumberFormatException x) {
            throw new IllegalArgumentException("Illegal value for " + key, x);
        }
    }

    protected static class DTask
    implements Dispatcher.Task,
    Runnable {
        protected final Runnable run;
        protected final BusMessage busMessage;
        protected final Bus bus;
        protected final boolean out;
        protected final long refTime;
        protected final EnumMap<Dispatcher.Stage, Integer> times = new EnumMap(Dispatcher.Stage.class);

        private DTask(Runnable run, BusMessage busMessage, Bus bus, boolean outgoing, long referenceTime) {
            this.run = run;
            this.busMessage = busMessage;
            this.bus = bus;
            this.out = outgoing;
            this.refTime = referenceTime > 0L ? referenceTime : System.currentTimeMillis();
        }

        @Override
        public BusMessage getBusMessage() {
            return this.busMessage;
        }

        @Override
        public Bus getBus() {
            return this.bus;
        }

        @Override
        public boolean isOutgoing() {
            return this.out;
        }

        @Override
        public long getRefTime() {
            return this.refTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getDuration(Dispatcher.Stage stage) {
            EnumMap<Dispatcher.Stage, Integer> enumMap = this.times;
            synchronized (enumMap) {
                Integer time = this.times.get((Object)stage);
                try {
                    switch (stage) {
                        case START: {
                            return time;
                        }
                        case WAIT: {
                            return time - this.times.get((Object)Dispatcher.Stage.START);
                        }
                        case RUN: {
                            return time - this.times.get((Object)Dispatcher.Stage.WAIT);
                        }
                        case SUBMIT: {
                            return time - this.times.get((Object)Dispatcher.Stage.START);
                        }
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getDuration() {
            int max = 0;
            try {
                EnumMap<Dispatcher.Stage, Integer> enumMap = this.times;
                synchronized (enumMap) {
                    for (Dispatcher.Stage stage : Dispatcher.Stage.values()) {
                        max = Math.max(max, this.times.get((Object)stage));
                    }
                }
                return max;
            }
            catch (NullPointerException x) {
                return -1;
            }
        }

        @Override
        public Runnable getPayload() {
            return this.run;
        }

        @Override
        public void run() {
            this.run.run();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int stageEnded(Dispatcher.Stage stage) {
            int time = (int)(System.currentTimeMillis() - this.refTime);
            EnumMap<Dispatcher.Stage, Integer> enumMap = this.times;
            synchronized (enumMap) {
                this.times.put(stage, time);
            }
            switch (stage) {
                case START: {
                    if (this.busMessage == null) break;
                    if (this.out) {
                        this.busMessage.setOutgoingQueueInTimeStamp(CCSTimeStamp.currentTime());
                        break;
                    }
                    this.busMessage.setIncomingQueueInTimeStamp(CCSTimeStamp.currentTime());
                    break;
                }
                case WAIT: {
                    if (this.busMessage == null) break;
                    if (this.out) {
                        this.busMessage.setOutgoingQueueOutTimeStamp(CCSTimeStamp.currentTime());
                        break;
                    }
                    this.busMessage.setIncomingQueueOutTimeStamp(CCSTimeStamp.currentTime());
                }
            }
            return this.getDuration(stage);
        }
    }
}

