/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.mmm;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.Persist;
import org.lsst.ccs.subsystem.mmm.AlertDispatcher;
import org.lsst.ccs.subsystem.mmm.AlertNotification;

public class SquadcastAlertAction
extends AlertDispatcher.AlertAction {
    @ConfigurationParameter(isFinal=true)
    public volatile String payloadUrl = "";
    @Persist
    public final List<String> triggeredIncidents = new CopyOnWriteArrayList<String>();
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    private String cluster;
    private URL url;

    public void init() {
        super.init();
        try {
            this.url = new URL(this.payloadUrl);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize Squadcast AlertAction", e);
        }
        this.cluster = this.agent.getAgentInfo().getAgentProperty("cluster");
        if (this.cluster == null || "".equals(this.cluster)) {
            this.cluster = "ir2";
        }
    }

    @Override
    public String getDescription() {
        return "Squadcast AlertAction";
    }

    @Override
    public void accept(AlertNotification notif) {
        SquadcastIncident incident = new SquadcastIncident(notif);
        boolean postIncident = false;
        switch (notif.getSeverity()) {
            case ALARM: {
                this.triggeredIncidents.add(incident.alertId);
                postIncident = true;
                break;
            }
            case NOMINAL: {
                postIncident = this.triggeredIncidents.remove(incident.alertId);
            }
        }
        if (postIncident) {
            try {
                StringBuilder content;
                HttpURLConnection con = (HttpURLConnection)this.url.openConnection();
                con.setRequestMethod("POST");
                con.setRequestProperty("Content-Type", "application/json");
                con.setRequestProperty("Accept", "application/json");
                con.setDoOutput(true);
                try (OutputStream os = con.getOutputStream();){
                    ObjectMapper mapper = new ObjectMapper();
                    byte[] input = mapper.writeValueAsString((Object)incident).getBytes("utf-8");
                    os.write(input, 0, input.length);
                }
                catch (JsonProcessingException jpe) {
                    this.getLogger().log(Level.SEVERE, "Failed to post incident to squadcast", (Throwable)jpe);
                    jpe.printStackTrace();
                }
                try (BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream()));){
                    String line;
                    content = new StringBuilder();
                    while ((line = br.readLine()) != null) {
                        content.append(line);
                        content.append(System.lineSeparator());
                    }
                }
                this.getLogger().log(Level.FINE, "Got response from squadcast", (Object)content.toString());
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to create connection to squadcast", (Throwable)e);
            }
        }
    }

    class SquadcastIncident {
        @JsonProperty(value="event_id")
        public final String alertId;
        public final String message;
        public final String description;
        public final String status;
        public final Map<String, Object> tags = new LinkedHashMap<String, Object>();

        SquadcastIncident(AlertNotification notif) {
            this.alertId = notif.getOrigin() + "/" + notif.getAlert().getAlertId();
            this.message = notif.getCause();
            this.description = notif.getAlert().getDescription();
            this.status = notif.getSeverity() == AlertState.NOMINAL ? "resolve" : "trigger";
            this.tags.put("alertId", this.alertId);
            this.tags.put("severity", new SeverityWithColor(notif.getSeverity()));
            this.tags.put("group", notif.getSubsystemGroup().name());
            this.tags.put("cluster", SquadcastAlertAction.this.cluster);
        }
    }

    static class SeverityWithColor {
        public final String value;
        public final String color;

        SeverityWithColor(AlertState state) {
            this.value = state.name();
            switch (state) {
                case ALARM: {
                    this.color = "#FD1802";
                    break;
                }
                case WARNING: {
                    this.color = "#FDE602";
                    break;
                }
                case NOMINAL: {
                    this.color = "#2FD116";
                    break;
                }
                default: {
                    this.color = "";
                }
            }
        }
    }
}

