import org.lsst.ccs.description.groovy.CCSBuilder;
import org.lsst.ccs.subsystem.mmm.MMM_IR2;
import org.lsst.ccs.subsystem.mmm.MinionIR2;
import org.lsst.ccs.subsystem.mmm.MinionIR2Group;
import org.lsst.ccs.subsystem.mmm.AlertDispatcher.AlertHandler;
import org.lsst.ccs.subsystem.mmm.AlertDispatcher.AlertAction;
import org.lsst.ccs.subsystem.mmm.AlertDispatcher.EmailAlertAction;
import org.lsst.ccs.subsystem.mmm.AlertDispatcher.EmailAlertDeliveryStrategy;
import org.lsst.ccs.subsystem.mmm.AlertDispatcher.CommandAlertAction;
import org.lsst.ccs.subsystem.mmm.AlertDispatcher;
import org.lsst.ccs.subsystem.mmm.AlertNotification;
import org.lsst.ccs.subsystem.rafts.alerts.RaftAlert;
import org.lsst.ccs.bus.states.AlertState;
import java.util.function.Predicate;
import java.time.Duration;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;

CCSBuilder builder = ["mmm-ir2"]

Properties props = BootstrapResourceUtils.getBootstrapSystemProperties()
def isSimulated = props.getProperty("org.lsst.ccs.run.mode", "normal").equals("simulation")


def fromEmail = isSimulated ? "SIMULATED-ccs-alarm@lsst-mmm.slac.stanford.edu" : "ccs-alarm@lsst-mmm.slac.stanford.edu"
def replyToEmail = isSimulated ? "SIMULATED-lsstcam-opsprob@slac.stanford.edu" : "lsstcam-opsprob@slac.stanford.edu";

def infrastructureList = ["turri@slac.stanford.edu"];


def environmentList = isSimulated ? infrastructureList : ["tether@slac.stanford.edu","marshall@slac.stanford.edu","youtsumi@slac.stanford.edu"];
def cryostatList = isSimulated ? infrastructureList : ["turri@slac.stanford.edu","qiu@SLAC.Stanford.EDU","marshall@slac.stanford.edu","youtsumi@slac.stanford.edu"];
def ts71List = isSimulated ? infrastructureList : ["turri@slac.stanford.edu","tonyj@slac.stanford.edu","marshall@slac.stanford.edu","youtsumi@slac.stanford.edu"];
def ts72List = isSimulated ? infrastructureList : ["turri@slac.stanford.edu","tonyj@slac.stanford.edu","marshall@slac.stanford.edu","homer@SLAC.Stanford.EDU","herrmann@slac.stanford.edu","youtsumi@slac.stanford.edu"];
def cameraList = isSimulated ? infrastructureList : ["turri@slac.stanford.edu","tonyj@slac.stanford.edu","marshall@slac.stanford.edu","youtsumi@SLAC.STANFORD.EDU","homer@slac.stanford.edu","bowdish@slac.stanford.edu"];
//Global selectors
def alarmSelector = {notification -> return notification.getSeverity() == AlertState.ALARM } as Predicate<AlertNotification>
def warningSelector = {notification -> return notification.getSeverity() == AlertState.WARNING } as Predicate<AlertNotification>



//Raft selectors
def raftOriginSelector = { n -> return n.getSubsystemType().equals(MinionIR2.RAFT) } as Predicate<AlertNotification>
def rebConnectionAlertSelector = { n -> return n.getAlert().getAlertId() ==  RaftAlert.REB_NOT_CONNECTED.getAlertId() } as Predicate<AlertNotification>
def rebConnectionActionSelector = raftOriginSelector.and(rebConnectionAlertSelector);


//Dummy AlertAction to print something
class PrintWhatToDo extends AlertAction {
    def msg;
    PrintWhatToDo(String msg) {
        this.msg = msg;
    }
        
    def void accept(AlertNotification notif) {
        System.out.println(notif.getSeverity().toString()+" "+msg);
    }        

    def String getDescription() {
        return "Prints to standard output: "+msg;
    }        
}


builder.
    main(MMM_IR2, 
        minions:[(MinionIR2Group.INFRASTRUCTURE):["jython-server":MinionIR2.JYTHONCONSOLE,"py4j-server":MinionIR2.PY4J_SERVER, "localdb":MinionIR2.LOCALBD, "rest-server":MinionIR2.REST_SERVER, "mmm-ir2":MinionIR2.MMM, "cluster-monitor":MinionIR2.CLUSTER_MONITOR],
                 (MinionIR2Group.IR2_ENVIRONMENT) :["ir2-airwatch":MinionIR2.AIRWATCH,"ccs-doorman":MinionIR2.DOORMAN],
                 (MinionIR2Group.ALIVENESS_TEST) :["aliveness-rebpower":MinionIR2.POWER, "aliveness-raft":MinionIR2.RAFT],
                 (MinionIR2Group.TS71G) :["ts7-1":MinionIR2.TS7, "ts7-rebpower":MinionIR2.POWER, "ts8-fp":MinionIR2.RAFT],
                 (MinionIR2Group.TS72G) :["ts7-2":MinionIR2.TS7, "ts7-2-rebpower":MinionIR2.POWER, "ts7-2-raft":MinionIR2.RAFT],
                 (MinionIR2Group.TEST_STAND_8) :["ts8-bench":MinionIR2.TS8_BENCH],
                 (MinionIR2Group.CRYOSTAT) :["pump-plate":MinionIR2.PUMP_PLATE],
                 (MinionIR2Group.CAMERA) :["vacuum":MinionIR2.VACUUM, "quadbox":MinionIR2.QUADBOX, "refrig":MinionIR2.REFRIG,
                    "focal-plane":MinionIR2.FOCAL_PLANE, "rebpower":MinionIR2.POWER, "ccob":MinionIR2.CCOB, "bot-motorplatform":MinionIR2.BOT_MOTOR,  
                    "bot-bench":MinionIR2.BOT_BENCH, "thermal":MinionIR2.THERMAL, "pap-pdu":MinionIR2.PUMPANDPURGE, "mpm":MinionIR2.MASTER_PROTECTION_MODULE,
                    "daq-monitor":MinionIR2.DAQ_MONITOR,
                    "image-handling-dc01":MinionIR2.IMAGE_HANDLER1,"image-handling-dc03":MinionIR2.IMAGE_HANDLER3,"image-handling-dc04":MinionIR2.IMAGE_HANDLER4,
                    "image-handling-dc05":MinionIR2.IMAGE_HANDLER5,"image-handling-dc06":MinionIR2.IMAGE_HANDLER6,"image-handling-dc07":MinionIR2.IMAGE_HANDLER7,
                    "image-handling-dc08":MinionIR2.IMAGE_HANDLER8,"image-handling-dc09":MinionIR2.IMAGE_HANDLER9,"image-handling-dc10":MinionIR2.IMAGE_HANDLER10],
                 (MinionIR2Group.METROLOGY) :["metrology":MinionIR2.METROLOGY, "ts7-2":MinionIR2.TS7]] ) {

    infrastructure (AlertDispatcher, group: MinionIR2Group.INFRASTRUCTURE) {
        infrastructureEmailNotification (AlertHandler, handlerName: "infrastructureEmailNotification") {
            infrastructurePublicMailAction (EmailAlertAction, emailList: infrastructureList, fromEmail:"$fromEmail", replyToEmail:"$replyToEmail") {
                localDbEmailStrategy (EmailAlertDeliveryStrategy, sendFirstEmail: false, origin:"localdb", maxAccumulation: Duration.ofMinutes(30))
                defaultEmailStrategy (EmailAlertDeliveryStrategy, sendFirstEmail: true, origin:".*", maxAccumulation: Duration.ofMinutes(0))
            }
        }        
    }
    
    environment (AlertDispatcher, group: MinionIR2Group.IR2_ENVIRONMENT) {
        environmentEmailNotification (AlertHandler, handlerName: "environmentEmailNotification") {
             environmentPublicMailAction (EmailAlertAction, emailList: environmentList, fromEmail:"$fromEmail", replyToEmail:"$replyToEmail")
        }        
    }

    ts71gTest (AlertDispatcher, group: MinionIR2Group.TS71G) {
        ts71gEmailNotification (AlertHandler, handlerName: "ts71gEmailNotification") {
            publicMailAction (EmailAlertAction, emailList: ts71List, fromEmail:"$fromEmail", replyToEmail:"$replyToEmail", filePath:"/etc/ccs/emails.list")
        }
    }
    
    ts72gTest (AlertDispatcher, group: MinionIR2Group.TS72G) {
        ts72gEmailNotificationTs2 (AlertHandler, handlerName: "ts72gEmailNotification") {
            publicMailActionTs2 (EmailAlertAction, emailList: ts72List, fromEmail:"$fromEmail", replyToEmail:"$replyToEmail", filePath:"/etc/ccs/emails.list")
        }
    }

    cryostat (AlertDispatcher, group: MinionIR2Group.CRYOSTAT) {
        cryostatEmailNotification (AlertHandler, handlerName: "cryostatEmailNotification") {
             cryostatPublicMailAction (EmailAlertAction, emailList: cryostatList, fromEmail:"$fromEmail", replyToEmail:"$replyToEmail")
        }        
    }

    camera (AlertDispatcher, group: MinionIR2Group.CAMERA) {
        cameraEmailNotification (AlertHandler, handlerName: "cameraEmailNotification") {
             cameraPublicMailAction (EmailAlertAction, emailList: cameraList, fromEmail:"$fromEmail", replyToEmail:"$replyToEmail", filePath:"/etc/ccs/camera-emails.list") {
                focalPlaneEmailStrategy (EmailAlertDeliveryStrategy, sendFirstEmail: true, origin:"focal-plane", maxAccumulation: Duration.ofMinutes(10))
                defaultEmailStrategy (EmailAlertDeliveryStrategy, sendFirstEmail: true, origin:".*", maxAccumulation: Duration.ofMinutes(0))                 
             }
        }        
    }
}
