/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.bridge;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import org.astrogrid.samp.Client;
import org.astrogrid.samp.ErrInfo;
import org.astrogrid.samp.Message;
import org.astrogrid.samp.Metadata;
import org.astrogrid.samp.RegInfo;
import org.astrogrid.samp.Response;
import org.astrogrid.samp.Subscriptions;
import org.astrogrid.samp.bridge.IconAdjuster;
import org.astrogrid.samp.bridge.UrlExporter;
import org.astrogrid.samp.client.CallableClient;
import org.astrogrid.samp.client.ClientProfile;
import org.astrogrid.samp.client.HubConnection;
import org.astrogrid.samp.client.HubConnector;
import org.astrogrid.samp.client.SampException;
import org.astrogrid.samp.client.TrackedClientSet;
import org.astrogrid.samp.httpd.UtilServer;

class ProxyManager {
    private final ClientProfile localProfile_;
    private final UtilServer server_;
    private final HubConnector pmConnector_;
    private final Map connectionMap_;
    private final Map tagMap_;
    private final IconAdjuster iconAdjuster_;
    private ProxyManager[] remoteManagers_;
    private UrlExporter exporter_;
    private boolean useProxyHub_;
    private int nRemote_;
    private static final Logger logger_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ProxyManager(ClientProfile localProfile, UtilServer server) {
        this.localProfile_ = localProfile;
        this.server_ = server;
        this.pmConnector_ = new HubConnector(localProfile, new ProxyManagerClientSet()){

            protected void connectionChanged(boolean isConnected) {
                super.connectionChanged(isConnected);
                ProxyManager.this.managerConnectionChanged(isConnected);
            }
        };
        Metadata meta = new Metadata();
        meta.setName("bridge");
        meta.setDescriptionText("Bridge between hubs");
        try {
            meta.setIconUrl(this.server_.exportResource("/org/astrogrid/samp/images/bridge.png").toString());
        }
        catch (IOException e) {
            logger_.warning("Couldn't set icon");
        }
        meta.put("author.name", "Mark Taylor");
        meta.put("author.email", "m.b.taylor@bristol.ac.uk");
        this.pmConnector_.declareMetadata(meta);
        Subscriptions subs = this.pmConnector_.computeSubscriptions();
        this.pmConnector_.declareSubscriptions(subs);
        this.connectionMap_ = Collections.synchronizedMap(new HashMap());
        this.tagMap_ = Collections.synchronizedMap(new HashMap());
        this.iconAdjuster_ = new ProxyIconAdjuster();
        this.server_.getServer().addHandler(this.iconAdjuster_);
    }

    public ClientProfile getProfile() {
        return this.localProfile_;
    }

    public HubConnector getManagerConnector() {
        return this.pmConnector_;
    }

    public void setExporter(UrlExporter exporter) {
        this.exporter_ = exporter;
    }

    public void setUseProxyHub(boolean useProxyHub) {
        this.useProxyHub_ = useProxyHub;
    }

    public void init(ProxyManager[] allManagers) {
        ArrayList<ProxyManager> remoteList = new ArrayList<ProxyManager>();
        int selfCount = 0;
        for (int im = 0; im < allManagers.length; ++im) {
            ProxyManager pm = allManagers[im];
            if (pm == this) {
                ++selfCount;
                continue;
            }
            remoteList.add(pm);
        }
        if (selfCount != 1) {
            throw new IllegalArgumentException("Self not in list once");
        }
        this.remoteManagers_ = remoteList.toArray(new ProxyManager[0]);
        this.nRemote_ = this.remoteManagers_.length;
        if (!$assertionsDisabled && this.nRemote_ != allManagers.length - 1) {
            throw new AssertionError();
        }
    }

    public String toString() {
        return this.localProfile_.toString();
    }

    private HubConnection getProxyConnection(ProxyManager remoteManager, String localClientId) {
        HubConnection[] proxyConnections = (HubConnection[])this.connectionMap_.get(localClientId);
        return proxyConnections == null ? null : proxyConnections[this.getManagerIndex(remoteManager)];
    }

    private void removeProxyConnection(ProxyManager remoteManager, String localClientId) {
        HubConnection[] proxyConnections = (HubConnection[])this.connectionMap_.get(localClientId);
        if (proxyConnections != null) {
            proxyConnections[this.getManagerIndex((ProxyManager)remoteManager)] = null;
        }
    }

    private int getManagerIndex(ProxyManager remoteManager) {
        return Arrays.asList(this.remoteManagers_).indexOf(remoteManager);
    }

    private Metadata getProxyMetadata(Client localClient) {
        Metadata meta = localClient.getMetadata();
        if (meta == null) {
            return null;
        }
        meta = new Metadata(meta);
        if (this.exporter_ != null) {
            this.exporter_.exportMap(meta);
        }
        meta.setName(this.proxyName(meta.getName()));
        if (meta.getIconUrl() != null) {
            URL iconUrl = this.proxyIconUrl(meta.getIconUrl());
            meta.setIconUrl(iconUrl == null ? null : iconUrl.toString());
        }
        meta.put("bridge.proxy.source", this.toString());
        return meta;
    }

    private String proxyName(String localName) {
        return localName == null ? "(proxy)" : localName + " (proxy)";
    }

    private URL proxyIconUrl(URL localIconUrl) {
        return localIconUrl != null ? this.iconAdjuster_.exportAdjustedIcon(localIconUrl) : localIconUrl;
    }

    private Subscriptions getProxySubscriptions(Client client) {
        Subscriptions subs = client.getSubscriptions();
        if (subs == null) {
            return null;
        }
        subs = new Subscriptions(subs);
        subs.remove("samp.hub.event.shutdown");
        subs.remove("samp.hub.event.register");
        subs.remove("samp.hub.event.unregister");
        subs.remove("samp.hub.event.metadata");
        subs.remove("samp.hub.event.subscriptions");
        if (this.exporter_ != null) {
            this.exporter_.exportMap(subs);
        }
        return subs;
    }

    protected void managerConnectionChanged(boolean isConnected) {
        if (!isConnected) {
            for (int ir = 0; ir < this.nRemote_; ++ir) {
                ProxyManager remoteManager = this.remoteManagers_[ir];
                int im = remoteManager.getManagerIndex(this);
                Iterator it = remoteManager.connectionMap_.values().iterator();
                while (it.hasNext()) {
                    HubConnection connection;
                    HubConnection[] connections = (HubConnection[])it.next();
                    if (connections == null || (connection = connections[im]) == null) continue;
                    connections[im] = null;
                    try {
                        connection.unregister();
                    }
                    catch (SampException e) {
                        logger_.info("Unregister failed");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void localClientAdded(Client client) {
        if (!this.isProxiedClient(client)) {
            return;
        }
        Metadata meta = this.getProxyMetadata(client);
        Subscriptions subs = this.getProxySubscriptions(client);
        HubConnection[] proxyConnections = new HubConnection[this.nRemote_];
        this.connectionMap_.put(client.getId(), proxyConnections);
        for (int ir = 0; ir < this.nRemote_; ++ir) {
            ProxyManager remoteManager = this.remoteManagers_[ir];
            try {
                HubConnection proxyConnection;
                Map map = this.connectionMap_;
                synchronized (map) {
                    proxyConnection = remoteManager.getProfile().register();
                    if (proxyConnection != null) {
                        ProxyCallableClient callable = new ProxyCallableClient(client, proxyConnection, remoteManager);
                        proxyConnection.setCallable(callable);
                        proxyConnections[ir] = proxyConnection;
                    }
                }
                if (proxyConnection == null) continue;
                if (meta != null) {
                    try {
                        proxyConnection.declareMetadata(meta);
                    }
                    catch (SampException e) {
                        logger_.warning("proxy declareMetadata failed for " + client);
                    }
                }
                if (subs == null) continue;
                try {
                    proxyConnection.declareSubscriptions(subs);
                }
                catch (SampException e) {
                    logger_.warning("proxy declareSubscriptions failed for " + client);
                }
                continue;
            }
            catch (SampException e) {
                logger_.warning("proxy registration failed for " + client);
            }
        }
    }

    private void localClientRemoved(Client client) {
        if (!this.isProxiedClient(client)) {
            return;
        }
        HubConnection[] proxyConnections = (HubConnection[])this.connectionMap_.remove(client.getId());
        if (proxyConnections != null) {
            for (int ir = 0; ir < this.nRemote_; ++ir) {
                HubConnection connection = proxyConnections[ir];
                if (connection == null) continue;
                try {
                    connection.unregister();
                    continue;
                }
                catch (SampException e) {
                    logger_.warning("proxy unregister failed for " + client);
                }
            }
        }
    }

    private void localClientUpdated(Client client, boolean metaChanged, boolean subsChanged) {
        Subscriptions subs;
        if (!this.isProxiedClient(client)) {
            return;
        }
        HubConnection[] proxyConnections = (HubConnection[])this.connectionMap_.get(client.getId());
        Metadata meta = metaChanged ? this.getProxyMetadata(client) : null;
        Subscriptions subscriptions = subs = subsChanged ? this.getProxySubscriptions(client) : null;
        if (proxyConnections != null) {
            for (int ir = 0; ir < this.nRemote_; ++ir) {
                HubConnection connection = proxyConnections[ir];
                if (connection == null) continue;
                if (meta != null) {
                    try {
                        connection.declareMetadata(meta);
                    }
                    catch (SampException e) {
                        logger_.warning("proxy declareMetadata failed for " + client);
                    }
                }
                if (subs == null) continue;
                try {
                    connection.declareSubscriptions(subs);
                    continue;
                }
                catch (SampException e) {
                    logger_.warning("proxy declareSubscriptions failed for " + client);
                }
            }
        }
    }

    private boolean isProxiedClient(Client client) {
        try {
            RegInfo regInfo;
            String clientId;
            HubConnection connection;
            if (this.pmConnector_.isConnected() && (connection = this.pmConnector_.getConnection()) != null && ((clientId = client.getId()).equals((regInfo = connection.getRegInfo()).getSelfId()) || !this.useProxyHub_ && clientId.equals(regInfo.getHubId()))) {
                return false;
            }
        }
        catch (SampException e) {
            // empty catch block
        }
        for (int ir = 0; ir < this.nRemote_; ++ir) {
            if (!this.remoteManagers_[ir].isProxy(client, this)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isProxy(Client client, ProxyManager remoteManager) {
        int ir = this.getManagerIndex(remoteManager);
        Map map = this.connectionMap_;
        synchronized (map) {
            Iterator it = this.connectionMap_.values().iterator();
            while (it.hasNext()) {
                RegInfo proxyReg;
                HubConnection proxyConnection;
                HubConnection[] proxyConnections = (HubConnection[])it.next();
                if (proxyConnections == null || (proxyConnection = proxyConnections[ir]) == null || !(proxyReg = proxyConnection.getRegInfo()).getSelfId().equals(client.getId())) continue;
                return true;
            }
        }
        return false;
    }

    static {
        $assertionsDisabled = !ProxyManager.class.desiredAssertionStatus();
        logger_ = Logger.getLogger(ProxyManager.class.getName());
    }

    private class ProxyIconAdjuster
    extends IconAdjuster {
        ProxyIconAdjuster() {
            super(ProxyManager.this.server_.getServer(), ProxyManager.this.server_.getBasePath("proxy-" + ProxyManager.this.localProfile_));
        }

        public RenderedImage adjustImage(BufferedImage inImage) {
            int w = inImage.getWidth();
            int h = inImage.getHeight();
            BufferedImage outImage = new BufferedImage(w, h, 6);
            Graphics2D g2 = outImage.createGraphics();
            g2.drawImage(inImage, null, 0, 0);
            int[] xs = new int[]{0, w, w};
            int[] ys = new int[]{h, h, 0};
            Composite compos = g2.getComposite();
            g2.setComposite(AlphaComposite.Clear);
            g2.fillPolygon(xs, ys, 3);
            g2.setComposite(compos);
            return outImage;
        }
    }

    private class ProxyManagerClientSet
    extends TrackedClientSet {
        private ProxyManagerClientSet() {
        }

        public void addClient(Client client) {
            super.addClient(client);
            ProxyManager.this.localClientAdded(client);
        }

        public void removeClient(Client client) {
            ProxyManager.this.localClientRemoved(client);
            super.removeClient(client);
        }

        public void updateClient(Client client, boolean metaChanged, boolean subsChanged) {
            super.updateClient(client, metaChanged, subsChanged);
            ProxyManager.this.localClientUpdated(client, metaChanged, subsChanged);
        }

        public void setClients(Client[] clients) {
            Iterator it = this.getClientMap().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Client client = (Client)entry.getValue();
                ProxyManager.this.localClientRemoved(client);
            }
            super.setClients(clients);
            for (int i = 0; i < clients.length; ++i) {
                Client client = clients[i];
                ProxyManager.this.localClientAdded(client);
            }
        }
    }

    private class ProxyCallableClient
    implements CallableClient {
        private final String localClientId_;
        private final HubConnection remoteProxy_;
        private final ProxyManager remoteManager_;
        private final ProxyManager localManager_;

        ProxyCallableClient(Client localClient, HubConnection remoteProxy, ProxyManager remoteManager) {
            this.localClientId_ = localClient.getId();
            this.remoteProxy_ = remoteProxy;
            this.remoteManager_ = remoteManager;
            this.localManager_ = ProxyManager.this;
        }

        public void receiveNotification(String remoteSenderId, Message msg) throws SampException {
            HubConnection localProxy;
            if (this.remoteManager_.exporter_ != null) {
                msg = new Message(msg);
                this.remoteManager_.exporter_.exportMap(msg);
            }
            if ((localProxy = this.getLocalProxy(remoteSenderId)) != null) {
                localProxy.notify(this.localClientId_, msg);
            }
            this.proxyProcessMessage(remoteSenderId, msg);
        }

        public void receiveCall(String remoteSenderId, String remoteMsgId, Message msg) throws SampException {
            HubConnection localProxy;
            String localMsgTag = remoteMsgId;
            if (this.remoteManager_.exporter_ != null) {
                msg = new Message(msg);
                this.remoteManager_.exporter_.exportMap(msg);
            }
            if ((localProxy = this.getLocalProxy(remoteSenderId)) != null) {
                localProxy.call(this.localClientId_, localMsgTag, msg);
            } else {
                ErrInfo errInfo = new ErrInfo();
                errInfo.setErrortxt("Bridge can't forward message");
                Client senderClient = (Client)this.remoteManager_.getManagerConnector().getClientMap().get(remoteSenderId);
                String usertxt = "Bridge can't forward message to recipient;\n" + "sender client " + senderClient + " has no proxy on remote hub";
                errInfo.setUsertxt(usertxt);
                new ErrInfo("Client " + remoteSenderId + " not present" + " on other side of bridge");
                this.remoteProxy_.reply(remoteMsgId, Response.createErrorResponse(errInfo));
            }
            this.proxyProcessMessage(remoteSenderId, msg);
        }

        public void receiveResponse(String remoteResponderId, String remoteMsgTag, Response response) throws SampException {
            HubConnection localProxy;
            String localMsgId = remoteMsgTag;
            if (this.remoteManager_.exporter_ != null) {
                response = new Response(response);
                this.remoteManager_.exporter_.exportMap(response);
            }
            if ((localProxy = this.getLocalProxy(remoteResponderId)) != null) {
                localProxy.reply(localMsgId, response);
            } else {
                logger_.warning("Bridge can't forward response:  missing proxy");
            }
        }

        private HubConnection getLocalProxy(String remoteClientId) {
            return this.remoteManager_.getProxyConnection(this.localManager_, remoteClientId);
        }

        private void proxyProcessMessage(String remoteSenderId, Message msg) {
            String mtype = msg.getMType();
            boolean fromHub = remoteSenderId.equals(this.remoteProxy_.getRegInfo().getHubId());
            if ("samp.hub.disconnect".equals(mtype)) {
                if (fromHub) {
                    ProxyManager.this.removeProxyConnection(this.remoteManager_, this.localClientId_);
                } else {
                    logger_.warning(mtype + " from non-hub client " + remoteSenderId + " - ignored");
                }
            }
        }
    }
}

