/*
 * Decompiled with CFR 0.152.
 */
package com.ifountain.opsgenie.client.model.beans;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.ifountain.opsgenie.client.model.beans.BeanWithId;
import com.ifountain.opsgenie.client.model.beans.Contact;
import com.ifountain.opsgenie.client.model.beans.UserRole;
import com.ifountain.opsgenie.client.util.JsonUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class User
extends BeanWithId {
    private static final Map<String, Locale> LOCALES = new HashMap<String, Locale>();
    private String username;
    private State state;
    private String fullname;
    private String skypeUsername;
    @JsonProperty(value="timezone")
    private TimeZone timeZone;
    private Locale locale;
    private UserRole role;
    private List<String> groups;
    private List<String> escalations;
    private List<String> schedules;
    private List<Contact> contacts;
    private Long createdAt;

    public static String getLocaleId(Locale locale) {
        return locale.toString();
    }

    public static Locale getLocale(String localeId) {
        return LOCALES.get(localeId);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public String getFullname() {
        return this.fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @JsonIgnore
    @Deprecated
    public Role getRole() {
        return this.role == null ? null : Role.fromName(this.role.getName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JsonIgnore
    @Deprecated
    public void setRole(Role role) {
        if (role != null) {
            if (role == Role.admin) {
                this.role = UserRole.ADMIN;
                return;
            } else if (role == Role.owner) {
                this.role = UserRole.OWNER;
                return;
            } else {
                if (role != Role.user) throw new UnsupportedOperationException("custom role does not supported by Role enum. Use setUserRole() for custom roles.");
                this.role = UserRole.USER;
            }
            return;
        } else {
            this.role = null;
        }
    }

    @JsonProperty(value="role")
    public UserRole getUserRole() {
        return this.role;
    }

    public void setUserRole(UserRole role) {
        this.role = role;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    public List<String> getEscalations() {
        return this.escalations;
    }

    public void setEscalations(List<String> escalations) {
        this.escalations = escalations;
    }

    public List<String> getSchedules() {
        return this.schedules;
    }

    public void setSchedules(List<String> schedules) {
        this.schedules = schedules;
    }

    @Deprecated
    @JsonIgnore
    public List<Map<String, String>> getContacts() {
        if (this.contacts == null) {
            return null;
        }
        ArrayList<Map<String, String>> contactMapList = new ArrayList<Map<String, String>>();
        for (Contact contact : this.contacts) {
            try {
                contactMapList.add(JsonUtils.toMap(contact));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return contactMapList;
    }

    @Deprecated
    public void setContacts(List<Map<String, String>> contacts) {
        if (contacts != null) {
            this.contacts = new ArrayList<Contact>();
            for (Map<String, String> map : contacts) {
                Contact contact = new Contact();
                try {
                    JsonUtils.fromMap(contact, map);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.contacts.add(contact);
            }
        } else {
            this.contacts = null;
        }
    }

    @JsonProperty(value="contacts")
    public List<Contact> getUserContacts() {
        return this.contacts;
    }

    public void setUserContacts(List<Contact> contacts) {
        this.contacts = contacts;
    }

    public String getSkypeUsername() {
        return this.skypeUsername;
    }

    public void setSkypeUsername(String skypeUsername) {
        this.skypeUsername = skypeUsername;
    }

    public User withUsername(String username) {
        this.username = username;
        return this;
    }

    public User withState(State state) {
        this.state = state;
        return this;
    }

    public User withFullname(String fullname) {
        this.fullname = fullname;
        return this;
    }

    public User withSkypeUsername(String skypeUsername) {
        this.skypeUsername = skypeUsername;
        return this;
    }

    public User withTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public User withLocale(Locale locale) {
        this.locale = locale;
        return this;
    }

    public User withRole(UserRole role) {
        this.role = role;
        return this;
    }

    public User withGroups(List<String> groups) {
        this.groups = groups;
        return this;
    }

    public User withEscalations(List<String> escalations) {
        this.escalations = escalations;
        return this;
    }

    public User withSchedules(List<String> schedules) {
        this.schedules = schedules;
        return this;
    }

    public User withContacts(List<Contact> contacts) {
        this.contacts = contacts;
        return this;
    }

    public Long getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Long createdAt) {
        this.createdAt = createdAt;
    }

    static {
        for (Locale locale : Locale.getAvailableLocales()) {
            LOCALES.put(User.getLocaleId(locale), locale);
        }
    }

    public static enum State {
        active,
        waitingverification,
        inactive;

    }

    @Deprecated
    public static enum Role {
        admin,
        owner,
        user,
        custom;


        @JsonCreator
        public static Role fromName(String name) {
            for (Role role : Role.values()) {
                if (!role.name().equalsIgnoreCase(name)) continue;
                return role;
            }
            return custom;
        }

        @JsonValue
        public String value() {
            return this.name();
        }
    }
}

