/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image.patterns;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Map;
import javax.imageio.ImageIO;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.utilities.image.patterns.GeneratedImage;
import org.lsst.ccs.utilities.image.patterns.PatternGenerator;

public class ImagePatternGenerator
extends PatternGenerator {
    ImagePatternGenerator() {
        super("image");
    }

    @Override
    public GeneratedImage generateImage(int width, int height, Map<String, String> parameters) {
        String image_url = this.getStringParameter("image_url", parameters, "/dots.jpg");
        String format = image_url.substring(image_url.lastIndexOf(".") + 1);
        try {
            int existingImageHeight;
            int existingImageWidth;
            GeneratedImage loadedGeneratedImage;
            InputStream in = BootstrapResourceUtils.getBootstrapResource((String)image_url);
            if (in == null) {
                in = new FileInputStream(image_url);
            }
            if (in == null) {
                throw new RuntimeException("Could not load image : " + image_url);
            }
            if (format.equals("ser")) {
                ObjectInputStream obj_in = new ObjectInputStream(in);
                try {
                    loadedGeneratedImage = (GeneratedImage)obj_in.readObject();
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                existingImageWidth = loadedGeneratedImage.getWidth();
                existingImageHeight = loadedGeneratedImage.getWidth();
            } else {
                BufferedImage existingImage = ImageIO.read(in);
                existingImageWidth = existingImage.getWidth();
                existingImageHeight = existingImage.getHeight();
                int[][] data = new int[existingImageWidth][existingImageHeight];
                double maxValue = 1.0;
                DataBuffer dataBuffer = existingImage.getData().getDataBuffer();
                if (dataBuffer instanceof DataBufferByte) {
                    DataBufferByte bytes = (DataBufferByte)dataBuffer;
                    for (int i = 0; i < existingImageWidth; ++i) {
                        for (int j = 0; j < existingImageHeight; ++j) {
                            data[i][j] = dataBuffer.getElem((j * existingImageHeight + i) * 3);
                            if (!((double)data[i][j] > maxValue)) continue;
                            maxValue = data[i][j];
                        }
                    }
                } else {
                    throw new RuntimeException("Cannot handle this data buffer " + dataBuffer);
                }
                loadedGeneratedImage = new GeneratedImage(data, maxValue);
            }
            int nx = width / existingImageWidth + 1;
            int ny = height / existingImageHeight + 1;
            int[][] newData = new int[width][height];
            for (int x = 0; x < width; ++x) {
                int normX = x % existingImageWidth;
                for (int y = 0; y < height; ++y) {
                    int normY = y % existingImageHeight;
                    newData[x][y] = loadedGeneratedImage.getPixelData(normX, normY);
                }
            }
            return new GeneratedImage(newData, loadedGeneratedImage.getMaxValue());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

