/*
 * Decompiled with CFR 0.152.
 */
package com.ifountain.opsgenie.client.model.user;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ifountain.opsgenie.client.OpsGenieClientValidationException;
import com.ifountain.opsgenie.client.model.BaseRequest;
import com.ifountain.opsgenie.client.model.beans.User;
import com.ifountain.opsgenie.client.model.beans.UserRole;
import com.ifountain.opsgenie.client.model.user.UpdateUserResponse;
import java.util.Locale;
import java.util.TimeZone;

public class UpdateUserRequest
extends BaseRequest<UpdateUserResponse, UpdateUserRequest> {
    private String id;
    private String fullname;
    private String skypeUsername;
    @JsonProperty(value="timezone")
    private TimeZone timeZone;
    private Locale locale;
    private UserRole role;

    @Override
    public String getEndPoint() {
        return "/v1/json/user";
    }

    public String getFullname() {
        return this.fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @JsonIgnore
    @Deprecated
    public User.Role getRole() {
        return this.role != null ? User.Role.fromName(this.role.getName()) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JsonIgnore
    @Deprecated
    public void setRole(User.Role role) {
        if (role != null) {
            if (role == User.Role.admin) {
                this.role = UserRole.ADMIN;
                return;
            } else if (role == User.Role.owner) {
                this.role = UserRole.OWNER;
                return;
            } else {
                if (role != User.Role.user) throw new UnsupportedOperationException("custom role does not supported by Role enum. Use setUserRole() for custom roles.");
                this.role = UserRole.USER;
            }
            return;
        } else {
            this.role = null;
        }
    }

    @JsonProperty(value="role")
    public UserRole getUserRole() {
        return this.role;
    }

    public void setUserRole(UserRole role) {
        this.role = role;
    }

    public String getSkypeUsername() {
        return this.skypeUsername;
    }

    public void setSkypeUsername(String skypeUsername) {
        this.skypeUsername = skypeUsername;
    }

    @Override
    public void validate() throws OpsGenieClientValidationException {
        super.validate();
        if (this.id == null) {
            throw OpsGenieClientValidationException.missingMandatoryProperty("id");
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public UpdateUserResponse createResponse() {
        return new UpdateUserResponse();
    }

    public UpdateUserRequest withId(String id) {
        this.id = id;
        return this;
    }

    public UpdateUserRequest withFullname(String fullname) {
        this.fullname = fullname;
        return this;
    }

    public UpdateUserRequest withSkypeUsername(String skypeUsername) {
        this.skypeUsername = skypeUsername;
        return this;
    }

    public UpdateUserRequest withTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public UpdateUserRequest withLocale(Locale locale) {
        this.locale = locale;
        return this;
    }

    public UpdateUserRequest withRole(UserRole role) {
        this.role = role;
        return this;
    }
}

