/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.auxelex;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.drivers.auxelex.Srp;
import org.lsst.ccs.drivers.commons.DriverException;

public class Ipc
extends Srp {
    public static final int CHAN_PUMP0 = 0;
    public static final int CHAN_PUMP1 = 1;
    public static final int CHAN_PUMP2 = 2;
    public static final int CHAN_PUMP3 = 3;
    public static final int CHAN_PUMP4 = 4;
    public static final int CHAN_PUMP5 = 5;
    public static final int CHAN_PUMP6 = 6;
    public static final int CHAN_PUMP7 = 7;
    public static final int CHAN_PUMP8 = 8;
    public static final int NUM_CHANNELS = 9;
    private static final Map<String, Integer> channelMap = new HashMap<String, Integer>();
    private static final String[] channelNames;
    private static final List<Srp.BoardType> VALID_TYPES;
    private static final int REG_DEVICE_BASE = 65536;
    private static final int REG_CONTROL = 65536;
    private static final int REG_IMODE_STATUS = 65537;
    private static final int REG_VMODE_STATUS = 65538;
    private static final int REG_PMODE_STATUS = 65539;
    private static final int CHAN_INCREMENT = 1024;
    private static final int REG_CHAN_BASE = 66560;
    private static final int OFF_DAC_CURRENT = 0;
    private static final int OFF_DAC_VOLTAGE = 1;
    private static final int OFF_DAC_POWER = 2;
    private static final int OFF_ADC_CURRENT = 128;
    private static final int OFF_ADC_VOLTAGE = 129;
    private static final int OFF_ADC_POWER = 130;
    private static final int DAC_FULL_SCALE = 65536;
    private static final int ADC_FULL_SCALE = 0x800000;
    private static final double DAC_ISCALE = 4096000.0;
    private static final double DAC_VSCALE = 10.922666666666666;
    private static final double DAC_PSCALE = 6553.6;
    private static final double ADC_ISCALE = 1.9073486328125E-9;
    private static final double ADC_VSCALE = 7.152557373046875E-4;
    private static final double ADC_PSCALE = 1.1920928955078125E-6;
    private final int[] voltDacs = new int[9];

    public Ipc() {
        this.setValidBoardTypes(VALID_TYPES);
    }

    public String[] getChannelNames() {
        return channelNames;
    }

    public void powerOn(int chan) throws DriverException {
        this.updateReg(65536, 1 << this.checkChannelNumber(chan), -1);
        this.setVoltageDAC(chan, this.voltDacs[chan]);
    }

    public void powerOn(String chan) throws DriverException {
        int chnum = this.getChannelNumber(chan);
        this.updateReg(65536, 1 << chnum, -1);
        this.setVoltageDAC(chnum, this.voltDacs[chnum]);
    }

    public void powerOff(int chan) throws DriverException {
        this.updateReg(65536, 1 << this.checkChannelNumber(chan), 0);
        this.setVoltageDAC(chan, 0);
    }

    public void powerOff(String chan) throws DriverException {
        int chnum = this.getChannelNumber(chan);
        this.updateReg(65536, 1 << chnum, 0);
        this.setVoltageDAC(chnum, 0);
    }

    public boolean isPowered(int chan) throws DriverException {
        return (this.readReg(65536) >> this.checkChannelNumber(chan) & 1) != 0;
    }

    public boolean isPowered(String chan) throws DriverException {
        return (this.readReg(65536) >> this.getChannelNumber(chan) & 1) != 0;
    }

    public int getPoweredStatus() throws DriverException {
        return this.readReg(65536);
    }

    public boolean isVoltageLimited(int chan) throws DriverException {
        return (this.readReg(65538) >> this.checkChannelNumber(chan) & 1) != 0;
    }

    public boolean isVoltageLimited(String chan) throws DriverException {
        return (this.readReg(65538) >> this.getChannelNumber(chan) & 1) != 0;
    }

    public int getVlimitStatus() throws DriverException {
        return this.readReg(65538);
    }

    public boolean isCurrentLimited(int chan) throws DriverException {
        return (this.readReg(65537) >> this.checkChannelNumber(chan) & 1) != 0;
    }

    public boolean isCurrentLimited(String chan) throws DriverException {
        return (this.readReg(65537) >> this.getChannelNumber(chan) & 1) != 0;
    }

    public int getIlimitStatus() throws DriverException {
        return this.readReg(65537);
    }

    public boolean isPowerLimited(int chan) throws DriverException {
        return (this.readReg(65539) >> this.checkChannelNumber(chan) & 1) != 0;
    }

    public boolean isPowerLimited(String chan) throws DriverException {
        return (this.readReg(65539) >> this.getChannelNumber(chan) & 1) != 0;
    }

    public int getPlimitStatus() throws DriverException {
        return this.readReg(65539);
    }

    public void setVoltage(int chan, double value) throws DriverException {
        this.voltDacs[this.checkChannelNumber((int)chan)] = Ipc.limitDacValue(value * 10.922666666666666);
        if (this.isPowered(chan)) {
            this.setVoltageDAC(chan, this.voltDacs[chan]);
        }
    }

    public void setVoltage(String chan, double value) throws DriverException {
        int chnum = this.getChannelNumber(chan);
        this.voltDacs[chnum] = Ipc.limitDacValue(value * 10.922666666666666);
        if (this.isPowered(chnum)) {
            this.setVoltageDAC(chnum, this.voltDacs[chnum]);
        }
    }

    private void setVoltageDAC(int chan, int value) throws DriverException {
        this.writeReg(66560 + 1024 * chan + 1, value);
    }

    public void setCurrent(int chan, double value) throws DriverException {
        this.writeReg(66560 + 1024 * this.checkChannelNumber(chan) + 0, Ipc.limitDacValue(value * 4096000.0));
    }

    public void setCurrent(String chan, double value) throws DriverException {
        this.writeReg(66560 + 1024 * this.getChannelNumber(chan) + 0, Ipc.limitDacValue(value * 4096000.0));
    }

    public void setPower(int chan, double value) throws DriverException {
        this.writeReg(66560 + 1024 * this.checkChannelNumber(chan) + 2, Ipc.limitDacValue(value * 6553.6));
    }

    public void setPower(String chan, double value) throws DriverException {
        this.writeReg(66560 + 1024 * this.getChannelNumber(chan) + 2, Ipc.limitDacValue(value * 6553.6));
    }

    public double readVoltage(int chan) throws DriverException {
        return (double)this.readReg(66560 + 1024 * this.checkChannelNumber(chan) + 129) * 7.152557373046875E-4;
    }

    public double readVoltage(String chan) throws DriverException {
        return (double)this.readReg(66560 + 1024 * this.getChannelNumber(chan) + 129) * 7.152557373046875E-4;
    }

    public double readCurrent(int chan) throws DriverException {
        return (double)this.readReg(66560 + 1024 * this.checkChannelNumber(chan) + 128) * 1.9073486328125E-9;
    }

    public double readCurrent(String chan) throws DriverException {
        return (double)this.readReg(66560 + 1024 * this.getChannelNumber(chan) + 128) * 1.9073486328125E-9;
    }

    public double readPower(int chan) throws DriverException {
        return (double)this.readReg(66560 + 1024 * this.checkChannelNumber(chan) + 130) * 1.1920928955078125E-6;
    }

    public double readPower(String chan) throws DriverException {
        return (double)this.readReg(66560 + 1024 * this.getChannelNumber(chan) + 130) * 1.1920928955078125E-6;
    }

    private int checkChannelNumber(int chan) throws DriverException {
        if (chan < 0 || chan >= 9) {
            throw new DriverException("Invalid channel number: " + chan);
        }
        return chan;
    }

    private int getChannelNumber(String chan) throws DriverException {
        Integer cnum = channelMap.get(chan);
        if (cnum == null) {
            throw new DriverException("Invalid channel name: " + chan);
        }
        return cnum;
    }

    private static int limitDacValue(double value) {
        return Math.max(Math.min((int)(value + 0.5), 65535), 0);
    }

    static {
        channelMap.put("pump0", 0);
        channelMap.put("pump1", 1);
        channelMap.put("pump2", 2);
        channelMap.put("pump3", 3);
        channelMap.put("pump4", 4);
        channelMap.put("pump5", 5);
        channelMap.put("pump6", 6);
        channelMap.put("pump7", 7);
        channelMap.put("pump8", 8);
        channelNames = new String[9];
        Iterator<String> iterator = channelMap.keySet().iterator();
        while (iterator.hasNext()) {
            String name;
            Ipc.channelNames[Ipc.channelMap.get((Object)name).intValue()] = name = iterator.next();
        }
        VALID_TYPES = new ArrayList<Srp.BoardType>();
        VALID_TYPES.add(Srp.BoardType.ION_PUMP);
    }
}

