/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.httpd;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.astrogrid.samp.httpd.HttpServer;
import org.astrogrid.samp.httpd.ServerResource;

public class ResourceHandler
implements HttpServer.Handler {
    private final String basePath_;
    private final URL serverUrl_;
    private final Map resourceMap_;
    private int iRes_;
    private static Logger logger_ = Logger.getLogger(ResourceHandler.class.getName());
    private static final ServerResource EXPIRED = new ServerResource(){

        public String getContentType() {
            throw new AssertionError();
        }

        public long getContentLength() {
            throw new AssertionError();
        }

        public void writeBody(OutputStream out) {
            throw new AssertionError();
        }
    };

    public ResourceHandler(HttpServer server, String basePath) {
        if (!basePath.startsWith("/")) {
            basePath = "/" + basePath;
        }
        if (!basePath.endsWith("/")) {
            basePath = basePath + "/";
        }
        this.basePath_ = basePath;
        this.serverUrl_ = server.getBaseUrl();
        this.resourceMap_ = new HashMap();
    }

    public synchronized URL addResource(String name, ServerResource resource) {
        String path = this.basePath_ + Integer.toString(++this.iRes_) + "/";
        if (name != null) {
            try {
                path = path + URLEncoder.encode(name, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                logger_.warning("No utf-8?? No cosmetic path name then");
            }
        }
        this.resourceMap_.put(path, resource);
        try {
            URL url = new URL(this.serverUrl_, path);
            logger_.info("Resource added: " + url);
            return new URL(this.serverUrl_, path);
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)"Unknown protocol http??");
        }
    }

    public synchronized void removeResource(URL url) {
        String path = url.getPath();
        if (!this.resourceMap_.containsKey(path)) {
            throw new IllegalArgumentException("Unknown URL to expire: " + url);
        }
        logger_.info("Resource expired: " + url);
        this.resourceMap_.put(path, EXPIRED);
    }

    public HttpServer.Response serveRequest(HttpServer.Request request) {
        String path = request.getUrl();
        if (!path.startsWith(this.basePath_)) {
            return null;
        }
        final ServerResource resource = (ServerResource)this.resourceMap_.get(path);
        if (resource == EXPIRED) {
            return HttpServer.createErrorResponse(410, "Gone");
        }
        if (resource != null) {
            String method;
            LinkedHashMap<String, String> hdrMap = new LinkedHashMap<String, String>();
            hdrMap.put("Content-Type", resource.getContentType());
            long contentLength = resource.getContentLength();
            if (contentLength >= 0L) {
                hdrMap.put("Content-Length", Long.toString(contentLength));
            }
            if ((method = request.getMethod()).equals("HEAD")) {
                return new HttpServer.Response(200, "OK", hdrMap){

                    public void writeBody(OutputStream out) {
                    }
                };
            }
            if (method.equals("GET")) {
                return new HttpServer.Response(200, "OK", hdrMap){

                    public void writeBody(OutputStream out) throws IOException {
                        resource.writeBody(out);
                    }
                };
            }
            return HttpServer.create405Response(new String[]{"HEAD", "GET"});
        }
        return HttpServer.createErrorResponse(404, "Not found");
    }
}

