/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.bridge;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.astrogrid.samp.SampUtils;
import org.astrogrid.samp.httpd.HttpServer;

abstract class IconAdjuster
implements HttpServer.Handler {
    private final URL baseUrl_;
    private static final String OUTPUT_FORMAT_NAME = "png";
    private static final String OUTPUT_MIME_TYPE = "image/png";

    public IconAdjuster(HttpServer server, String basePath) {
        if (!basePath.startsWith("/")) {
            basePath = "/" + basePath;
        }
        if (!basePath.endsWith("/")) {
            basePath = basePath + "/";
        }
        try {
            this.baseUrl_ = new URL(server.getBaseUrl(), basePath);
        }
        catch (MalformedURLException e) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError())).initCause(e));
        }
    }

    public abstract RenderedImage adjustImage(BufferedImage var1);

    public URL exportAdjustedIcon(URL iconUrl) {
        try {
            return new URL(this.baseUrl_ + "?" + SampUtils.uriEncode(iconUrl.toString()));
        }
        catch (MalformedURLException e) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError())).initCause(e));
        }
    }

    private URL getOriginalUrl(String resourcePath) throws MalformedURLException {
        String qurl;
        URL resourceUrl = new URL(this.baseUrl_, resourcePath);
        String query = resourceUrl.getQuery();
        if (query == null) {
            return null;
        }
        String base = resourceUrl.toString();
        if (!(base = base.substring(0, base.length() - query.length())).equals(this.baseUrl_.toString() + "?")) {
            return null;
        }
        try {
            qurl = SampUtils.uriDecode(query);
        }
        catch (RuntimeException e) {
            throw (MalformedURLException)new MalformedURLException().initCause(e);
        }
        return new URL(qurl);
    }

    public HttpServer.Response serveRequest(HttpServer.Request request) {
        URL baseIconUrl;
        try {
            baseIconUrl = this.getOriginalUrl(request.getUrl());
        }
        catch (MalformedURLException e) {
            return HttpServer.createErrorResponse(404, "Not found", e);
        }
        if (baseIconUrl == null) {
            return null;
        }
        HashMap<String, String> hdrMap = new HashMap<String, String>();
        hdrMap.put("Content-Type", OUTPUT_MIME_TYPE);
        String method = request.getMethod();
        if ("HEAD".equals(method)) {
            return new HttpServer.Response(200, "OK", hdrMap){

                public void writeBody(OutputStream out) {
                }
            };
        }
        if ("GET".equals(method)) {
            BufferedImage baseImage;
            try {
                baseImage = ImageIO.read(baseIconUrl);
                if (baseImage == null) {
                    throw new FileNotFoundException(baseIconUrl.toString());
                }
            }
            catch (IOException e) {
                return HttpServer.createErrorResponse(500, "Server I/O error", e);
            }
            final RenderedImage adjustedImage = this.adjustImage(baseImage);
            return new HttpServer.Response(200, "OK", hdrMap){

                public void writeBody(OutputStream out) throws IOException {
                    ImageIO.write(adjustedImage, IconAdjuster.OUTPUT_FORMAT_NAME, out);
                }
            };
        }
        return HttpServer.create405Response(new String[]{"GET", "HEAD"});
    }
}

