/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Agent;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.ChecksumUtils;
import org.lsst.ccs.ComponentConfigurationEnvironment;
import org.lsst.ccs.ConfigurationDAOWrapper;
import org.lsst.ccs.ConfigurationListener;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.states.AgentState;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.config.BulkSettingException;
import org.lsst.ccs.config.CategoryHandler;
import org.lsst.ccs.config.CategoryTag;
import org.lsst.ccs.config.ConfigurationDescription;
import org.lsst.ccs.config.ConfigurationHandler;
import org.lsst.ccs.config.ConfigurationHandlerSet;
import org.lsst.ccs.config.ConfigurationParameterHandler;
import org.lsst.ccs.config.ConfigurationServiceException;
import org.lsst.ccs.config.ConfigurationView;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.framework.TreeWalkerUtils;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.services.AgentCommandDictionaryService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.AgentService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.HasDataProviderInfos;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.utilities.conv.TypeUtils;
import org.lsst.ccs.utilities.structs.ParameterPath;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public final class ConfigurationService
implements ServiceLifecycle,
ClearAlertHandler,
AgentPresenceListener,
AgentService,
HasDataProviderInfos,
HasLifecycle {
    private static final Logger conf_sub_log = Logger.getLogger(ConfigurationService.class.getName());
    private static final Alert CS_ALERT_1 = new Alert("CCSCFGSRV", "configuration service unavailable");
    private static final Alert CS_ALERT_2 = new Alert("CCSCFGOP", "operator error");
    public static final String INITIAL_CONFIGURATION_TOKEN = "(_initialConfiguration_)";
    private ConfigurationDAOWrapper configurationDao;
    private final Set<String> categories = new HashSet<String>();
    private final Map<String, ComponentConfigurationEnvironment> keyEnvironmentMap = new HashMap<String, ComponentConfigurationEnvironment>();
    private String descriptionName;
    private String agentName;
    private boolean useFullPaths = false;
    private ConfigurationView groovyView = null;
    boolean isInitialConfiguration = false;
    public boolean saveInitialConfiguration = false;
    private final Map<String, Serializable> configurationDataAttributes = new HashMap<String, Serializable>();
    private boolean publishChecksum = false;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService stateService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService agentPropertiesService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentCommandDictionaryService agentCommandDictionaryService;
    private final Lock configLock = new ReentrantLock();
    private volatile boolean allowLoadingOfBuildCategory = true;
    private ConfigurationInfo currentConfigInfo;
    public ConfigurationHandlerSet configurationHandler;
    private volatile ConfigurationView currentView;
    public volatile ConfigurationDescription defaultInitialDescription = null;
    public ConfigurationView initialView;
    private final List<ConfigurationListener> configurationListeners = new CopyOnWriteArrayList<ConfigurationListener>();
    private volatile long lastPublishedConfigurationInfoMillis = 0L;
    private volatile boolean canGoToConfigured = false;
    private String userProvidedConfiguration = null;

    @Override
    public String getAgentServiceName() {
        return "configurationService";
    }

    public static Properties getBuildProperties(String agentName, String descriptionName) {
        Properties build;
        Properties p;
        ConfigurationDAOWrapper configurationProxy = new ConfigurationDAOWrapper(new String[]{descriptionName, agentName}, agentName, descriptionName);
        Properties res = p = configurationProxy.getConfigurationProperties("safe", "");
        Properties inputProperties = BootUtils.getInputBuildProperties();
        if (inputProperties != null) {
            inputProperties.putAll((Map<?, ?>)p);
            res = inputProperties;
        }
        if ((build = configurationProxy.getConfigurationProperties("defaultInitial", "build")) != null) {
            res.putAll((Map<?, ?>)build);
        }
        return res;
    }

    public Properties getBuildProperties() {
        return ConfigurationService.getBuildProperties(this.agentName, this.descriptionName);
    }

    @Override
    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState state) {
        if (CS_ALERT_1.getAlertId().equals(alert.getAlertId())) {
            return this.configurationDao.isAvailable() ? ClearAlertHandler.ClearAlertCode.CLEAR_ALERT : ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT;
        }
        if (CS_ALERT_2.getAlertId().equals(alert.getAlertId())) {
            return this.stateService.isInState((Enum)ConfigurationState.CONFIGURED) ? ClearAlertHandler.ClearAlertCode.CLEAR_ALERT : ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT;
        }
        return ClearAlertHandler.ClearAlertCode.UNKNOWN_ALERT;
    }

    @Override
    public void preBuild() {
        if (this.agent.getAgentInfo().getType().compareTo((Enum)AgentInfo.AgentType.WORKER) >= 0) {
            this.configurationDataAttributes.put("type", (Serializable)((Object)"configuration-data-checksum"));
            this.publishChecksum = true;
        }
        if (BootstrapResourceUtils.getBootstrapSystemProperties().getOrDefault((Object)"org.lsst.ccs.config.remote", "false").equals("true")) {
            this.agentPropertiesService.setAgentProperty("org.lsst.ccs.config.remote", "true");
        }
        this.userProvidedConfiguration = (String)this.agent.getComponentLookup().getTopComponentNode().getTag("startupConfig");
        if (this.userProvidedConfiguration != null && this.userProvidedConfiguration.startsWith(INITIAL_CONFIGURATION_TOKEN)) {
            this.userProvidedConfiguration = this.userProvidedConfiguration.replace(INITIAL_CONFIGURATION_TOKEN, "");
            if (this.userProvidedConfiguration.isEmpty()) {
                this.userProvidedConfiguration = "defaultInitial";
            }
            this.isInitialConfiguration = true;
        } else if (this.userProvidedConfiguration == null && (this.agent.getAgentInfo().getType().compareTo((Enum)AgentInfo.AgentType.CONSOLE) <= 0 || System.getProperty("org.lsst.ccs.testcontext", "false").equals("true"))) {
            this.isInitialConfiguration = true;
        }
        String saveInitialConfigurationStr = (String)this.agent.getComponentLookup().getTopComponentNode().getTag("saveInitialConfiguration");
        this.saveInitialConfiguration = "true".equals(saveInitialConfigurationStr);
        ComponentLookup lookup = this.agent.getComponentLookup();
        ComponentNode configServiceNode = lookup.getComponentNodeForObject((Object)this);
        ComponentNode topNode = lookup.getTopComponentNode();
        String descName = (String)topNode.getTag("descriptionName");
        this.descriptionName = descName == null ? this.agent.getClass().getSimpleName() : descName;
        this.agentName = this.agent.getName();
        this.configurationDao = new ConfigurationDAOWrapper(this.agent, this, this.descriptionName);
        lookup.addComponentNodeToLookup(configServiceNode, new ComponentNode("configurationDAO", (Object)this.configurationDao));
        this.currentView = this.initialView = this.scanTreeAndBuildInitialView(true);
        this.initialView.putAll(this.buildUserProvidedConfigurationView(true));
        if (this.hasBuildParameters()) {
            this.currentConfigInfo = this.configurationHandler.initialize(this.descriptionName, this.initialView, true, true);
            this.updateStateAndSendStatusConfigurationInfo(this.currentConfigInfo, ConfigurationListener.ConfigurationOperation.LOAD, false);
        }
    }

    private ConfigurationView buildUserProvidedConfigurationView(boolean isBuild) {
        ConfigurationView userProvidedConfigurationView;
        this.categories.clear();
        this.categories.addAll(this.configurationHandler.getCategorySet());
        if (this.isInitialConfiguration) {
            this.defaultInitialDescription = new ConfigurationDescription(this.categories).withDefaultInitial(true);
            if (this.userProvidedConfiguration != null) {
                this.defaultInitialDescription.parseConfigurationString(this.userProvidedConfiguration.split(","));
            }
        }
        ConfigurationView configurationView = userProvidedConfigurationView = this.groovyView != null ? this.groovyView : new ConfigurationView();
        if (!this.isInitialConfiguration) {
            ConfigurationView additionalUserProvidedConfigurationView = this.configurationDao.loadConfiguration(ConfigurationDescription.safeConfiguration(this.categories));
            userProvidedConfigurationView.putAll(additionalUserProvidedConfigurationView);
            if (!isBuild) {
                ConfigurationDescription startupDescription = new ConfigurationDescription(this.categories).withDefaults(true);
                if (this.userProvidedConfiguration != null) {
                    startupDescription = startupDescription.parseConfigurationString(this.userProvidedConfiguration.split(","));
                    ConfigurationView startupConfigurationFromFile = this.configurationDao.loadConfiguration(startupDescription);
                    userProvidedConfigurationView.putAll(startupConfigurationFromFile);
                }
            }
        } else {
            String[] providedConfs;
            Set<Object> categoriesToLoad = new HashSet();
            ConfigurationDescription startupDescription = null;
            String[] stringArray = providedConfs = this.userProvidedConfiguration != null ? this.userProvidedConfiguration.split(",") : new String[]{};
            if (isBuild) {
                if (this.hasBuildParameters()) {
                    categoriesToLoad.add("build");
                    startupDescription = new ConfigurationDescription(categoriesToLoad).withDefaultInitial(true);
                    for (String conf : providedConfs) {
                        if (!conf.contains("build")) continue;
                        startupDescription = startupDescription.parseConfigurationString(new String[]{conf});
                    }
                }
            } else {
                categoriesToLoad = this.categories;
                startupDescription = new ConfigurationDescription(categoriesToLoad).parseConfigurationString(providedConfs).withDefaultInitial(true);
            }
            if (startupDescription != null) {
                ConfigurationView additionalUserProvidedConfigurationView = this.configurationDao.loadConfiguration(startupDescription);
                userProvidedConfigurationView.putAll(additionalUserProvidedConfigurationView);
            }
        }
        return userProvidedConfigurationView;
    }

    @Override
    public void preInit() {
        this.allowLoadingOfBuildCategory = false;
        this.currentView = this.initialView = this.scanTreeAndBuildInitialView(false);
        ConfigurationView userProvided = this.buildUserProvidedConfigurationView(false);
        this.initialView.putAll(userProvided);
        this.currentConfigInfo = this.configurationHandler.initialize(this.descriptionName, userProvided, false, true);
        this.updateStateAndSendStatusConfigurationInfo(this.currentConfigInfo, ConfigurationListener.ConfigurationOperation.LOAD);
        if (!this.isInitialConfiguration) {
            ConfigurationDescription initialDescription = new ConfigurationDescription(this.categories);
            ConfigurationDescription newStartupDescription = new ConfigurationDescription(this.categories);
            if (this.userProvidedConfiguration != null) {
                ConfigurationDescription tmpInitialDescription = new ConfigurationDescription(this.categories).parseConfigurationString(this.userProvidedConfiguration.split(",")).withDefaults(true);
                for (String category : tmpInitialDescription.getCategoriesSet()) {
                    CategoryTag categoryTag = tmpInitialDescription.getCategoryTag(category);
                    for (String tag : categoryTag.getTags()) {
                        if (!tag.equals("") && !tag.equals("safe")) {
                            newStartupDescription = newStartupDescription.parseConfigurationString(new String[]{category + ":" + tag});
                            continue;
                        }
                        initialDescription = initialDescription.parseConfigurationString(new String[]{category + ":" + "defaultInitial"});
                    }
                }
            }
            Object warnMsg = "\nOption \"--configuration\" has been deprecated and \"--initialConfiguration\" should be used instead.\nTo migrate to using the new option follow these steps:\n";
            if (this.userProvidedConfiguration != null) {
                Properties buildProperties = this.getBuildProperties();
                StringBuilder sb = new StringBuilder();
                for (Object key : buildProperties.keySet()) {
                    if (((String)key).contains("/")) continue;
                    sb.append(key).append("=").append(buildProperties.get(key)).append("\n");
                }
                String buildProps = sb.toString();
                warnMsg = (String)warnMsg + "\t-1- Restart your subsystem by providing the command line option \"--saveInitialConfiguration\".\n\t    This operation will save all your configuration parameters \"defaultInitial\" tag files for all categories.\n\t    Build configuration parameters will be written in a file with category tag \"build:defaultInitial\".";
                if (!buildProperties.isEmpty()) {
                    warnMsg = (String)warnMsg + "\n\t    Add the following build properties to the  \"build:defaultInitial\" tag file: \n" + buildProps;
                }
                warnMsg = (String)warnMsg + "\n\t-2- Edit your app file and replace: \"--configuration " + this.userProvidedConfiguration + " with\n\t\t--initialConfiguration \"" + newStartupDescription.toString() + "\"\n\t-3- Remove/rename your safe properties file from the etc directories. (this is optional but will help avoid confusion)\n\t-4- Restart your subsystem with this new app file.";
            } else {
                warnMsg = (String)warnMsg + "\t- in your app file add: \"--initialConfiguration\"\n";
            }
            conf_sub_log.log(Level.WARNING, (String)warnMsg);
        }
        if (this.saveInitialConfiguration) {
            if (!this.isInitialConfiguration) {
                ConfigurationInfo buildConfigurationInfo;
                this.categories.add("build");
                ConfigurationDescription cd = new ConfigurationDescription(this.categories).withDefaultInitial(true);
                cd.addCategoryTag(CategoryTag.parseCategoryTagInput((String)"build:defaultInitial"));
                ConfigurationInfo.Builder ciBuilder = new ConfigurationInfo.Builder();
                for (ConfigurationParameterInfo cpi : this.currentConfigInfo.getAllParameterInfo()) {
                    ParameterPath pp = new ParameterPath(cpi.getComponentName(), cpi.getParameterName());
                    ciBuilder.addParameter(pp, cpi.getActualType(), cpi.isBuild() ? "build" : cpi.getCategoryName(), cpi.getDescription(), cpi.isFinal(), cpi.isReadOnly(), cpi.isBuild());
                    ciBuilder.updateParameter(pp, cpi.getConfiguredValue(), cpi.getCurrentValue(), false);
                }
                ciBuilder.updateConfigurationDescription(cd.getDescriptionName());
                for (String cat : cd.getCategoriesSet()) {
                    CategoryTag catTag = cd.getCategoryTag(cat);
                    for (String tag : catTag.getTags()) {
                        ciBuilder.updateCategoryInformation(cat, tag, catTag.getTagVersion(tag), false);
                    }
                }
                this.currentConfigInfo = buildConfigurationInfo = ciBuilder.build();
            }
            this.saveFullConfiguration();
            System.exit(0);
        }
    }

    ConfigurationView getCurrentConfigurationView() {
        return new ConfigurationView(this.currentView);
    }

    private boolean hasBuildParameters() {
        for (String category : this.categories) {
            CategoryHandler categoryHandler = this.configurationHandler.getCategoryHandler(category);
            for (ConfigurationParameterHandler cph : categoryHandler.getParameters()) {
                if (!cph.isBuild()) continue;
                return true;
            }
        }
        return false;
    }

    private ConfigurationView scanTreeAndBuildInitialView(boolean isBuild) {
        boolean useFullPathsFromBuild = this.useFullPaths;
        this.useFullPaths = "true".equals(this.agent.getAgentInfo().getAgentProperty("org.lsst.ccs.use.full.paths", "false").toLowerCase());
        if (!isBuild && useFullPathsFromBuild != this.useFullPaths) {
            conf_sub_log.log(Level.WARNING, "Inconsistent value of property \"org.lsst.ccs.use.full.paths\" detected between the BUILD and INIT phases.\nThis could cause serious problems to che ConfigurationService when applying build level properties. Please update your code to set such property earlier in the Agent lifecycle. Please refer to https://jira.slac.stanford.edu/browse/LSSTCCS-1757 on how that could be done.");
        }
        boolean checkConfigViews = this.agent.getAgentInfo().getType().compareTo((Enum)AgentInfo.AgentType.WORKER) >= 0;
        boolean failOnViewProblems = checkConfigViews && this.isInitialConfiguration && !this.saveInitialConfiguration;
        this.configurationHandler = new ConfigurationHandlerSet(this.useFullPaths, checkConfigViews, failOnViewProblems);
        ComponentLookup lookup = this.agent.getComponentLookup();
        ComponentNode topNode = lookup.getTopComponentNode();
        TreeWalkerUtils.proceduralNodeWalk(lookup, null, n -> {
            String nodeName = this.useFullPaths ? n.getPath() : n.getKey();
            Object component = n.getComponent();
            ConfigurationHandler ch = this.configurationHandler.addConfigurationHandlerForObject(nodeName, n.getPath(), component, this.isInitialConfiguration);
            if (ch != null && !isBuild && ch.hasRuntimeParameters()) {
                ComponentConfigurationEnvironment cce = new ComponentConfigurationEnvironment(nodeName, this);
                this.keyEnvironmentMap.put(nodeName, cce);
                this.agentCommandDictionaryService.addCommandSetToObject(cce, n.getPath());
            }
        }, null);
        ConfigurationView initialView = new ConfigurationView();
        initialView.putAll(this.configurationHandler.getLiveConfigurationView());
        if (this.groovyView == null) {
            this.groovyView = new ConfigurationView();
            Map topNodeTags = topNode.getTags();
            for (Map.Entry entry : topNodeTags.entrySet()) {
                if (!(entry.getKey() instanceof String)) continue;
                try {
                    ParameterPath path;
                    String[] split;
                    String value = TypeUtils.stringify(entry.getValue());
                    String parPath = (String)entry.getKey();
                    if (!this.useFullPaths && (split = parPath.split("/")).length > 1) {
                        parPath = split[split.length - 2] + "/" + split[split.length - 1];
                    }
                    if (!this.isParameterConfigurable((path = ParameterPath.valueOf((String)parPath)).getComponentName(), path.getParameterName())) continue;
                    this.groovyView.putParameterValue(path.toString(), value);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        initialView.putAll(this.groovyView);
        return initialView;
    }

    @Override
    public void preStart() {
        this.canGoToConfigured = true;
        if (this.currentConfigInfo.getConfigurationState() != ConfigurationState.CONFIGURED) {
            this.currentConfigInfo.setConfigurationState(ConfigurationState.CONFIGURED);
            this.updateStateAndSendStatusConfigurationInfo(this.currentConfigInfo, ConfigurationListener.ConfigurationOperation.LOAD);
        }
        this.agent.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
    }

    @Override
    public List<DataProviderInfo> getDataProviderInfos() {
        List dataList = this.configurationHandler.getDataPoviderInfoList();
        if (this.publishChecksum) {
            for (String category : this.categories) {
                DataProviderInfo data = new DataProviderInfo("config/data/" + (category.isEmpty() ? "default" : category) + "/checksum", DataProviderInfo.Type.TRENDING, "config/data/" + (category.isEmpty() ? "default" : category) + "/checksum");
                data.addAttribute(DataProviderInfo.Attribute.UNITS, "unitless");
                data.addAttribute(DataProviderInfo.Attribute.DESCRIPTION, "Configuration data checksum for category " + (category.isEmpty() ? "default" : category));
                dataList.add(data);
            }
        }
        return dataList;
    }

    @Override
    public void publishDataProviderCurrentData(AgentInfo agentInfo) {
        if (agentInfo != null && agentInfo.getAgentOperationalTime().getUTCInstant().isBefore(CCSTimeStamp.currentTimeFromMillis(this.lastPublishedConfigurationInfoMillis).getUTCInstant())) {
            conf_sub_log.log(Level.FINER, "Skipping configuration info publication. Last published on {0} compared to {1}", new Object[]{CCSTimeStamp.currentTimeFromMillis(this.lastPublishedConfigurationInfoMillis).getUTCInstant(), agentInfo.getAgentOperationalTime().getUTCInstant()});
            return;
        }
        this.publishConfigurationInfo();
    }

    @Command(category=Command.CommandCategory.CORE, type=Command.CommandType.QUERY, level=0)
    public String getConfigurationParameterValue(@Argument(allowedValueProvider="getAllConfigurableComponents") String componentName, String parameterName) {
        StringBuilder sb = new StringBuilder();
        ConfigurationView view = this.configurationHandler.getLiveConfigurationView();
        return (String)view.getValuesForComponent(componentName).get(parameterName);
    }

    @Command(category=Command.CommandCategory.CORE, type=Command.CommandType.QUERY, level=0)
    public String printConfigurationParameters(@Argument(defaultValue="[]") Set<String> cats) {
        StringBuilder sb = new StringBuilder();
        ConfigurationView view = this.configurationHandler.getLiveConfigurationView();
        Set<String> categories = this.getCategories();
        for (String category : categories) {
            if (!cats.isEmpty() && !cats.contains(category)) continue;
            sb.append("Category : ").append(category).append("\n");
            CategoryHandler catHandler = this.configurationHandler.getCategoryHandler(category);
            for (ConfigurationParameterHandler par : catHandler.getParameters()) {
                String configType = par.isFinal() ? "final" : (par.isBuild() ? "build" : (par.isReadOnly() ? "read-only" : ""));
                ParameterPath path = par.getParameterPath();
                ConfigurationParameterInfo cpi = this.getConfigurationInfo().getCurrentParameterInfo(path.toString());
                sb.append(path).append(cpi.isDirty() ? "*" : "").append(" ").append(view.getPathValue(path)).append(" ").append(par.getUnits()).append(configType.isEmpty() ? "" : " (" + configType + ")").append("\n");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    @Deprecated
    @Command(description="Saves all changes in the current configurations", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE)
    public void saveAllChanges() {
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            this.checkForSubmittedChanges();
            this.saveAllChanges(null, false);
        }
    }

    private void saveAllChanges(String configName, boolean fullConfiguration) {
        ConfigurationDescription cd = this.getPartialConfigurationDescription(this.categories.toArray(new String[1]));
        cd.setName(configName, -1);
        this.saveChangesForCategoriesInternal(cd, fullConfiguration);
    }

    @Command(description="Saves all changes in the current configurations", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE)
    public void saveFullConfiguration() {
        this.saveAllChanges(null, true);
    }

    @Command(description="Saves the specified categories with a name", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE)
    public void saveChangesForCategories(String ... categories) {
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            this.checkForSubmittedChanges();
            ConfigurationDescription currentDescription = ConfigurationDescription.fromConfigurationInfo((ConfigurationInfo)this.currentConfigInfo);
            ConfigurationDescription saveDescription = new ConfigurationDescription();
            for (String category : categories) {
                CategoryTag categoryTag = null;
                if (category.contains(":")) {
                    categoryTag = CategoryTag.parseCategoryTagInput((String)category, (boolean)this.isInitialConfiguration);
                    if (categoryTag.getTags().size() > 1) {
                        throw new IllegalArgumentException("When saving configurations we accept only one tag. Illegal input: " + categoryTag);
                    }
                } else {
                    categoryTag = currentDescription.getCategoryTag(category);
                }
                if (this.isInitialConfiguration) {
                    String cat = categoryTag.getCategoryName();
                    categoryTag = new CategoryTag(cat).merge(this.defaultInitialDescription.getCategoryTag(cat)).merge(categoryTag);
                }
                saveDescription.addCategoryTag(categoryTag);
            }
            this.saveChangesForCategoriesInternal(saveDescription, false);
        }
    }

    @Command(description="Saves the specified categories with a name", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE)
    public void saveFullConfigurationForCategories(String ... categories) {
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            this.checkForSubmittedChanges();
            ConfigurationDescription currentDescription = ConfigurationDescription.fromConfigurationInfo((ConfigurationInfo)this.currentConfigInfo);
            ConfigurationDescription saveDescription = new ConfigurationDescription();
            for (String category : categories) {
                CategoryTag categoryTag = null;
                if (category.contains(":")) {
                    categoryTag = CategoryTag.parseCategoryTagInput((String)category, (boolean)this.isInitialConfiguration);
                    if (categoryTag.getTags().size() > 1) {
                        throw new IllegalArgumentException("When saving configurations we accept only one tag. Illegal input: " + categoryTag);
                    }
                } else {
                    categoryTag = currentDescription.getCategoryTag(category);
                }
                if (this.isInitialConfiguration) {
                    String cat = categoryTag.getCategoryName();
                    categoryTag = new CategoryTag(cat).merge(this.defaultInitialDescription.getCategoryTag(cat)).merge(categoryTag);
                }
                saveDescription.addCategoryTag(categoryTag);
            }
            this.saveChangesForCategoriesInternal(saveDescription, true);
        }
    }

    @Command(description="Saves the specified categories with a name", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE)
    @Deprecated
    public void saveChangesForCategoriesAs(String ... taggedCategories) {
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            this.checkForSubmittedChanges();
            ConfigurationDescription cd = new ConfigurationDescription(this.categories);
            cd.parseConfigurationString(this.isInitialConfiguration, taggedCategories);
            for (String category : cd.getCategoriesSet()) {
                CategoryTag categoryTag = cd.getCategoryTag(category);
                if (categoryTag.getTags().size() <= 1) continue;
                throw new IllegalArgumentException("When saving configurations we accept only one tag. Illegal input: " + categoryTag);
            }
            ConfigurationDescription res = new ConfigurationDescription();
            for (String category : cd.getCategoriesSet()) {
                CategoryTag ct = this.isInitialConfiguration ? new CategoryTag(category).merge(this.defaultInitialDescription.getCategoryTag(category)) : null;
                CategoryTag saveTag = cd.getCategoryTag(category);
                if (ct == null) {
                    ct = saveTag;
                } else {
                    ct.merge(saveTag);
                }
                res.addCategoryTag(ct);
            }
            this.saveChangesForCategoriesInternal(res, false);
        }
    }

    private void saveChangesForCategoriesInternal(ConfigurationDescription configDesc, boolean fullConfiguration) {
        this.checkValidStates(true);
        if (configDesc.isEmpty()) {
            return;
        }
        this.checkCategories(configDesc.getCategoriesSet());
        try {
            ConfigurationView currentView = this.configurationHandler.getLiveConfigurationView();
            ConfigurationView diff = this.extractConfigurationViewFromCurrentConfigurationInfo().diff(currentView);
            if (!diff.isEmpty()) {
                StringBuilder sb = new StringBuilder("the following parameters have had their value changed without notifying the configuration service : \n");
                for (ParameterPath parm : diff.getAsParameterPathMap().keySet()) {
                    sb.append(parm).append(" expected ").append(this.currentConfigInfo.getCurrentValueForParameter(parm.toString())).append(" was ").append(currentView.getPathValue(parm)).append("\n");
                }
                throw new BulkSettingException(sb.toString());
            }
            currentView.setConfigurationDescription(configDesc);
            ConfigurationInfo.Builder ciBuilder = this.buildConfigurationInfo(currentView);
            ConfigurationInfo ci = ciBuilder.build();
            ConfigurationDescription desc = this.configurationDao.saveChangesForCategoriesAs(configDesc, ci, fullConfiguration);
            this.updateStateAndSendStatusConfigurationInfo(ci, ConfigurationListener.ConfigurationOperation.SAVE);
        }
        catch (RuntimeException ex) {
            this.handleException(ex, ConfigurationListener.ConfigurationOperation.SAVE);
        }
    }

    private ConfigurationDescription getPartialConfigurationDescription(String ... categories) {
        HashSet<String> set = new HashSet<String>(Arrays.asList(categories));
        return ConfigurationDescription.fromConfigurationInfo((ConfigurationInfo)this.currentConfigInfo, set);
    }

    @Command(description="drop all unsaved changes", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public void dropAllChanges() {
        this.dropChangesInternal(this.categories);
    }

    @Command(description="drop unsaved changes for the specified categories", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public void dropChangesForCategories(String ... categories) {
        HashSet<String> catSet = new HashSet<String>();
        catSet.addAll(Arrays.asList(categories));
        this.dropChangesInternal(catSet);
    }

    private void dropChangesInternal(Set<String> categories) {
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            this.checkValidStates(true);
            this.checkCategories(categories);
            try {
                ConfigurationView view = new ConfigurationView(this.getPartialConfigurationDescription(categories.toArray(new String[1])));
                for (ConfigurationParameterInfo cpi : this.currentConfigInfo.getAllParameterInfo()) {
                    if (!categories.contains(cpi.getCategoryName())) continue;
                    view.putParameterValue(cpi.getComponentName(), cpi.getParameterName(), cpi.getConfiguredValue());
                }
                ConfigurationView res = this.configurationHandler.loadCategories(view);
                ConfigurationInfo.Builder ciBuilder = this.buildConfigurationInfo(res);
                ConfigurationDescription desc = this.configurationDao.registerConfiguration(ciBuilder.build());
                this.updateStateAndSendStatusConfigurationInfo(ciBuilder.build(), ConfigurationListener.ConfigurationOperation.DROP);
            }
            catch (RuntimeException ex) {
                this.handleException(ex, ConfigurationListener.ConfigurationOperation.DROP);
            }
        }
    }

    @Command(description="loads a new configuration", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE)
    public void loadConfiguration(String ... taggedCategories) {
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            this.checkValidStates(false);
            this.checkForSubmittedChanges();
            ConfigurationDescription res = new ConfigurationDescription();
            if (this.isInitialConfiguration) {
                res = new ConfigurationDescription();
                res.merge(this.defaultInitialDescription);
            }
            ConfigurationDescription configDesc = new ConfigurationDescription(this.categories).parseConfigurationString(this.isInitialConfiguration, taggedCategories);
            configDesc = this.isInitialConfiguration ? configDesc.withDefaultInitial(true) : configDesc.withDefaults(true);
            res.merge(configDesc);
            this.loadCategoriesInternal(res);
        }
    }

    @Command(description="loads the configuration for the specified categories", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public void loadCategories(String ... taggedCategories) {
        if (taggedCategories.length == 0) {
            return;
        }
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            this.checkValidStates(true);
            this.checkForSubmittedChanges();
            ConfigurationDescription configDesc = new ConfigurationDescription(this.categories).parseConfigurationString(this.isInitialConfiguration, taggedCategories);
            ConfigurationDescription res = new ConfigurationDescription();
            for (String category : configDesc.getCategoriesSet()) {
                CategoryTag catTag = new CategoryTag(category);
                if (this.isInitialConfiguration) {
                    catTag.merge(this.defaultInitialDescription.getCategoryTag(category));
                }
                catTag.merge(configDesc.getCategoryTag(category));
                res.addCategoryTag(catTag);
            }
            this.loadCategoriesInternal(res);
        }
    }

    private void loadCategoriesInternal(ConfigurationDescription configDesc) {
        try {
            this.checkCategories(configDesc.getCategoriesSet());
            if (!this.allowLoadingOfBuildCategory) {
                configDesc.removeCategory("build");
            }
            ConfigurationView cv = this.configurationDao.loadConfiguration(configDesc);
            ConfigurationView res = this.configurationHandler.loadCategories(cv);
            ConfigurationInfo.Builder ciBuilder = this.buildConfigurationInfo(res);
            ConfigurationDescription desc = this.configurationDao.registerConfiguration(ciBuilder.build());
            this.updateStateAndSendStatusConfigurationInfo(ciBuilder.build(), ConfigurationListener.ConfigurationOperation.LOAD);
        }
        catch (RuntimeException ex) {
            this.handleException(ex, ConfigurationListener.ConfigurationOperation.LOAD);
        }
    }

    @Command(description="return a ConfigurationInfo object", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
    public ConfigurationInfo getConfigurationInfo() {
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            ConfigurationInfo configurationInfo = this.currentConfigInfo;
            return configurationInfo;
        }
    }

    @Command(description="return a ConfigurationInfo object", type=Command.CommandType.QUERY, category=Command.CommandCategory.CORE)
    public String getConfigurationState() {
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            String string = this.currentConfigInfo.toString();
            return string;
        }
    }

    public void setReadOnlyParameter(String componentName, String parameterName, Object value) {
        if (!this.isParameterReadOnly(componentName, parameterName)) {
            throw new IllegalArgumentException(componentName + "/" + parameterName + " is not a read-only configuration parameter");
        }
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            try {
                ConfigurationView view = this.configurationHandler.setSingleParameter(componentName, parameterName, value, true);
                ConfigurationInfo.Builder ciBuilder = this.buildConfigurationInfo(view);
                ConfigurationDescription desc = this.configurationDao.registerConfiguration(ciBuilder.build());
                this.updateStateAndSendStatusConfigurationInfo(ciBuilder.build(), ConfigurationListener.ConfigurationOperation.CHANGE);
            }
            catch (RuntimeException ex) {
                this.handleException(ex, ConfigurationListener.ConfigurationOperation.CHANGE);
            }
        }
    }

    @Command(description="publish a ConfigurationInfo object", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
    public void publishConfigurationInfo() {
        this.lastPublishedConfigurationInfoMillis = System.currentTimeMillis();
        ConfigurationInfo ci = this.getConfigurationInfo();
        this.agent.sendStatusMessage((StatusMessage)new StatusConfigurationInfo(ci));
        if (this.publishChecksum) {
            long start = System.currentTimeMillis();
            KeyValueDataList dataList = new KeyValueDataList("", this.configurationDataAttributes);
            for (String category : this.categories) {
                TreeMap values = new TreeMap(ci.getCurrentValuesForCategory(category));
                dataList.addData("config/data/" + (category.isEmpty() ? "default" : category) + "/checksum", (Serializable)Long.valueOf(ChecksumUtils.evaluateChecksum(values)));
            }
            this.agent.publishSubsystemDataOnStatusBus((KeyValueData)dataList);
            long delta = System.currentTimeMillis() - start;
            conf_sub_log.log(Level.FINER, "Checksum evaluation tool {0} ms.", delta);
        }
    }

    @Command(description="Submits a single change to be processed immediately", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public void change(@Argument(allowedValueProvider="getAllConfigurableComponents") String componentName, String parameterName, Object value) {
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            this.checkValidStates(true);
            if (!this.isParameterConfigurable(componentName, parameterName)) {
                throw new IllegalArgumentException(componentName + "/" + parameterName + " is not a configuration parameter");
            }
            if (this.isParameterReadOnly(componentName, parameterName)) {
                throw new IllegalArgumentException(componentName + "/" + parameterName + " is a read-only configuration parameter");
            }
            this.checkForSubmittedChanges();
            try {
                ConfigurationView view = this.configurationHandler.setSingleParameter(componentName, parameterName, value);
                ConfigurationInfo.Builder ciBuilder = this.buildConfigurationInfo(view);
                ConfigurationDescription desc = this.configurationDao.registerConfiguration(ciBuilder.build());
                this.updateStateAndSendStatusConfigurationInfo(ciBuilder.build(), ConfigurationListener.ConfigurationOperation.CHANGE);
            }
            catch (RuntimeException ex) {
                this.handleException(ex, ConfigurationListener.ConfigurationOperation.CHANGE);
            }
        }
    }

    public List<String> getAllConfigurableComponents() {
        ArrayList<String> result = new ArrayList<String>();
        ConfigurationView view = this.configurationHandler.getLiveConfigurationView();
        Map values = view.getAsParameterPathMap();
        for (Map.Entry e : values.entrySet()) {
            result.add(((ParameterPath)e.getKey()).getComponentName());
        }
        return result;
    }

    @Command(description="Submits a change of parameter to be validated later", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public void submitChange(@Argument(allowedValueProvider="getAllConfigurableComponents") String componentName, String parameterName, Object value) {
        this.checkValidStates(true);
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            this.configurationHandler.submitChange(componentName, parameterName, value);
        }
    }

    @Command(description="Submits changes of parameters to be validated later", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public void submitChanges(@Argument(allowedValueProvider="getAllConfigurableComponents") String componentName, Map<String, Object> changes) {
        this.checkValidStates(true);
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            for (Map.Entry<String, Object> entry : changes.entrySet()) {
                this.configurationHandler.submitChange(componentName, entry.getKey(), entry.getValue());
            }
        }
    }

    @Command(description="processes the bulk change", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public void commitBulkChange() {
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            this.checkValidStates(true);
            try {
                ConfigurationView view = this.configurationHandler.commitBulkChange(null);
                ConfigurationInfo.Builder ciBuilder = this.buildConfigurationInfo(view);
                ConfigurationDescription cd = this.configurationDao.registerConfiguration(ciBuilder.build());
                this.updateStateAndSendStatusConfigurationInfo(ciBuilder.build(), ConfigurationListener.ConfigurationOperation.CHANGE);
                conf_sub_log.log(Level.FINEST, this.currentConfigInfo.getLatestChanges().size() + " successfully set parameters");
            }
            catch (RuntimeException ex) {
                this.handleException(ex, ConfigurationListener.ConfigurationOperation.CHANGE);
            }
        }
    }

    @Command(description="Drops the submitted changes for all components", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public void dropAllSubmittedChanges() {
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            this.configurationHandler.dropAllSubmittedChanges();
        }
    }

    @Command(description="Drops the submitted changes for the given component", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public void dropSubmittedChangesForComponent(@Argument(allowedValueProvider="getAllConfigurableComponents", description="the component name") String name) {
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            this.configurationHandler.dropSubmittedChangesForComponent(name);
        }
    }

    @Command(description="Returns the current submitted changes for the given component", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public Map<String, String> getSubmittedChangesForComponent(@Argument(allowedValueProvider="getAllConfigurableComponents", description="the component name") String name) {
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            Map map = this.configurationHandler.getSubmittedChangesForComponent(name);
            return map;
        }
    }

    @Command(description="Returns the current submitted changes for each component", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE, level=1)
    public Map<String, Map<String, String>> getAllSubmittedChanges() {
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            Map map = this.configurationHandler.getAllSubmittedChanges();
            return map;
        }
    }

    @Command(description="returns the categories of this subsystem", type=Command.CommandType.QUERY, category=Command.CommandCategory.CORE)
    public Set<String> getCategories() {
        return Collections.unmodifiableSet(this.categories);
    }

    List<String> getCategoriesList() {
        return new ArrayList<String>(this.getCategories());
    }

    @Command(description="returns the available configurations for the given category", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE)
    public Set<String> findAvailableConfigurationsForCategory(@Argument(allowedValueProvider="getCategoriesList") String category) {
        try {
            return this.configurationDao.findAvailableConfigurationsForCategory(category);
        }
        catch (ConfigurationServiceException ex) {
            this.agent.getAgentService(AlertService.class).raiseAlert(CS_ALERT_1, AlertState.ALARM, ex.getMessage());
            throw ex;
        }
    }

    @Command(description="returns the current values for a given component that belong to the specified categories", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE)
    public Map<String, String> getCurrentValuesForComponent(@Argument(allowedValueProvider="getAllConfigurableComponents") String componentName, Set<String> categorySet) {
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            Map map = this.configurationHandler.getCurrentValuesForComponent(componentName, categorySet);
            return map;
        }
    }

    @Command(type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.CORE)
    public boolean isParameterConfigurable(@Argument(allowedValueProvider="getAllConfigurableComponents") String componentName, String parameterName) {
        return this.configurationHandler.isParameterConfigurable(componentName, parameterName);
    }

    public boolean isParameterReadOnly(String componentName, String parameterName) {
        return this.configurationHandler.isParameterReadOnly(componentName, parameterName);
    }

    @Command(description="locates configurations when they are loaded from the filesystem.", type=Command.CommandType.CONFIGURATION, category=Command.CommandCategory.SYSTEM)
    public String locateConfigurations() {
        return this.configurationDao.locateConfigurations(this.currentConfigInfo);
    }

    public String getTag() {
        return this.descriptionName;
    }

    public void connected(AgentInfo ... ai) {
        for (AgentInfo a : ai) {
            if (!"true".equals(a.getAgentProperty("org.lsst.ccs.config.service"))) continue;
            this.publishConfigurationInfo();
            return;
        }
    }

    public ConfigurationLock acquireConfigurationLock() {
        return new ConfigurationLock();
    }

    public ConfigurationLock tryAcquireConfigurationLock(long time, TimeUnit unit) throws InterruptedException, TimeoutException {
        return new ConfigurationLock(time, unit);
    }

    public ComponentConfigurationEnvironment getComponentConfigurationEnvironment(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Provided name cannot be null.");
        }
        ComponentConfigurationEnvironment environment = this.keyEnvironmentMap.get(name);
        if (environment == null) {
            throw new IllegalArgumentException("No Component with name \"" + name + "\" containing configuration parameters.");
        }
        return environment;
    }

    public void addConfigurationListener(ConfigurationListener listener) {
        this.configurationListeners.add(listener);
    }

    public void removeConfigurationListener(ConfigurationListener listener) {
        this.configurationListeners.remove(listener);
    }

    private synchronized void notifyConfigurationListeners(ConfigurationInfo newConfigurationInfo, ConfigurationInfo oldConfigurationInfo, ConfigurationListener.ConfigurationOperation co) {
        for (ConfigurationListener l : this.configurationListeners) {
            try {
                l.configurationChanged(newConfigurationInfo, oldConfigurationInfo, co);
            }
            catch (Exception e) {
                conf_sub_log.log(Level.WARNING, "ConfigurationListener exception", e);
            }
        }
    }

    private void updateStateAndSendStatusConfigurationInfo(ConfigurationInfo ci, ConfigurationListener.ConfigurationOperation co) {
        this.updateStateAndSendStatusConfigurationInfo(ci, co, true);
    }

    private void updateStateAndSendStatusConfigurationInfo(ConfigurationInfo ci, ConfigurationListener.ConfigurationOperation co, boolean notifyListeners) {
        ConfigurationInfo previousConfigurationInfo = this.currentConfigInfo;
        this.currentConfigInfo = ci;
        this.currentView = this.extractConfigurationViewFromConfigurationInfo(this.currentConfigInfo);
        this.stateService.updateInternalState(new AgentState[]{this.currentConfigInfo.getConfigurationState()});
        if (this.agent.isConnectedToTheBuses()) {
            this.publishConfigurationInfo();
        }
        if (notifyListeners) {
            this.notifyConfigurationListeners(this.currentConfigInfo, previousConfigurationInfo, co);
        }
    }

    ConfigurationInfo.Builder buildConfigurationInfo(ConfigurationView newView) {
        return this.buildConfigurationInfo(newView, true);
    }

    ConfigurationInfo.Builder buildConfigurationInfo(ConfigurationView newView, boolean mustBeComplete) {
        ConfigurationDescription configDesc = newView.getConfigurationDescription();
        ConfigurationDescription fullConfigDesc = ConfigurationDescription.fromConfigurationInfo((ConfigurationInfo)this.currentConfigInfo);
        if (configDesc != null) {
            for (Object category : configDesc.getCategoriesSet()) {
                fullConfigDesc.addCategoryTag(configDesc.getCategoryTag((String)category));
            }
        }
        if (configDesc == null) {
            configDesc = new ConfigurationDescription(this.categories);
        }
        ConfigurationDescription cd = new ConfigurationDescription(this.categories);
        for (String cat : this.currentConfigInfo.getCategorySet()) {
            if (fullConfigDesc.containsCategory(cat)) {
                CategoryTag categoryTag = fullConfigDesc.getCategoryTag(cat);
                cd.addCategoryTag(categoryTag);
                continue;
            }
            cd.putTagForCategory(cat, this.currentConfigInfo.getConfigNameForCategory(cat), this.currentConfigInfo.getConfigVersion(cat));
        }
        ConfigurationInfo.Builder ciBuilder = new ConfigurationInfo.Builder().setDescription(this.descriptionName);
        ConfigurationState nextState = ConfigurationState.CONFIGURED;
        for (Map.Entry entry : ConfigurationInfo.getParameterInfoGroupByCategory((List)this.currentConfigInfo.getAllParameterInfo()).entrySet()) {
            String category = (String)entry.getKey();
            boolean categoryCommitted = configDesc.containsCategory(category);
            boolean dirtyCat = false;
            for (ConfigurationParameterInfo cpi : (List)entry.getValue()) {
                boolean dirtyParm;
                ParameterPath path = ParameterPath.valueOf((String)cpi.getPathName());
                String currentValue = null;
                try {
                    currentValue = newView.getPathValue(path);
                }
                catch (Exception e) {
                    if (!mustBeComplete) continue;
                    throw e;
                }
                if (currentValue == null) continue;
                String configuredValue = categoryCommitted ? currentValue : cpi.getConfiguredValue();
                ciBuilder.addParameter(ParameterPath.valueOf((String)cpi.getPathName()), cpi.getActualType(), cpi.getCategoryName(), cpi.getDescription(), cpi.isFinal(), cpi.isReadOnly(), cpi.isBuild());
                boolean bl = dirtyParm = !cpi.isReadOnly() && !currentValue.equals(configuredValue);
                if (!currentValue.equals(this.currentConfigInfo.getCurrentValueForParameter(path.toString())) || dirtyParm != cpi.isDirty()) {
                    ciBuilder.addRecentChange(path.toString());
                }
                ciBuilder.updateParameter(ParameterPath.valueOf((String)cpi.getPathName()), configuredValue, currentValue, dirtyParm);
                if (!dirtyParm) continue;
                dirtyCat = true;
                nextState = ConfigurationState.DIRTY;
            }
            CategoryTag categoryTag = cd.getCategoryTag(category);
            categoryTag.setHasChanges(dirtyCat);
            for (String tag : categoryTag.getTags()) {
                ciBuilder.updateCategoryInformation(category, tag, categoryTag.getTagVersion(tag), dirtyCat);
            }
        }
        if (!this.canGoToConfigured) {
            nextState = ConfigurationState.UNCONFIGURED;
        }
        return ciBuilder.setConfigurationState(nextState).setGlobalConfigurationInformation(configDesc.getName(), Integer.valueOf(configDesc.getVersion())).setCCSTimeStamp(CCSTimeStamp.currentTime()).updateConfigurationDescription(cd.getDescriptionName());
    }

    ConfigurationView extractConfigurationViewFromCurrentConfigurationInfo() {
        return this.extractConfigurationViewFromConfigurationInfo(this.currentConfigInfo);
    }

    ConfigurationView extractConfigurationViewFromConfigurationInfo(ConfigurationInfo ci) {
        return this.extractConfigurationViewFromConfigurationInfo(ci, Collections.EMPTY_SET);
    }

    ConfigurationView extractConfigurationViewFromConfigurationInfo(ConfigurationInfo ci, Set<String> categories) {
        List list = ci.getAllParameterInfo();
        ConfigurationView cv = new ConfigurationView();
        for (ConfigurationParameterInfo cpi : list) {
            String parameterCategory;
            if (!categories.isEmpty() && !categories.contains(parameterCategory = this.configurationHandler.getParameterSet(cpi.getComponentName()).getConfigurationParameterHandler(cpi.getParameterName()).getCategory())) continue;
            cv.putParameterValue(cpi.getComponentName(), cpi.getParameterName(), cpi.getCurrentValue());
        }
        ConfigurationDescription cd = new ConfigurationDescription();
        cd.parseConfigurationString(ci.getTaggedCategories().split(","));
        cv.setConfigurationDescription(cd);
        return cv;
    }

    private void checkCategories(Set<String> categories) {
        for (String cat : categories) {
            if (this.categories.contains(cat)) continue;
            throw new IllegalArgumentException("The provided category \"" + cat + "\" does not exist. Valid categories are: " + this.categories);
        }
    }

    private void checkValidStates(boolean failIfNotEM) {
        if (this.configurationHandler == null) {
            throw new IllegalStateException("the configuration service is not initialized yet");
        }
        if (failIfNotEM && !this.agent.isInEngineeringMode()) {
            throw new IllegalStateException("Fine grained configuration actions are accepted only in engineering mode");
        }
    }

    private void checkForSubmittedChanges() {
        if (this.configurationHandler.hasSubmittedChanges()) {
            throw new RuntimeException("A load/save/change operation cannot be performed while there are outstanding uncommitted changes.\nTo view the submitted changes issue the command \"getAllSubmittedChanges\".\nTo allow load/save/change operation you can either commit the submitted changes with \"commitBulkChange\" or you can drop them by issuing command \"dropAllSubmittedChanges\"");
        }
    }

    private void handleException(RuntimeException ex, ConfigurationListener.ConfigurationOperation co) {
        ConfigurationView view = this.configurationHandler.getLiveConfigurationView();
        this.updateStateAndSendStatusConfigurationInfo(this.buildConfigurationInfo(view).build(), co);
        if (ex instanceof ConfigurationServiceException) {
            this.alertService.raiseAlert(CS_ALERT_1, AlertState.ALARM, ex.getMessage());
        } else if (ex instanceof BulkSettingException) {
            this.alertService.raiseAlert(CS_ALERT_2, AlertState.ALARM, ex.getMessage());
        }
        throw ex;
    }

    public class ConfigurationLock
    implements AutoCloseable {
        private ConfigurationLock(long time, TimeUnit unit) throws InterruptedException, TimeoutException {
            if (!ConfigurationService.this.configLock.tryLock(time, unit)) {
                throw new TimeoutException("could not acquire lock within given time");
            }
        }

        private ConfigurationLock() {
            ConfigurationService.this.configLock.lock();
        }

        @Override
        public void close() {
            ConfigurationService.this.configLock.unlock();
        }
    }
}

