package org.lsst.ccs.subsystem.mmm.alerts;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map.Entry;
import org.lsst.ccs.bus.data.Alert;

/**
 * MMM level Alerts.
 * 
 * @author The LSST CCS Team
 */
public enum MmmAlerts {

    MissingSubsystem("MissingSubsystems","Alert raised by the MMM when subsystems are missing");
    
    private final String id, description;
    
    MmmAlerts(String id, String description) {
        this.id = id;
        this.description = description;
    }
    
    public String getAlertId() {
        return id;
    }
    
    public String getDescription() {
        return description;
    }
    
    public Alert getAlert(Enum group, Serializable... parameters) {
        String alertId = id+"/"+group;
        HashMap<String,Serializable> data = new HashMap<>();
        data.put("group", group.name());
        
        if ( id.equals(MissingSubsystem.id) && (parameters != null && parameters.length > 0)) {
            data.put("missing",parameters[0]);
        }
        Alert a = new Alert(alertId,description);
        for ( Entry<String,Serializable> e : data.entrySet() ) {
            a.addAlertData(e.getKey(), e.getValue());
        }
        return a;
    }
        
}
