/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ad;

import javax.usb.UsbException;
import org.lsst.ccs.drivers.ad.Cypress;
import org.lsst.ccs.drivers.usb.UsbComm;

public class I2cBus
extends Cypress {
    private static final int READ_TIMEOUT = 1000;
    private static final int RQST_I2C = 221;
    private static final int ADDR_I2C_READ = 145;
    private static final int ADDR_I2C_WRITE = 144;
    private static final String STD_LOAD_FILE = "/Icv_usb.hex";

    public I2cBus(UsbComm com) throws UsbException {
        super(com);
    }

    void initialize() throws UsbException {
        this.load(false);
    }

    public int readRegister2(int regnum) throws UsbException {
        byte[] data = new byte[2];
        this.readRegister(regnum, data);
        return data[1] & 0xFF | (data[0] & 0xFF) << 8;
    }

    public int readRegister3(int regnum) throws UsbException {
        byte[] data = new byte[3];
        this.readRegister(regnum, data);
        return data[2] & 0xFF | (data[1] & 0xFF) << 8 | (data[0] & 0xFF) << 16;
    }

    public int readRegister(int regnum, byte[] data) throws UsbException {
        return this.com.read(192, 221, 145, regnum, data, 1000);
    }

    public int readRegister(int regnum) throws UsbException {
        byte[] data = new byte[1];
        this.com.read(192, 221, 145, regnum, data, 1000);
        return data[0] & 0xFF;
    }

    public int writeRegister(int regnum, byte[] data) throws UsbException {
        return this.com.write(64, 221, 144, regnum, data);
    }

    public void writeRegister(int regnum, int value) throws UsbException {
        byte[] data = new byte[]{(byte)value};
        this.com.write(64, 221, 144, regnum, data);
    }

    public void updateRegister(int regnum, int mask, int value) throws UsbException {
        byte[] data = new byte[1];
        this.com.read(192, 221, 145, regnum, data, 1000);
        data[0] = (byte)(data[0] & ~mask | value & mask);
        this.com.write(64, 221, 144, regnum, data);
    }

    public void load(boolean force) throws UsbException {
        this.load(STD_LOAD_FILE, force);
    }
}

