/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.metrology;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.usb.UsbException;
import jline.console.ConsoleReader;
import org.lsst.ccs.drivers.ad.Ad7747Eval;
import org.lsst.ccs.utilities.sa.CmndProcess;

public class CapTest {
    private static final int CHAN_CAP = 0;
    private static final int CHAN_TEMP = 1;
    private static final int CHAN_VOLT = 2;
    private static final int CHAN_VDD = 3;
    private static final int MONITOR_PERIOD = 500;
    private static final int SEL_NONE = 256;
    private static final int SEL_ALL = 257;
    private static final int SEP_ON = 1;
    private static final int SEP_OFF = 0;
    private static final int SHOW_SAMPLE = 1;
    private static final int SHOW_RATE = 2;
    private static final int SHOW_SELECT = 4;
    private static final int SHOW_SEPARATE = 8;
    private static final int SHOW_PAUSE = 16;
    private static final int SHOW_CYCLE = 32;
    private static final String DEFAULT_NAME = "Captest";
    private static final CmndProcess.Lookup rateNames = new CmndProcess.Lookup(8);
    private static final CmndProcess.Lookup chanNames;
    private static final CmndProcess.Lookup selNames;
    private static final CmndProcess.Lookup sepNames;
    private static final PrintStream out;
    private final CmndProcess topProc = new CmndProcess();
    private final CmndProcess rptProc = new CmndProcess(true);
    private final MonitorData monData = new MonitorData();
    private final Timer monTimer = new Timer();
    private ConsoleReader reader;
    private int idMask;
    private int daqChan;
    private int daqNSamp;
    private int nEvent;
    private int nToss;
    private int nSamp = 1;
    private int rate = 7;
    private int nCycle = 1;
    private int actvMask;
    private boolean sepDaq = true;
    private long pause = 0L;
    private ArrayList<Ad7747Eval> boards = new ArrayList();
    private ArrayBlockingQueue<Integer> doneQueue;
    private ArrayBlockingQueue<Integer> rptConsQueue;
    private ArrayBlockingQueue<Integer> monConsQueue;
    private int[] id;
    private boolean debug;
    private boolean runActive;
    private boolean monActive;
    private boolean stopMon;
    private boolean repeat;
    private DaqThread[] daq;
    private String logName = "Captest";
    private String comment = "";
    private PrintStream logFile;

    static {
        rateNames.add("45.5", 0);
        rateNames.add("41.9", 1);
        rateNames.add("25.0", 2);
        rateNames.add("13.2", 3);
        rateNames.add("8.1", 4);
        rateNames.add("6.5", 5);
        rateNames.add("5.5", 6);
        rateNames.add("4.6", 7);
        chanNames = new CmndProcess.Lookup(4);
        chanNames.add("capacitance", 0);
        chanNames.add("temperature", 1);
        chanNames.add("voltage", 2);
        chanNames.add("vdd", 3);
        selNames = new CmndProcess.Lookup(2);
        selNames.add("all", 257);
        selNames.add("none", 256);
        sepNames = new CmndProcess.Lookup(2);
        sepNames.add("on", 1);
        sepNames.add("off", 0);
        out = System.out;
    }

    public CapTest(int nSamp, int rate, boolean debug) {
        this.nSamp = nSamp;
        this.rate = rate;
        this.debug = debug;
        this.topProc.add((CmndProcess.CmndDisp)new TopCmnd(this));
        this.rptProc.add((CmndProcess.CmndDisp)new RptCmnd(this));
    }

    public static void main(String[] args) {
        int rate;
        int nSamp;
        int n = nSamp = args.length >= 1 ? Integer.decode(args[0]) : 1;
        if (nSamp <= 0) {
            nSamp = 1;
        }
        int n2 = rate = args.length >= 2 ? rateNames.encode(args[1], true) : 0;
        if (rate < 0) {
            rate = 0;
        }
        boolean debug = args.length >= 3;
        try {
            new CapTest(nSamp, rate, debug).run();
        }
        catch (Exception e) {
            out.println(e);
        }
        System.exit(0);
    }

    public void run() throws Exception {
        String line;
        this.reader = new ConsoleReader();
        int j = 0;
        while (true) {
            try {
                this.boards.add(new Ad7747Eval(j));
            }
            catch (UsbException usbException) {
                break;
            }
            ++j;
        }
        int nBoard = this.boards.size();
        if (nBoard == 0) {
            out.println("No AD7747 boards found");
            return;
        }
        out.println(String.valueOf(nBoard) + " AD7747 board" + (nBoard == 1 ? "" : "s") + " found");
        out.format("Sample count = %s, rate = %s Hz\n", this.nSamp, rateNames.decode(this.rate));
        this.id = new int[nBoard];
        this.daq = new DaqThread[nBoard];
        this.actvMask = (1 << nBoard) - 1;
        this.doneQueue = new ArrayBlockingQueue(nBoard);
        int j2 = 0;
        while (j2 < nBoard) {
            Ad7747Eval ad = this.boards.get(j2);
            ad.load(false);
            ad.setupStandard();
            ad.setExcEnabled(false);
            ad.setVtEnabled(true);
            this.id[j2] = CapTest.readBoardId(ad);
            ad.setConvMode(1);
            this.daq[j2] = new DaqThread(j2, ad);
            this.daq[j2].start();
            ++j2;
        }
        out.print("Board IDs:");
        j2 = 0;
        while (j2 < nBoard) {
            out.format(" %s", this.id[j2]);
            this.idMask |= 1 << this.id[j2];
            ++j2;
        }
        out.println();
        this.rptConsQueue = new ArrayBlockingQueue(1);
        this.monConsQueue = new ArrayBlockingQueue(1);
        new RptConsThread().start();
        new MonConsThread().start();
        this.monTimer.schedule((TimerTask)this.monData, 0L, 500L);
        while ((line = this.readLine(">> ")) != null && this.topProc.process(line)) {
        }
    }

    private void procSample(int found, Object[] args) {
        if (found == 0) {
            this.doShow(1);
        } else {
            int value = (Integer)args[0];
            if (value > 0) {
                this.nSamp = value;
            } else {
                out.println("Invalid sample count");
            }
        }
    }

    private void procRate(int found, Object[] args) throws UsbException {
        if (found == 0) {
            this.doShow(2);
        } else {
            this.rate = (Integer)args[0];
            int j = 0;
            while (j < this.boards.size()) {
                this.boards.get(j).setCapConvRate(this.rate);
                ++j;
            }
        }
    }

    private void procSelect(int found, Object[] args) {
        if (found == 0) {
            this.doShow(4);
        } else {
            int mask = 0;
            int j = 0;
            while (j < 16) {
                if ((found & 1 << j) != 0) {
                    int value = (Integer)args[j];
                    if (j == 0 && (value == 257 || value == 256)) {
                        if ((found & 0xFFFFFFFE) != 0) {
                            out.println("Too many arguments");
                            mask = -1;
                            break;
                        }
                        if (value == 257) {
                            mask = (1 << this.boards.size()) - 1;
                            break;
                        }
                        mask = 0;
                        break;
                    }
                    if ((this.idMask & 1 << value) == 0) {
                        out.println("Invalid board ID: " + value);
                        mask = -1;
                        break;
                    }
                    mask |= 1 << this.getBoardIndex(value);
                }
                ++j;
            }
            if (mask >= 0) {
                this.actvMask = mask;
            }
        }
    }

    private void procSeparate(int found, Object[] args) {
        if (found == 0) {
            this.doShow(8);
        } else {
            this.sepDaq = (Integer)args[0] == 1;
        }
    }

    private void procPause(int found, Object[] args) {
        if (found == 0) {
            this.doShow(16);
        } else {
            this.pause = (long)(1000.0f * ((Float)args[0]).floatValue());
            if (this.pause < 0L) {
                this.pause = 0L;
            }
        }
    }

    private void procCycle(int found, Object[] args) {
        if (found == 0) {
            this.doShow(32);
        } else {
            this.nCycle = (Integer)args[0];
            if (this.nCycle < 0) {
                this.nCycle = 0;
            }
        }
    }

    private void procShow(int found, Object[] args) {
        this.doShow(-1);
    }

    private void procGo(int found, Object[] args) throws UsbException {
        this.comment = found != 0 ? (String)args[0] : "";
        this.stopMon = false;
        this.runActive = true;
        if (this.nCycle == 1) {
            this.doCycle();
        } else {
            this.repeat = true;
            this.rptConsQueue.offer(0);
            int cycleNum = 0;
            while (this.repeat) {
                out.format("Starting cycle %s...\n", ++cycleNum);
                this.doCycle();
                if (this.repeat && this.pause != 0L) {
                    out.format("Pausing for %s seconds...\n", (double)this.pause / 1000.0);
                    try {
                        Thread.sleep(this.pause);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (cycleNum != this.nCycle) continue;
                this.repeat = false;
            }
        }
        this.runActive = false;
    }

    private void procMonitor(int found, Object[] args) throws UsbException {
        int chan = (found & 1) != 0 ? (Integer)args[0] : 0;
        int j = 0;
        while (j < this.boards.size()) {
            if ((this.actvMask & 1 << j) != 0) {
                Ad7747Eval ad = this.boards.get(j);
                if (chan == 0) {
                    if (!this.sepDaq) {
                        ad.setExcEnabled(true);
                        ad.setCapConvRate(7);
                    } else {
                        ad.setCapConvRate(this.rate);
                    }
                    ad.setCapEnabled(true);
                    ad.setVtEnabled(false);
                } else {
                    ad.setCapEnabled(false);
                    ad.setVtEnabled(true);
                    ad.setVtConvRate(3);
                    int mode = chan == 1 ? 0 : (chan == 2 ? 3 : 2);
                    ad.setVtMode(mode);
                }
            }
            ++j;
        }
        out.println("Monitoring " + chanNames.decode(chan) + ".  Press any key to stop.");
        this.stopMon = false;
        this.monConsQueue.offer(0);
        int[] nexcpt = new int[this.boards.size()];
        while (!this.stopMon) {
            if (chan != 0 || !this.sepDaq) {
                this.nToss = 0;
                this.doDaq(chan, 1);
            } else {
                this.nToss = 2;
                int j2 = 0;
                while (j2 < this.boards.size()) {
                    Ad7747Eval ad = this.boards.get(j2);
                    ad.setExcEnabled(true);
                    this.doDaq(chan, 1, j2);
                    ad.setExcEnabled(false);
                    ++j2;
                }
            }
            if (this.stopMon) break;
            out.print("\r");
            int j3 = 0;
            while (j3 < this.boards.size()) {
                if ((this.actvMask & 1 << j3) != 0) {
                    DaqThread acq = this.daq[j3];
                    out.format("%s %.5g  ", this.id[j3], acq.getMean());
                    int n = j3;
                    nexcpt[n] = nexcpt[n] + acq.getExceptionCount();
                }
                ++j3;
            }
            if (!this.stopMon) continue;
            out.println();
        }
        out.println();
        int j4 = 0;
        while (j4 < this.boards.size()) {
            if ((this.actvMask & 1 << j4) != 0) {
                if (chan == 0 && !this.sepDaq) {
                    this.boards.get(j4).setExcEnabled(false);
                }
                if (nexcpt[j4] != 0) {
                    out.format("Board %s had %s USB exceptions.  First was: %s\n", this.id[j4], nexcpt[j4], this.daq[j4].getException());
                }
            }
            ++j4;
        }
    }

    private void procLog(int found, Object[] args) {
        if ((found & 1) != 0) {
            this.logName = (String)args[0];
        }
        if (this.nEvent != 0) {
            this.logFile.close();
            this.nEvent = 0;
        }
    }

    private void procDac(int found, Object[] args) throws UsbException {
        int index = this.getBoardIndex((Integer)args[0]);
        if (index == -2) {
            return;
        }
        int first = index == -1 ? 0 : index;
        int last = index == -1 ? this.id.length : index + 1;
        int dacs = 3;
        if ((found & 2) != 0) {
            String dac = (String)args[1];
            if (dac.equalsIgnoreCase("a")) {
                dacs = 1;
            } else if (dac.equalsIgnoreCase("b")) {
                dacs = 2;
            } else {
                out.println("Invalid DAC id");
                return;
            }
        }
        if ((found & 0xC) == 0) {
            int j = first;
            while (j < last) {
                Ad7747Eval ad = this.boards.get(j);
                out.print("ID " + this.id[j] + ":");
                if ((dacs & 1) != 0) {
                    out.print("  DAC A: " + (ad.isDacAEnabled() ? "En" : "Dis") + "abled, value = " + ad.getDacAValue());
                }
                if ((dacs & 2) != 0) {
                    out.print("  DAC B: " + (ad.isDacBEnabled() ? "En" : "Dis") + "abled, value = " + ad.getDacBValue());
                }
                out.println();
                ++j;
            }
        } else {
            if (dacs == 3) {
                out.println("DAC id not specified");
                return;
            }
            int j = first;
            while (j < last) {
                Ad7747Eval ad = this.boards.get(j);
                if ((found & 4) != 0) {
                    boolean enable;
                    boolean bl = enable = (Integer)args[2] != 0;
                    if (dacs == 1) {
                        ad.setDacAEnabled(enable);
                    } else {
                        ad.setDacBEnabled(enable);
                    }
                }
                if ((found & 8) != 0) {
                    int value = (Integer)args[3];
                    if (dacs == 1) {
                        ad.setDacAValue(value);
                    } else {
                        ad.setDacBValue(value);
                    }
                }
                ++j;
            }
        }
    }

    private void procLoad(int found, Object[] args) throws UsbException {
        int index = (Integer)args[0];
        Ad7747Eval ad = this.boards.get(index);
        if ((found & 2) == 0) {
            ad.load(false);
        } else {
            ad.load((String)args[1], false);
        }
        ad.setupStandard();
        ad.setVtEnabled(true);
        this.id[index] = CapTest.readBoardId(ad);
    }

    private void doShow(int mask) {
        if ((mask & 1) != 0) {
            out.format("Sample count: %s\n", this.nSamp);
        }
        if ((mask & 2) != 0) {
            out.format("Sampling rate: %s Hz\n", rateNames.decode(this.rate));
        }
        if ((mask & 4) != 0) {
            out.print("Selected boards:");
            if (this.actvMask == 0) {
                out.format(" %s\n", selNames.decode(256));
            } else {
                int j = 0;
                while (j < this.boards.size()) {
                    if ((this.actvMask & 1 << j) != 0) {
                        out.format(" %s", this.id[j]);
                    }
                    ++j;
                }
                if (this.actvMask == (1 << this.boards.size()) - 1) {
                    out.format(" (%s)", selNames.decode(257));
                }
                out.println();
            }
        }
        if ((mask & 8) != 0) {
            out.format("Separate DAQ: %s\n", sepNames.decode(this.sepDaq ? 1 : 0));
        }
        if ((mask & 0x10) != 0) {
            out.format("Pause time: %s secs\n", (double)this.pause / 1000.0);
        }
        if ((mask & 0x20) != 0) {
            out.format("Cycle count: %s%s\n", this.nCycle, this.nCycle == 0 ? " (unlimited)" : "");
        }
    }

    private void doCycle() throws UsbException {
        DaqThread acq;
        int j = 0;
        while (j < this.boards.size()) {
            this.daq[j].clearValue();
            ++j;
        }
        this.monActive = true;
        this.nToss = 2;
        j = 0;
        while (j < this.boards.size()) {
            if ((this.actvMask & 1 << j) != 0) {
                Ad7747Eval ad = this.boards.get(j);
                ad.setExcEnabled(true);
                ad.setCapEnabled(true);
                ad.setCapConvRate(this.rate);
                ad.setVtEnabled(false);
                ad.setVtConvRate(2);
                ad.setVtMode(0);
                if (this.sepDaq) {
                    this.doDaq(0, this.nSamp, j);
                    ad.setExcEnabled(false);
                }
            }
            ++j;
        }
        if (!this.sepDaq) {
            this.doDaq(0, this.nSamp);
        }
        this.monActive = false;
        out.println();
        this.logEvent();
        j = 0;
        while (j < this.boards.size()) {
            if ((this.actvMask & 1 << j) != 0) {
                acq = this.daq[j];
                if (!this.sepDaq) {
                    this.boards.get(j).setExcEnabled(false);
                }
                if (acq.getSampleCount() != 0) {
                    out.format("   %s %.6g %.6g", this.id[j], acq.getMean(), acq.getSigma());
                } else {
                    out.format("   %s --------- -----------", this.id[j]);
                }
            }
            ++j;
        }
        out.println();
        j = 0;
        while (j < this.boards.size()) {
            if ((this.actvMask & 1 << j) != 0 && (acq = this.daq[j]).getExceptionCount() != 0) {
                out.format("Board %s had %s USB exceptions.  First was: %s\n", this.id[j], acq.getExceptionCount(), acq.getException());
            }
            ++j;
        }
    }

    private void doDaq(int chan, int nSamp, int index) {
        if ((this.actvMask & 1 << index) == 0) {
            return;
        }
        this.daqChan = chan;
        this.daqNSamp = nSamp;
        this.daq[index].startRun();
        int done = 0;
        while (done != 1 << index) {
            try {
                Integer value = this.doneQueue.poll(10L, TimeUnit.SECONDS);
                if (value == null) continue;
                done |= 1 << value;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void doDaq(int chan, int nSamp) {
        this.daqChan = chan;
        this.daqNSamp = nSamp;
        int j = 0;
        while (j < this.boards.size()) {
            if ((this.actvMask & 1 << j) != 0) {
                this.daq[j].startRun();
            }
            ++j;
        }
        int done = 0;
        while (done != this.actvMask) {
            try {
                Integer value = this.doneQueue.poll(10L, TimeUnit.SECONDS);
                if (value == null) continue;
                done |= 1 << value;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void logEvent() {
        Date ts = new Date();
        if (this.nEvent == 0) {
            String name = String.valueOf(this.logName) + "_" + String.format("%tY%<tm%<td_%<tH%<tM%<tS", ts) + ".dat";
            try {
                this.logFile = new PrintStream(name);
            }
            catch (IOException e) {
                out.println("Cannot open log file: " + e);
                return;
            }
        }
        this.logFile.format("%tY-%<tm-%<td\t%<tH:%<tM:%<tS\t%s\t%s", ts, this.comment, rateNames.decode(this.rate));
        int j = 0;
        while (j < this.id.length) {
            DaqThread acq = this.daq[j];
            this.logFile.format("\t%s\t%.6g\t%s\t%.6g\t%.6g\t%.6g\t%.6g", this.id[j], acq.getTemperature(), acq.getSampleCount(), acq.getMean(), acq.getSigma(), acq.getError(), acq.getDrift());
            ++j;
        }
        this.logFile.println("\r");
        ++this.nEvent;
    }

    private static int readBoardId(Ad7747Eval ad) throws UsbException {
        float value = ad.readVoltage(7);
        return (int)(10.0f * value + 0.5f);
    }

    private static double readTemperature(Ad7747Eval ad) throws UsbException {
        double temp = 0.0;
        ad.setVtEnabled(true);
        int j = 0;
        while (j < 2) {
            temp = ad.readTemperature(0);
            ++j;
        }
        ad.setVtEnabled(false);
        return temp;
    }

    private int getBoardIndex(int bid) {
        if (bid == -1) {
            return -1;
        }
        int j = 0;
        while (j < this.id.length) {
            if (this.id[j] == bid) {
                return j;
            }
            ++j;
        }
        out.println("Unknown board ID");
        return -2;
    }

    private synchronized String readLine(String prompt) {
        try {
            return this.reader.readLine(prompt);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static void take(ArrayBlockingQueue queue) {
        while (true) {
            try {
                queue.take();
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private static void awaitTerminal() {
        while (true) {
            try {
                while (true) {
                    if (System.in.available() > 0) {
                        return;
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
    }

    private static void clearTerminal() {
        try {
            while (System.in.available() > 0) {
                System.in.read();
            }
        }
        catch (IOException iOException) {}
    }

    class DaqThread
    extends Thread {
        private final int index;
        private final Ad7747Eval ad;
        private final ArrayBlockingQueue<Integer> startQueue;
        private int nvalue;
        private int nexcptn;
        private double value;
        private double mean;
        private double sigma;
        private double error;
        private double drift;
        private double temp;
        private Exception excptn;

        public DaqThread(int index, Ad7747Eval ad) {
            this.index = index;
            this.ad = ad;
            this.startQueue = new ArrayBlockingQueue(1);
        }

        public void clearValue() {
            this.value = 0.0;
        }

        public int getSampleCount() {
            return this.nvalue;
        }

        public double getValue() {
            return this.value;
        }

        public double getMean() {
            return this.mean;
        }

        public double getSigma() {
            return this.sigma;
        }

        public double getError() {
            return this.error;
        }

        public double getDrift() {
            return this.drift;
        }

        public double getTemperature() {
            return this.temp;
        }

        public int getExceptionCount() {
            return this.nexcptn;
        }

        public Exception getException() {
            return this.excptn;
        }

        public void startRun() {
            this.startQueue.offer(0);
        }

        @Override
        public void run() {
            while (true) {
                long millis0;
                double temp0;
                double vtsum;
                double tsqsum;
                double tsum;
                double vsqsum;
                double vsum;
                block16: {
                    try {
                        this.startQueue.take();
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    vsum = 0.0;
                    vsqsum = 0.0;
                    tsum = 0.0;
                    tsqsum = 0.0;
                    vtsum = 0.0;
                    temp0 = 0.0;
                    millis0 = 0L;
                    this.nexcptn = 0;
                    this.nvalue = 0;
                    if (CapTest.this.runActive) {
                        try {
                            temp0 = CapTest.readTemperature(this.ad);
                        }
                        catch (UsbException e) {
                            if (this.nexcptn++ != 0) break block16;
                            this.excptn = e;
                        }
                    }
                }
                int j = -CapTest.this.nToss;
                while (j < CapTest.this.daqNSamp) {
                    block17: {
                        try {
                            this.value = CapTest.this.daqChan == 0 ? (double)this.ad.readCapacitance(0) : (CapTest.this.daqChan == 1 ? (double)this.ad.readTemperature(0) : (CapTest.this.daqChan == 2 ? (double)this.ad.readVoltage(2) : (double)this.ad.readVoltage(0)));
                            if (j >= 0) {
                                long millis = System.currentTimeMillis();
                                if (j == 0) {
                                    millis0 = millis;
                                }
                                double time = (double)(millis - millis0) / 1000.0;
                                vsum += this.value;
                                vsqsum += this.value * this.value;
                                tsum += time;
                                tsqsum += time * time;
                                vtsum += this.value * time;
                                ++this.nvalue;
                            }
                        }
                        catch (UsbException e) {
                            if (this.nexcptn++ != 0) break block17;
                            this.excptn = e;
                        }
                    }
                    ++j;
                }
                if (CapTest.this.runActive) {
                    block18: {
                        try {
                            this.temp = CapTest.readTemperature(this.ad);
                        }
                        catch (UsbException e) {
                            if (this.nexcptn++ != 0) break block18;
                            this.excptn = e;
                        }
                    }
                    this.temp = 0.5 * (this.temp + temp0);
                }
                if (this.nvalue > 0) {
                    double avg;
                    this.mean = avg = vsum / (double)this.nvalue;
                    this.sigma = Math.sqrt(vsqsum / (double)this.nvalue - avg * avg);
                    this.error = this.sigma / (double)this.nvalue;
                } else {
                    this.mean = 0.0;
                    this.sigma = 0.0;
                    this.error = 0.0;
                }
                this.drift = this.nvalue > 1 ? ((double)this.nvalue * vtsum - vsum * tsum) / ((double)this.nvalue * tsqsum - tsum * tsum) : 0.0;
                CapTest.this.doneQueue.offer(this.index);
            }
        }
    }

    class MonConsThread
    extends Thread {
        MonConsThread() {
        }

        @Override
        public void run() {
            while (true) {
                CapTest.take(CapTest.this.monConsQueue);
                CapTest.awaitTerminal();
                CapTest.clearTerminal();
                CapTest.this.stopMon = true;
            }
        }
    }

    class MonitorData
    extends TimerTask {
        MonitorData() {
        }

        @Override
        public void run() {
            if (!CapTest.this.monActive || CapTest.this.stopMon) {
                return;
            }
            out.print("\r");
            int j = 0;
            while (j < CapTest.this.boards.size()) {
                if ((CapTest.this.actvMask & 1 << j) != 0) {
                    out.format("%s %.5g  ", CapTest.this.id[j], CapTest.this.daq[j].getValue());
                }
                ++j;
            }
        }
    }

    static class RptCmnd
    implements CmndProcess.CmndDisp {
        private static final int CMD_STOP = 0;
        private static final int CMD_COMMENT = 1;
        private static final int NUM_CMDS = 2;
        private static final String[] helpStop = new String[]{"Stop repeating DAQ cycles", "stop"};
        private static final String[] helpComment = new String[]{"Set the comment for the current DAQ cycle", "comment <text>", "text  The text of the comment"};
        private static final CmndProcess.Command cmnd = new CmndProcess.Command(2);
        private final CapTest capt;

        static {
            cmnd.add("stop", 0, helpStop, "e", new CmndProcess.Lookup[0]);
            cmnd.add("comment", 1, helpComment, "e", new CmndProcess.Lookup[0]);
        }

        public RptCmnd(CapTest ct) {
            this.capt = ct;
        }

        public CmndProcess.Command getCommand() {
            return cmnd;
        }

        public boolean dispatch(int code, int found, Object[] args) {
            switch (code) {
                case 0: {
                    return false;
                }
                case 1: {
                    if ((found & 1) == 0) break;
                    this.capt.comment = (String)args[0];
                }
            }
            return true;
        }
    }

    class RptConsThread
    extends Thread {
        RptConsThread() {
        }

        @Override
        public void run() {
            block0: while (true) {
                CapTest.take(CapTest.this.rptConsQueue);
                while (true) {
                    if (!CapTest.this.repeat) continue block0;
                    CapTest.awaitTerminal();
                    if (!CapTest.this.repeat) continue;
                    CapTest.clearTerminal();
                    CapTest.this.stopMon = true;
                    out.println();
                    String line = CapTest.this.readLine("*> ");
                    if (line == null || !CapTest.this.rptProc.process(line)) {
                        CapTest.this.repeat = false;
                    }
                    CapTest.this.stopMon = false;
                }
                break;
            }
        }
    }

    static class TopCmnd
    implements CmndProcess.CmndDisp {
        private static final int CMD_SAMPLE = 0;
        private static final int CMD_RATE = 1;
        private static final int CMD_GO = 2;
        private static final int CMD_LOG = 3;
        private static final int CMD_DAC = 4;
        private static final int CMD_MONITOR = 5;
        private static final int CMD_LOAD = 6;
        private static final int CMD_SELECT = 7;
        private static final int CMD_SEPARATE = 8;
        private static final int CMD_CYCLE = 9;
        private static final int CMD_PAUSE = 10;
        private static final int CMD_SHOW = 11;
        private static final int NUM_CMDS = 12;
        private static final String[] helpSample = new String[]{"Show or set the number of samples to be read each DAQ cycle", "sample [<count>]", "count  The number of samples to set"};
        private static final String[] helpRate = new String[]{"Show or set the nominal rate at which samples are acquired", "rate [<value>]", "value  The rate to set (45.5, 41.9, 25.0, 13.2, 8.1, 6.5, 5.5 or 4.6)"};
        private static final String[] helpSelect = new String[]{"Show or select the boards to be used for DAQ", "select [<id1> | all | none] [<id2>]... [<id10>]", "idn  The id of a board to be used"};
        private static final String[] helpSeparate = new String[]{"Show or set separate DAQ mode", "separate [<onoff>]", "onoff  If 'on', DAQ is performed separately for each board", "       If 'off', DAQ is performed on all selected boards simultaneously"};
        private static final String[] helpCycle = new String[]{"Set or show the number of DAQ cycles to perform", "cycle [<count>]", "count   The number of times to perform a cycle (0 = no limit)"};
        private static final String[] helpPause = new String[]{"Set or show the time to pause between DAQ cycles", "pause [<time>]", "time   The time, in seconds, to pause between cycles"};
        private static final String[] helpGo = new String[]{"Perform one or more data acquisition cycles", "go [<comment>]", "comment  A comment to be logged at the end of each cycle"};
        private static final String[] helpLog = new String[]{"Close the log file, and optionally set the name for the next one", "log  [<name>]", "name  The new stem name of the log file: a time stamp is appended"};
        private static final String[] helpShow = new String[]{"Display the values of all the parameters", "show"};
        private static final String[] helpDac = new String[]{"Show or set the state of the capacitance offset DACs", "dac <id> [<dac>] [<enab>] [<value>]", "id     The ID of the board to use, or -1 for all", "dac    The DAC to use, a or b (default is both when showing)", "enab   Enable the DAC if non-zero, disable it if zero", "value  The value to set, 0 - 63: 1 unit ~= 0.28 pF"};
        private static final String[] helpMonitor = new String[]{"Continuously monitor a sensor on each selected board", "monitor [<sensor>]", "sensor  The sensor to read: capacitance, temperature, voltage or vdd"};
        private static final String[] helpLoad = new String[]{"Load a board with its firmware", "load <board>", "board  The index of the board to be loaded"};
        private static final CmndProcess.Command cmnd = new CmndProcess.Command(12);
        private final CapTest capt;

        static {
            cmnd.add("sample", 0, helpSample, "i", new CmndProcess.Lookup[0]);
            cmnd.add("rate", 1, helpRate, "k", new CmndProcess.Lookup[]{rateNames});
            cmnd.add("select", 7, helpSelect, "jiiiiiii", new CmndProcess.Lookup[]{selNames});
            cmnd.add("separate", 8, helpSeparate, "k", new CmndProcess.Lookup[]{sepNames});
            cmnd.add("cycle", 9, helpCycle, "i", new CmndProcess.Lookup[0]);
            cmnd.add("pause", 10, helpPause, "f", new CmndProcess.Lookup[0]);
            cmnd.add("go", 2, helpGo, "e", new CmndProcess.Lookup[0]);
            cmnd.add("log", 3, helpLog, "s", new CmndProcess.Lookup[0]);
            cmnd.add("show", 11, helpShow, "", new CmndProcess.Lookup[0]);
            cmnd.add("dac", 4, helpDac, "Isii", new CmndProcess.Lookup[0]);
            cmnd.add("monitor", 5, helpMonitor, "k", new CmndProcess.Lookup[]{chanNames});
            cmnd.add("load", 6, helpLoad, "Is", new CmndProcess.Lookup[0]);
        }

        public TopCmnd(CapTest ct) {
            this.capt = ct;
        }

        public CmndProcess.Command getCommand() {
            return cmnd;
        }

        public boolean dispatch(int code, int found, Object[] args) {
            try {
                switch (code) {
                    case 2: {
                        this.capt.procGo(found, args);
                        break;
                    }
                    case 5: {
                        this.capt.procMonitor(found, args);
                        break;
                    }
                    case 0: {
                        this.capt.procSample(found, args);
                        break;
                    }
                    case 1: {
                        this.capt.procRate(found, args);
                        break;
                    }
                    case 7: {
                        this.capt.procSelect(found, args);
                        break;
                    }
                    case 8: {
                        this.capt.procSeparate(found, args);
                        break;
                    }
                    case 9: {
                        this.capt.procCycle(found, args);
                        break;
                    }
                    case 10: {
                        this.capt.procPause(found, args);
                        break;
                    }
                    case 11: {
                        this.capt.procShow(found, args);
                        break;
                    }
                    case 4: {
                        this.capt.procDac(found, args);
                        break;
                    }
                    case 3: {
                        this.capt.procLog(found, args);
                        break;
                    }
                    case 6: {
                        this.capt.procLoad(found, args);
                        break;
                    }
                    default: {
                        out.println("Command not fully implemented");
                        break;
                    }
                }
            }
            catch (UsbException e) {
                out.println((Object)e);
            }
            return true;
        }
    }
}

