/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.shell.example;

import java.io.IOException;
import org.lsst.ccs.shell.Command;
import org.lsst.ccs.shell.InputConverter;
import org.lsst.ccs.shell.OutputConverter;
import org.lsst.ccs.shell.Shell;
import org.lsst.ccs.shell.ShellDependent;
import org.lsst.ccs.shell.ShellFactory;
import org.lsst.ccs.shell.example.HelloWorld;

public class Example
implements ShellDependent {
    public static final InputConverter[] CLI_INPUT_CONVERTERS = new InputConverter[]{new InputConverter(){

        @Override
        public Integer convertInput(String original, Class toClass) throws Exception {
            if (toClass.equals(Integer.class)) {
                if (original.equals("one")) {
                    return 1;
                }
                if (original.equals("two")) {
                    return 2;
                }
                if (original.equals("three")) {
                    return 3;
                }
            }
            return null;
        }
    }};
    public static final OutputConverter[] CLI_OUTPUT_CONVERTERS = new OutputConverter[]{new OutputConverter(){

        @Override
        public Object convertOutput(Object o) {
            if (o.getClass().equals(Integer.class)) {
                int num = (Integer)o;
                if (num == 1) {
                    return "one";
                }
                if (num == 2) {
                    return "two";
                }
                if (num == 3) {
                    return "three";
                }
            }
            return null;
        }
    }};
    private Shell shell;

    @Command(description="Varargs example")
    public Integer add(Integer ... numbers) {
        int result = 0;
        Integer[] integerArray = numbers;
        int n = numbers.length;
        int n2 = 0;
        while (n2 < n) {
            int i = integerArray[n2];
            result += i;
            ++n2;
        }
        return result;
    }

    @Override
    public void cliSetShell(Shell shell) {
        this.shell = shell;
    }

    @Command(description="Illustrates the concept of subshells, that can be used to create a tree-like navigation")
    public void Hello() throws IOException {
        ShellFactory.createSubshell("hello", this.shell, "That 'Hello, World!' example", new HelloWorld()).commandLoop();
    }

    public static void main(String[] args) throws IOException {
        ShellFactory.createConsoleShell("example", "The Cliche Shell example\nEnter ?l to list available commands.", (Object)new Example()).commandLoop();
    }
}

