package org.lsst.ccs.subsystem.metrology;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;

/**
 *
 * @author The LSST CCS Team
 */
public class MetrologyConfigurable {

    private final Map<String, Integer> currentParms = new HashMap<>();
    private int min;
    private int max;

    @ConfigurationParameter(name = "rotation", category = "MetrologyConfig")
    private volatile double rotation;
    @ConfigurationParameter(name = "startx", category = "MetrologyConfig")
    private volatile double startx;           // x start
    @ConfigurationParameter(name = "stopx", category = "MetrologyConfig")
    private volatile double stopx;           // x stop
    @ConfigurationParameter(name = "dx", category = "MetrologyConfig")
    private volatile double dx;
    @ConfigurationParameter(name = "starty", category = "MetrologyConfig")
    private volatile double starty;            // y start
    @ConfigurationParameter(name = "stopy", category = "MetrologyConfig")
    private volatile double stopy;          // y stop
    @ConfigurationParameter(name = "dy", category = "MetrologyConfig")
    private volatile double dy;
    @ConfigurationParameter(name = "z", category = "MetrologyConfig")
    private volatile double z;
    @ConfigurationParameter(name = "cornerang", category = "MetrologyConfig")
    private volatile double cornerang;         // trapezium angle 1
    @ConfigurationParameter(name = "nsamples", category = "MetrologyConfig")
    private volatile int    nsamples;
    @ConfigurationParameter(name = "measmode", category = "MetrologyConfig")
    private volatile int    measmode;
    @ConfigurationParameter(name = "acceleration", category = "MetrologyConfig")
    private volatile double acceleration;
    @ConfigurationParameter(name = "speed", category = "MetrologyConfig")
    private volatile double speed;

    final double MIN_X = 0.,
            MAX_X = 300.;
    final double MIN_Y = 0.,
            MAX_Y = 300.;
    final double MIN_Z = 0.,
            MAX_Z = 200.;
    
    public MetrologyConfigurable() {
    }

    
    @ConfigurationParameterChanger(propertyName = "startx")
    public void setStartX(Object StartX) {
        double tmp_startx = (double) StartX;
        assert (tmp_startx > MIN_X);
        assert (tmp_startx < MAX_X);
        System.out.println("configuring startx to "+tmp_startx);
        this.startx = tmp_startx;
    }

    @ConfigurationParameterChanger(propertyName = "stopx")
    public void setStopX(Object StopX) {
        double tmp_stopx = (double) StopX;
        assert (tmp_stopx > MIN_X);
        assert (tmp_stopx < MAX_X);
        System.out.println("configuring stopx to "+tmp_stopx);
        this.stopx = tmp_stopx;
    }

    @ConfigurationParameterChanger(propertyName = "dx")
    public void setdX(Object dX) {
        dx = (double) dX;
 
        System.out.println("configuring dx to "+dx);
    }

        @ConfigurationParameterChanger(propertyName = "starty")
    public void setStartY(Object StartY) {
        double tmp_starty = (double) StartY;
        assert (tmp_starty > MIN_Y);
        assert (tmp_starty < MAX_Y);
        System.out.println("configuring starty to "+tmp_starty);
        starty = tmp_starty;
    }

    @ConfigurationParameterChanger(propertyName = "stopy")
    public void setStopY(Object StopY) {
        double tmp_stopy = (double) StopY;
        assert (tmp_stopy > MIN_Y);
        assert (tmp_stopy < MAX_Y);
        System.out.println("configuring stopy to "+tmp_stopy);
        stopy = tmp_stopy;
    }

    @ConfigurationParameterChanger(propertyName = "dy")
    public void setdY(Object dY) {
        this.dy = (double) dY;
 
        System.out.println("configuring dyto "+dy);
    }

    @ConfigurationParameterChanger(propertyName = "z")
    public void setZ(Object Z) {
        assert ((double)Z > MIN_Z);
        assert ((double)Z < MAX_Z);
        this.z = (double) Z;
 
        System.out.println("configuring z to "+z);
    }

    @ConfigurationParameterChanger(propertyName = "nsamples")
    public void setNSamples(Object nSamples) {
        this.nsamples = (int) nSamples;
 
        System.out.println("configuring number of samples to "+nsamples);
    }
    
    @ConfigurationParameterChanger(propertyName = "rotation")
    public void setRotation(Object rotation) {
        this.rotation = (double) rotation;
    }
    
    @ConfigurationParameterChanger(propertyName = "cornerang")
    public void setCornerang(Object cornerang) {
        this.cornerang = (double) cornerang;
    }
    
    @ConfigurationParameterChanger(propertyName = "measmode")
    public void setMeasmode(Object measmode) {
        this.measmode = (int) measmode;
    }

    @ConfigurationParameterChanger(propertyName = "acceleration")
    public void setAcceleration(Object acceleration) {
        this.acceleration = (double) acceleration;
    }
    
    @ConfigurationParameterChanger(propertyName = "speed")
    public void setSpeed(Object speed) {
        this.speed = (double) speed;
    }
    
    @ConfigurationParameterChanger
    public void setCurrentParms(Object currentParms) {
        Map<String, Integer> map = (Map<String, Integer>) currentParms;
        this.currentParms.putAll(map);
    }


}
